/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core.jmx;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.quartz.CronTrigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.core.jmx.TriggerSupport;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.MutableTrigger;
import org.quartz.spi.OperableTrigger;

public class CronTriggerSupport {
    private static final String COMPOSITE_TYPE_NAME = "CronTrigger";
    private static final String COMPOSITE_TYPE_DESCRIPTION = "CronTrigger Details";
    private static final String[] ITEM_NAMES = new String[]{"expression", "timeZone"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"expression", "timeZone"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
    private static final CompositeType COMPOSITE_TYPE;
    private static final String TABULAR_TYPE_NAME = "CronTrigger collection";
    private static final String TABULAR_TYPE_DESCRIPTION = "CronTrigger collection";
    private static final TabularType TABULAR_TYPE;

    public static String[] getItemNames() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(ITEM_NAMES));
        arrayList.addAll(Arrays.asList(TriggerSupport.getItemNames()));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getItemDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(ITEM_DESCRIPTIONS));
        arrayList.addAll(Arrays.asList(TriggerSupport.getItemDescriptions()));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static OpenType[] getItemTypes() {
        ArrayList<OpenType> arrayList = new ArrayList<OpenType>(Arrays.asList(ITEM_TYPES));
        arrayList.addAll(Arrays.asList(TriggerSupport.getItemTypes()));
        return arrayList.toArray(new OpenType[arrayList.size()]);
    }

    public static CompositeData toCompositeData(CronTrigger cronTrigger) {
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, new Object[]{cronTrigger.getCronExpression(), cronTrigger.getTimeZone(), cronTrigger.getKey().getName(), cronTrigger.getKey().getGroup(), cronTrigger.getJobKey().getName(), cronTrigger.getJobKey().getGroup(), cronTrigger.getDescription(), JobDataMapSupport.toTabularData(cronTrigger.getJobDataMap()), cronTrigger.getCalendarName(), ((OperableTrigger)((Object)cronTrigger)).getFireInstanceId(), cronTrigger.getMisfireInstruction(), cronTrigger.getPriority(), cronTrigger.getStartTime(), cronTrigger.getEndTime(), cronTrigger.getNextFireTime(), cronTrigger.getPreviousFireTime(), cronTrigger.getFinalFireTime()});
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }

    public static TabularData toTabularData(List<? extends CronTrigger> list) {
        TabularDataSupport tabularDataSupport = new TabularDataSupport(TABULAR_TYPE);
        if (list != null) {
            ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>();
            for (CronTrigger cronTrigger : list) {
                arrayList.add(CronTriggerSupport.toCompositeData(cronTrigger));
            }
            tabularDataSupport.putAll(arrayList.toArray(new CompositeData[arrayList.size()]));
        }
        return tabularDataSupport;
    }

    public static OperableTrigger newTrigger(CompositeData compositeData) throws ParseException {
        CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
        cronTriggerImpl.setCronExpression((String)compositeData.get("cronExpression"));
        if (compositeData.containsKey("timeZone")) {
            cronTriggerImpl.setTimeZone(TimeZone.getTimeZone((String)compositeData.get("timeZone")));
        }
        TriggerSupport.initializeTrigger((MutableTrigger)cronTriggerImpl, compositeData);
        return cronTriggerImpl;
    }

    public static OperableTrigger newTrigger(Map<String, Object> map) throws ParseException {
        CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
        cronTriggerImpl.setCronExpression((String)map.get("cronExpression"));
        if (map.containsKey("timeZone")) {
            cronTriggerImpl.setTimeZone(TimeZone.getTimeZone((String)map.get("timeZone")));
        }
        TriggerSupport.initializeTrigger((MutableTrigger)cronTriggerImpl, map);
        return cronTriggerImpl;
    }

    static {
        try {
            COMPOSITE_TYPE = new CompositeType(COMPOSITE_TYPE_NAME, COMPOSITE_TYPE_DESCRIPTION, CronTriggerSupport.getItemNames(), CronTriggerSupport.getItemDescriptions(), CronTriggerSupport.getItemTypes());
            TABULAR_TYPE = new TabularType("CronTrigger collection", "CronTrigger collection", COMPOSITE_TYPE, CronTriggerSupport.getItemNames());
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }
}

