/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.quartz.Calendar;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Matcher;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.ErrorLogger;
import org.quartz.core.ExecutingJobsManager;
import org.quartz.core.ListenerManagerImpl;
import org.quartz.core.QuartzSchedulerMBeanImpl;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.QuartzSchedulerThread;
import org.quartz.core.RemotableQuartzScheduler;
import org.quartz.core.SchedulerSignalerImpl;
import org.quartz.core.jmx.QuartzSchedulerMBean;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.PropertySettingJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.ThreadExecutor;
import org.quartz.utils.UpdateChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzScheduler
implements RemotableQuartzScheduler {
    private static String VERSION_MAJOR = "UNKNOWN";
    private static String VERSION_MINOR = "UNKNOWN";
    private static String VERSION_ITERATION = "UNKNOWN";
    private QuartzSchedulerResources resources;
    private QuartzSchedulerThread schedThread;
    private ThreadGroup threadGroup;
    private SchedulerContext context = new SchedulerContext();
    private ListenerManager listenerManager = new ListenerManagerImpl();
    private HashMap<String, JobListener> internalJobListeners = new HashMap(10);
    private HashMap<String, TriggerListener> internalTriggerListeners = new HashMap(10);
    private ArrayList<SchedulerListener> internalSchedulerListeners = new ArrayList(10);
    private JobFactory jobFactory = new PropertySettingJobFactory();
    ExecutingJobsManager jobMgr = null;
    ErrorLogger errLogger = null;
    private SchedulerSignaler signaler;
    private Random random = new Random();
    private ArrayList<Object> holdToPreventGC = new ArrayList(5);
    private boolean signalOnSchedulingChange = true;
    private volatile boolean closed = false;
    private volatile boolean shuttingDown = false;
    private boolean boundRemotely = false;
    private QuartzSchedulerMBean jmxBean = null;
    private Date initialStart = null;
    private final Timer updateTimer;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public QuartzScheduler(QuartzSchedulerResources quartzSchedulerResources, long l, @Deprecated long l2) throws SchedulerException {
        this.resources = quartzSchedulerResources;
        if (quartzSchedulerResources.getJobStore() instanceof JobListener) {
            this.addInternalJobListener((JobListener)((Object)quartzSchedulerResources.getJobStore()));
        }
        this.schedThread = new QuartzSchedulerThread(this, quartzSchedulerResources);
        ThreadExecutor threadExecutor = quartzSchedulerResources.getThreadExecutor();
        threadExecutor.execute(this.schedThread);
        if (l > 0L) {
            this.schedThread.setIdleWaitTime(l);
        }
        this.jobMgr = new ExecutingJobsManager();
        this.addInternalJobListener(this.jobMgr);
        this.errLogger = new ErrorLogger();
        this.addInternalSchedulerListener(this.errLogger);
        this.signaler = new SchedulerSignalerImpl(this, this.schedThread);
        this.updateTimer = this.shouldRunUpdateCheck() ? this.scheduleUpdateCheck() : null;
        this.getLog().info("Quartz Scheduler v." + this.getVersion() + " created.");
    }

    public void initialize() throws SchedulerException {
        try {
            this.bind();
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to bind scheduler to RMI Registry.", exception);
        }
        if (this.resources.getJMXExport()) {
            try {
                this.registerJMX();
            }
            catch (Exception exception) {
                throw new SchedulerException("Unable to register scheduler with MBeanServer.", exception);
            }
        }
        this.getLog().info("Scheduler meta-data: " + new SchedulerMetaData(this.getSchedulerName(), this.getSchedulerInstanceId(), this.getClass(), this.boundRemotely, this.runningSince() != null, this.isInStandbyMode(), this.isShutdown(), this.runningSince(), this.numJobsExecuted(), this.getJobStoreClass(), this.supportsPersistence(), this.isClustered(), this.getThreadPoolClass(), this.getThreadPoolSize(), this.getVersion()).toString());
    }

    @Override
    public String getVersion() {
        return QuartzScheduler.getVersionMajor() + "." + QuartzScheduler.getVersionMinor() + "." + QuartzScheduler.getVersionIteration();
    }

    public static String getVersionMajor() {
        return VERSION_MAJOR;
    }

    private boolean shouldRunUpdateCheck() {
        return this.resources.isRunUpdateCheck() && !Boolean.getBoolean("org.quartz.scheduler.skipUpdateCheck") && !Boolean.getBoolean("org.terracotta.quartz.skipUpdateCheck");
    }

    public static String getVersionMinor() {
        return VERSION_MINOR;
    }

    public static String getVersionIteration() {
        return VERSION_ITERATION;
    }

    public SchedulerSignaler getSchedulerSignaler() {
        return this.signaler;
    }

    public Logger getLog() {
        return this.log;
    }

    private Timer scheduleUpdateCheck() {
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)new UpdateChecker(), 1000L, 604800000L);
        return timer;
    }

    private void registerJMX() throws Exception {
        String string = this.resources.getJMXObjectName();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.jmxBean = new QuartzSchedulerMBeanImpl(this);
        mBeanServer.registerMBean(this.jmxBean, new ObjectName(string));
    }

    private void unregisterJMX() throws Exception {
        String string = this.resources.getJMXObjectName();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        mBeanServer.unregisterMBean(new ObjectName(string));
        this.jmxBean.setSampledStatisticsEnabled(false);
        this.getLog().info("Scheduler unregistered from name '" + string + "' in the local MBeanServer.");
    }

    private void bind() throws RemoteException {
        String string = this.resources.getRMIRegistryHost();
        if (string == null || string.length() == 0) {
            return;
        }
        RemotableQuartzScheduler remotableQuartzScheduler = null;
        remotableQuartzScheduler = this.resources.getRMIServerPort() > 0 ? (RemotableQuartzScheduler)UnicastRemoteObject.exportObject((Remote)this, this.resources.getRMIServerPort()) : (RemotableQuartzScheduler)((Object)UnicastRemoteObject.exportObject(this));
        Registry registry = null;
        if (this.resources.getRMICreateRegistryStrategy().equals("as_needed")) {
            try {
                registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryPort());
                registry.list();
            }
            catch (Exception exception) {
                registry = LocateRegistry.createRegistry(this.resources.getRMIRegistryPort());
            }
        } else if (this.resources.getRMICreateRegistryStrategy().equals("always")) {
            try {
                registry = LocateRegistry.createRegistry(this.resources.getRMIRegistryPort());
            }
            catch (Exception exception) {
                registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryPort());
            }
        } else {
            registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryHost(), this.resources.getRMIRegistryPort());
        }
        String string2 = this.resources.getRMIBindName();
        registry.rebind(string2, remotableQuartzScheduler);
        this.boundRemotely = true;
        this.getLog().info("Scheduler bound to RMI registry under name '" + string2 + "'");
    }

    private void unBind() throws RemoteException {
        String string = this.resources.getRMIRegistryHost();
        if (string == null || string.length() == 0) {
            return;
        }
        Registry registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryHost(), this.resources.getRMIRegistryPort());
        String string2 = this.resources.getRMIBindName();
        try {
            registry.unbind(string2);
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
        this.getLog().info("Scheduler un-bound from name '" + string2 + "' in RMI registry");
    }

    @Override
    public String getSchedulerName() {
        return this.resources.getName();
    }

    @Override
    public String getSchedulerInstanceId() {
        return this.resources.getInstanceId();
    }

    public ThreadGroup getSchedulerThreadGroup() {
        if (this.threadGroup == null) {
            this.threadGroup = new ThreadGroup("QuartzScheduler:" + this.getSchedulerName());
            if (this.resources.getMakeSchedulerThreadDaemon()) {
                this.threadGroup.setDaemon(true);
            }
        }
        return this.threadGroup;
    }

    public void addNoGCObject(Object object) {
        this.holdToPreventGC.add(object);
    }

    public boolean removeNoGCObject(Object object) {
        return this.holdToPreventGC.remove(object);
    }

    @Override
    public SchedulerContext getSchedulerContext() throws SchedulerException {
        return this.context;
    }

    public boolean isSignalOnSchedulingChange() {
        return this.signalOnSchedulingChange;
    }

    public void setSignalOnSchedulingChange(boolean bl) {
        this.signalOnSchedulingChange = bl;
    }

    @Override
    public void start() throws SchedulerException {
        if (this.shuttingDown || this.closed) {
            throw new SchedulerException("The Scheduler cannot be restarted after shutdown() has been called.");
        }
        this.notifySchedulerListenersStarting();
        if (this.initialStart == null) {
            this.initialStart = new Date();
            this.resources.getJobStore().schedulerStarted();
            this.startPlugins();
        } else {
            this.resources.getJobStore().schedulerResumed();
        }
        this.schedThread.togglePause(false);
        this.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " started.");
        this.notifySchedulerListenersStarted();
    }

    @Override
    public void startDelayed(final int n) throws SchedulerException {
        if (this.shuttingDown || this.closed) {
            throw new SchedulerException("The Scheduler cannot be restarted after shutdown() has been called.");
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep((long)n * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    QuartzScheduler.this.start();
                }
                catch (SchedulerException schedulerException) {
                    QuartzScheduler.this.getLog().error("Unable to start secheduler after startup delay.", schedulerException);
                }
            }
        });
        thread.start();
    }

    @Override
    public void standby() {
        this.resources.getJobStore().schedulerPaused();
        this.schedThread.togglePause(true);
        this.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " paused.");
        this.notifySchedulerListenersInStandbyMode();
    }

    @Override
    public boolean isInStandbyMode() {
        return this.schedThread.isPaused();
    }

    @Override
    public Date runningSince() {
        if (this.initialStart == null) {
            return null;
        }
        return new Date(this.initialStart.getTime());
    }

    @Override
    public int numJobsExecuted() {
        return this.jobMgr.getNumJobsFired();
    }

    @Override
    public Class<?> getJobStoreClass() {
        return this.resources.getJobStore().getClass();
    }

    @Override
    public boolean supportsPersistence() {
        return this.resources.getJobStore().supportsPersistence();
    }

    @Override
    public boolean isClustered() {
        return this.resources.getJobStore().isClustered();
    }

    @Override
    public Class<?> getThreadPoolClass() {
        return this.resources.getThreadPool().getClass();
    }

    @Override
    public int getThreadPoolSize() {
        return this.resources.getThreadPool().getPoolSize();
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public void shutdown(boolean bl) {
        if (this.shuttingDown || this.closed) {
            return;
        }
        this.shuttingDown = true;
        this.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " shutting down.");
        this.standby();
        this.schedThread.halt(bl);
        this.notifySchedulerListenersShuttingdown();
        if (this.resources.isInterruptJobsOnShutdown() && !bl || this.resources.isInterruptJobsOnShutdownWithWait() && bl) {
            List<JobExecutionContext> list = this.getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : list) {
                if (!(jobExecutionContext.getJobInstance() instanceof InterruptableJob)) continue;
                try {
                    ((InterruptableJob)jobExecutionContext.getJobInstance()).interrupt();
                }
                catch (Throwable throwable) {
                    this.getLog().warn("Encountered error when interrupting job {} during shutdown: {}", (Object)jobExecutionContext.getJobDetail().getKey(), (Object)throwable);
                }
            }
        }
        this.resources.getThreadPool().shutdown(bl);
        this.closed = true;
        if (this.resources.getJMXExport()) {
            try {
                this.unregisterJMX();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.boundRemotely) {
            try {
                this.unBind();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.shutdownPlugins();
        this.resources.getJobStore().shutdown();
        this.notifySchedulerListenersShutdown();
        SchedulerRepository.getInstance().remove(this.resources.getName());
        this.holdToPreventGC.clear();
        if (this.updateTimer != null) {
            this.updateTimer.cancel();
        }
        this.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " shutdown complete.");
    }

    @Override
    public boolean isShutdown() {
        return this.closed;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public boolean isStarted() {
        return !this.shuttingDown && !this.closed && !this.isInStandbyMode() && this.initialStart != null;
    }

    public void validateState() throws SchedulerException {
        if (this.isShutdown()) {
            throw new SchedulerException("The Scheduler has been shutdown.");
        }
    }

    @Override
    public List<JobExecutionContext> getCurrentlyExecutingJobs() {
        return this.jobMgr.getExecutingJobs();
    }

    @Override
    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        Date date;
        this.validateState();
        if (jobDetail == null) {
            throw new SchedulerException("JobDetail cannot be null");
        }
        if (trigger == null) {
            throw new SchedulerException("Trigger cannot be null");
        }
        if (jobDetail.getKey() == null) {
            throw new SchedulerException("Job's key cannot be null");
        }
        if (jobDetail.getJobClass() == null) {
            throw new SchedulerException("Job's class cannot be null");
        }
        OperableTrigger operableTrigger = (OperableTrigger)trigger;
        if (trigger.getJobKey() == null) {
            operableTrigger.setJobKey(jobDetail.getKey());
        } else if (!trigger.getJobKey().equals(jobDetail.getKey())) {
            throw new SchedulerException("Trigger does not reference given job!");
        }
        operableTrigger.validate();
        Calendar calendar = null;
        if (trigger.getCalendarName() != null) {
            calendar = this.resources.getJobStore().retrieveCalendar(trigger.getCalendarName());
        }
        if ((date = operableTrigger.computeFirstFireTime(calendar)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger '" + trigger.getKey() + "' will never fire.");
        }
        this.resources.getJobStore().storeJobAndTrigger(jobDetail, operableTrigger);
        this.notifySchedulerListenersJobAdded(jobDetail);
        this.notifySchedulerThread(trigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(trigger);
        return date;
    }

    @Override
    public Date scheduleJob(Trigger trigger) throws SchedulerException {
        this.validateState();
        if (trigger == null) {
            throw new SchedulerException("Trigger cannot be null");
        }
        OperableTrigger operableTrigger = (OperableTrigger)trigger;
        operableTrigger.validate();
        Calendar calendar = null;
        if (trigger.getCalendarName() != null && (calendar = this.resources.getJobStore().retrieveCalendar(trigger.getCalendarName())) == null) {
            throw new SchedulerException("Calendar not found: " + trigger.getCalendarName());
        }
        Date date = operableTrigger.computeFirstFireTime(calendar);
        if (date == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger '" + trigger.getKey() + "' will never fire.");
        }
        this.resources.getJobStore().storeTrigger(operableTrigger, false);
        this.notifySchedulerThread(trigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(trigger);
        return date;
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean bl) throws SchedulerException {
        this.addJob(jobDetail, bl, false);
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean bl, boolean bl2) throws SchedulerException {
        this.validateState();
        if (!bl2 && !jobDetail.isDurable()) {
            throw new SchedulerException("Jobs added with no trigger must be durable.");
        }
        this.resources.getJobStore().storeJob(jobDetail, bl);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersJobAdded(jobDetail);
    }

    @Override
    public boolean deleteJob(JobKey jobKey) throws SchedulerException {
        this.validateState();
        boolean bl = false;
        List<? extends Trigger> list = this.getTriggersOfJob(jobKey);
        for (Trigger trigger : list) {
            if (!this.unscheduleJob(trigger.getKey())) {
                StringBuilder stringBuilder = new StringBuilder().append("Unable to unschedule trigger [").append(trigger.getKey()).append("] while deleting job [").append(jobKey).append("]");
                throw new SchedulerException(stringBuilder.toString());
            }
            bl = true;
        }
        boolean bl2 = bl = this.resources.getJobStore().removeJob(jobKey) || bl;
        if (bl) {
            this.notifySchedulerThread(0L);
            this.notifySchedulerListenersJobDeleted(jobKey);
        }
        return bl;
    }

    @Override
    public boolean deleteJobs(List<JobKey> list) throws SchedulerException {
        this.validateState();
        boolean bl = false;
        bl = this.resources.getJobStore().removeJobs(list);
        this.notifySchedulerThread(0L);
        for (JobKey jobKey : list) {
            this.notifySchedulerListenersJobDeleted(jobKey);
        }
        return bl;
    }

    @Override
    public void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) throws SchedulerException {
        this.validateState();
        for (Map.Entry<JobDetail, Set<? extends Trigger>> entry : map.entrySet()) {
            Set<? extends Trigger> set;
            JobDetail jobDetail = entry.getKey();
            if (jobDetail == null || (set = entry.getValue()) == null) continue;
            for (Trigger trigger : set) {
                OperableTrigger operableTrigger = (OperableTrigger)trigger;
                operableTrigger.setJobKey(jobDetail.getKey());
                operableTrigger.validate();
                Calendar calendar = null;
                if (trigger.getCalendarName() != null && (calendar = this.resources.getJobStore().retrieveCalendar(trigger.getCalendarName())) == null) {
                    throw new SchedulerException("Calendar '" + trigger.getCalendarName() + "' not found for trigger: " + trigger.getKey());
                }
                Date date = operableTrigger.computeFirstFireTime(calendar);
                if (date != null) continue;
                throw new SchedulerException("Based on configured schedule, the given trigger will never fire.");
            }
        }
        this.resources.getJobStore().storeJobsAndTriggers(map, bl);
        this.notifySchedulerThread(0L);
        for (JobDetail jobDetail : map.keySet()) {
            this.notifySchedulerListenersJobAdded(jobDetail);
        }
    }

    @Override
    public void scheduleJob(JobDetail jobDetail, Set<? extends Trigger> set, boolean bl) throws SchedulerException {
        HashMap<JobDetail, Set<? extends Trigger>> hashMap = new HashMap<JobDetail, Set<? extends Trigger>>();
        hashMap.put(jobDetail, set);
        this.scheduleJobs(hashMap, bl);
    }

    @Override
    public boolean unscheduleJobs(List<TriggerKey> list) throws SchedulerException {
        this.validateState();
        boolean bl = false;
        bl = this.resources.getJobStore().removeTriggers(list);
        this.notifySchedulerThread(0L);
        for (TriggerKey triggerKey : list) {
            this.notifySchedulerListenersUnscheduled(triggerKey);
        }
        return bl;
    }

    @Override
    public boolean unscheduleJob(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        if (!this.resources.getJobStore().removeTrigger(triggerKey)) {
            return false;
        }
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersUnscheduled(triggerKey);
        return true;
    }

    @Override
    public Date rescheduleJob(TriggerKey triggerKey, Trigger trigger) throws SchedulerException {
        Date date;
        this.validateState();
        if (triggerKey == null) {
            throw new IllegalArgumentException("triggerKey cannot be null");
        }
        if (trigger == null) {
            throw new IllegalArgumentException("newTrigger cannot be null");
        }
        OperableTrigger operableTrigger = (OperableTrigger)trigger;
        Trigger trigger2 = this.getTrigger(triggerKey);
        if (trigger2 == null) {
            return null;
        }
        operableTrigger.setJobKey(trigger2.getJobKey());
        operableTrigger.validate();
        Calendar calendar = null;
        if (trigger.getCalendarName() != null) {
            calendar = this.resources.getJobStore().retrieveCalendar(trigger.getCalendarName());
        }
        if ((date = operableTrigger.computeFirstFireTime(calendar)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.");
        }
        if (!this.resources.getJobStore().replaceTrigger(triggerKey, operableTrigger)) {
            return null;
        }
        this.notifySchedulerThread(trigger.getNextFireTime().getTime());
        this.notifySchedulerListenersUnscheduled(triggerKey);
        this.notifySchedulerListenersSchduled(trigger);
        return date;
    }

    private String newTriggerId() {
        long l = this.random.nextLong();
        if (l < 0L) {
            l = -l;
        }
        return "MT_" + Long.toString(l, 30 + (int)(System.currentTimeMillis() % 7L));
    }

    @Override
    public void triggerJob(JobKey jobKey, JobDataMap jobDataMap) throws SchedulerException {
        this.validateState();
        OperableTrigger operableTrigger = (OperableTrigger)TriggerBuilder.newTrigger().withIdentity(this.newTriggerId(), "DEFAULT").forJob(jobKey).build();
        operableTrigger.computeFirstFireTime(null);
        if (jobDataMap != null) {
            operableTrigger.setJobDataMap(jobDataMap);
        }
        boolean bl = true;
        while (bl) {
            try {
                this.resources.getJobStore().storeTrigger(operableTrigger, false);
                bl = false;
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                operableTrigger.setKey(new TriggerKey(this.newTriggerId(), "DEFAULT"));
            }
        }
        this.notifySchedulerThread(operableTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(operableTrigger);
    }

    @Override
    public void triggerJob(OperableTrigger operableTrigger) throws SchedulerException {
        this.validateState();
        operableTrigger.computeFirstFireTime(null);
        boolean bl = true;
        while (bl) {
            try {
                this.resources.getJobStore().storeTrigger(operableTrigger, false);
                bl = false;
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                operableTrigger.setKey(new TriggerKey(this.newTriggerId(), "DEFAULT"));
            }
        }
        this.notifySchedulerThread(operableTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(operableTrigger);
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().pauseTrigger(triggerKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedTrigger(triggerKey);
    }

    @Override
    public void pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) throws SchedulerException {
        this.validateState();
        if (groupMatcher == null) {
            groupMatcher = GroupMatcher.groupEquals("DEFAULT");
        }
        Collection<String> collection = this.resources.getJobStore().pauseTriggers(groupMatcher);
        this.notifySchedulerThread(0L);
        for (String string : collection) {
            this.notifySchedulerListenersPausedTriggers(string);
        }
    }

    @Override
    public void pauseJob(JobKey jobKey) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().pauseJob(jobKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedJob(jobKey);
    }

    @Override
    public void pauseJobs(GroupMatcher<JobKey> groupMatcher) throws SchedulerException {
        this.validateState();
        if (groupMatcher == null) {
            groupMatcher = GroupMatcher.groupEquals("DEFAULT");
        }
        Collection<String> collection = this.resources.getJobStore().pauseJobs(groupMatcher);
        this.notifySchedulerThread(0L);
        for (String string : collection) {
            this.notifySchedulerListenersPausedJobs(string);
        }
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().resumeTrigger(triggerKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedTrigger(triggerKey);
    }

    @Override
    public void resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) throws SchedulerException {
        this.validateState();
        if (groupMatcher == null) {
            groupMatcher = GroupMatcher.groupEquals("DEFAULT");
        }
        Collection<String> collection = this.resources.getJobStore().resumeTriggers(groupMatcher);
        this.notifySchedulerThread(0L);
        for (String string : collection) {
            this.notifySchedulerListenersResumedTriggers(string);
        }
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws SchedulerException {
        return this.resources.getJobStore().getPausedTriggerGroups();
    }

    @Override
    public void resumeJob(JobKey jobKey) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().resumeJob(jobKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedJob(jobKey);
    }

    @Override
    public void resumeJobs(GroupMatcher<JobKey> groupMatcher) throws SchedulerException {
        this.validateState();
        if (groupMatcher == null) {
            groupMatcher = GroupMatcher.groupEquals("DEFAULT");
        }
        Collection<String> collection = this.resources.getJobStore().resumeJobs(groupMatcher);
        this.notifySchedulerThread(0L);
        for (String string : collection) {
            this.notifySchedulerListenersResumedJobs(string);
        }
    }

    @Override
    public void pauseAll() throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().pauseAll();
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedTriggers(null);
    }

    @Override
    public void resumeAll() throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().resumeAll();
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedTrigger(null);
    }

    @Override
    public List<String> getJobGroupNames() throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getJobGroupNames();
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) throws SchedulerException {
        this.validateState();
        if (groupMatcher == null) {
            groupMatcher = GroupMatcher.groupEquals("DEFAULT");
        }
        return this.resources.getJobStore().getJobKeys(groupMatcher);
    }

    @Override
    public List<? extends Trigger> getTriggersOfJob(JobKey jobKey) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getTriggersForJob(jobKey);
    }

    @Override
    public List<String> getTriggerGroupNames() throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getTriggerGroupNames();
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) throws SchedulerException {
        this.validateState();
        if (groupMatcher == null) {
            groupMatcher = GroupMatcher.groupEquals("DEFAULT");
        }
        return this.resources.getJobStore().getTriggerKeys(groupMatcher);
    }

    @Override
    public JobDetail getJobDetail(JobKey jobKey) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().retrieveJob(jobKey);
    }

    @Override
    public Trigger getTrigger(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().retrieveTrigger(triggerKey);
    }

    @Override
    public boolean checkExists(JobKey jobKey) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().checkExists(jobKey);
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().checkExists(triggerKey);
    }

    @Override
    public void clear() throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().clearAllSchedulingData();
        this.notifySchedulerListenersUnscheduled(null);
    }

    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getTriggerState(triggerKey);
    }

    @Override
    public void addCalendar(String string, Calendar calendar, boolean bl, boolean bl2) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().storeCalendar(string, calendar, bl, bl2);
    }

    @Override
    public boolean deleteCalendar(String string) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().removeCalendar(string);
    }

    @Override
    public Calendar getCalendar(String string) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().retrieveCalendar(string);
    }

    @Override
    public List<String> getCalendarNames() throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getCalendarNames();
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalJobListener(JobListener jobListener) {
        if (jobListener.getName() == null || jobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        HashMap<String, JobListener> hashMap = this.internalJobListeners;
        synchronized (hashMap) {
            this.internalJobListeners.put(jobListener.getName(), jobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInternalJobListener(String string) {
        HashMap<String, JobListener> hashMap = this.internalJobListeners;
        synchronized (hashMap) {
            return this.internalJobListeners.remove(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobListener> getInternalJobListeners() {
        HashMap<String, JobListener> hashMap = this.internalJobListeners;
        synchronized (hashMap) {
            return Collections.unmodifiableList(new LinkedList<JobListener>(this.internalJobListeners.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobListener getInternalJobListener(String string) {
        HashMap<String, JobListener> hashMap = this.internalJobListeners;
        synchronized (hashMap) {
            return this.internalJobListeners.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalTriggerListener(TriggerListener triggerListener) {
        if (triggerListener.getName() == null || triggerListener.getName().length() == 0) {
            throw new IllegalArgumentException("TriggerListener name cannot be empty.");
        }
        HashMap<String, TriggerListener> hashMap = this.internalTriggerListeners;
        synchronized (hashMap) {
            this.internalTriggerListeners.put(triggerListener.getName(), triggerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeinternalTriggerListener(String string) {
        HashMap<String, TriggerListener> hashMap = this.internalTriggerListeners;
        synchronized (hashMap) {
            return this.internalTriggerListeners.remove(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TriggerListener> getInternalTriggerListeners() {
        HashMap<String, TriggerListener> hashMap = this.internalTriggerListeners;
        synchronized (hashMap) {
            return Collections.unmodifiableList(new LinkedList<TriggerListener>(this.internalTriggerListeners.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriggerListener getInternalTriggerListener(String string) {
        HashMap<String, TriggerListener> hashMap = this.internalTriggerListeners;
        synchronized (hashMap) {
            return this.internalTriggerListeners.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalSchedulerListener(SchedulerListener schedulerListener) {
        ArrayList<SchedulerListener> arrayList = this.internalSchedulerListeners;
        synchronized (arrayList) {
            this.internalSchedulerListeners.add(schedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInternalSchedulerListener(SchedulerListener schedulerListener) {
        ArrayList<SchedulerListener> arrayList = this.internalSchedulerListeners;
        synchronized (arrayList) {
            return this.internalSchedulerListeners.remove(schedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SchedulerListener> getInternalSchedulerListeners() {
        ArrayList<SchedulerListener> arrayList = this.internalSchedulerListeners;
        synchronized (arrayList) {
            return Collections.unmodifiableList(new ArrayList<SchedulerListener>(this.internalSchedulerListeners));
        }
    }

    protected void notifyJobStoreJobComplete(OperableTrigger operableTrigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction completedExecutionInstruction) {
        this.resources.getJobStore().triggeredJobComplete(operableTrigger, jobDetail, completedExecutionInstruction);
    }

    protected void notifyJobStoreJobVetoed(OperableTrigger operableTrigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction completedExecutionInstruction) {
        this.resources.getJobStore().triggeredJobComplete(operableTrigger, jobDetail, completedExecutionInstruction);
    }

    protected void notifySchedulerThread(long l) {
        if (this.isSignalOnSchedulingChange()) {
            this.signaler.signalSchedulingChange(l);
        }
    }

    private List<TriggerListener> buildTriggerListenerList() throws SchedulerException {
        LinkedList<TriggerListener> linkedList = new LinkedList<TriggerListener>();
        linkedList.addAll(this.getListenerManager().getTriggerListeners());
        linkedList.addAll(this.getInternalTriggerListeners());
        return linkedList;
    }

    private List<JobListener> buildJobListenerList() throws SchedulerException {
        LinkedList<JobListener> linkedList = new LinkedList<JobListener>();
        linkedList.addAll(this.getListenerManager().getJobListeners());
        linkedList.addAll(this.getInternalJobListeners());
        return linkedList;
    }

    private List<SchedulerListener> buildSchedulerListenerList() {
        LinkedList<SchedulerListener> linkedList = new LinkedList<SchedulerListener>();
        linkedList.addAll(this.getListenerManager().getSchedulerListeners());
        linkedList.addAll(this.getInternalSchedulerListeners());
        return linkedList;
    }

    private boolean matchJobListener(JobListener jobListener, JobKey jobKey) {
        List<Matcher<JobKey>> list = this.getListenerManager().getJobListenerMatchers(jobListener.getName());
        if (list == null) {
            return true;
        }
        for (Matcher<JobKey> matcher : list) {
            if (!matcher.isMatch(jobKey)) continue;
            return true;
        }
        return false;
    }

    private boolean matchTriggerListener(TriggerListener triggerListener, TriggerKey triggerKey) {
        List<Matcher<TriggerKey>> list = this.getListenerManager().getTriggerListenerMatchers(triggerListener.getName());
        if (list == null) {
            return true;
        }
        for (Matcher<TriggerKey> matcher : list) {
            if (!matcher.isMatch(triggerKey)) continue;
            return true;
        }
        return false;
    }

    public boolean notifyTriggerListenersFired(JobExecutionContext jobExecutionContext) throws SchedulerException {
        boolean bl = false;
        List<TriggerListener> list = this.buildTriggerListenerList();
        for (TriggerListener triggerListener : list) {
            try {
                if (!this.matchTriggerListener(triggerListener, jobExecutionContext.getTrigger().getKey())) continue;
                triggerListener.triggerFired(jobExecutionContext.getTrigger(), jobExecutionContext);
                if (!triggerListener.vetoJobExecution(jobExecutionContext.getTrigger(), jobExecutionContext)) continue;
                bl = true;
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("TriggerListener '" + triggerListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
        return bl;
    }

    public void notifyTriggerListenersMisfired(Trigger trigger) throws SchedulerException {
        List<TriggerListener> list = this.buildTriggerListenerList();
        for (TriggerListener triggerListener : list) {
            try {
                if (!this.matchTriggerListener(triggerListener, trigger.getKey())) continue;
                triggerListener.triggerMisfired(trigger);
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("TriggerListener '" + triggerListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
    }

    public void notifyTriggerListenersComplete(JobExecutionContext jobExecutionContext, Trigger.CompletedExecutionInstruction completedExecutionInstruction) throws SchedulerException {
        List<TriggerListener> list = this.buildTriggerListenerList();
        for (TriggerListener triggerListener : list) {
            try {
                if (!this.matchTriggerListener(triggerListener, jobExecutionContext.getTrigger().getKey())) continue;
                triggerListener.triggerComplete(jobExecutionContext.getTrigger(), jobExecutionContext, completedExecutionInstruction);
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("TriggerListener '" + triggerListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
    }

    public void notifyJobListenersToBeExecuted(JobExecutionContext jobExecutionContext) throws SchedulerException {
        List<JobListener> list = this.buildJobListenerList();
        for (JobListener jobListener : list) {
            try {
                if (!this.matchJobListener(jobListener, jobExecutionContext.getJobDetail().getKey())) continue;
                jobListener.jobToBeExecuted(jobExecutionContext);
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("JobListener '" + jobListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
    }

    public void notifyJobListenersWasVetoed(JobExecutionContext jobExecutionContext) throws SchedulerException {
        List<JobListener> list = this.buildJobListenerList();
        for (JobListener jobListener : list) {
            try {
                if (!this.matchJobListener(jobListener, jobExecutionContext.getJobDetail().getKey())) continue;
                jobListener.jobExecutionVetoed(jobExecutionContext);
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("JobListener '" + jobListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
    }

    public void notifyJobListenersWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) throws SchedulerException {
        List<JobListener> list = this.buildJobListenerList();
        for (JobListener jobListener : list) {
            try {
                if (!this.matchJobListener(jobListener, jobExecutionContext.getJobDetail().getKey())) continue;
                jobListener.jobWasExecuted(jobExecutionContext, jobExecutionException);
            }
            catch (Exception exception) {
                SchedulerException schedulerException = new SchedulerException("JobListener '" + jobListener.getName() + "' threw exception: " + exception.getMessage(), exception);
                throw schedulerException;
            }
        }
    }

    public void notifySchedulerListenersError(String string, SchedulerException schedulerException) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.schedulerError(string, schedulerException);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of error: ", exception);
                this.getLog().error("  Original error (for notification) was: " + string, schedulerException);
            }
        }
    }

    public void notifySchedulerListenersSchduled(Trigger trigger) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.jobScheduled(trigger);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of scheduled job.  Triger=" + trigger.getKey(), exception);
            }
        }
    }

    public void notifySchedulerListenersUnscheduled(TriggerKey triggerKey) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                if (triggerKey == null) {
                    schedulerListener.schedulingDataCleared();
                    continue;
                }
                schedulerListener.jobUnscheduled(triggerKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of unscheduled job.  Triger=" + (triggerKey == null ? "ALL DATA" : triggerKey), exception);
            }
        }
    }

    public void notifySchedulerListenersFinalized(Trigger trigger) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.triggerFinalized(trigger);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of finalized trigger.  Triger=" + trigger.getKey(), exception);
            }
        }
    }

    public void notifySchedulerListenersPausedTrigger(TriggerKey triggerKey) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.triggerPaused(triggerKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of paused trigger: " + triggerKey, exception);
            }
        }
    }

    public void notifySchedulerListenersPausedTriggers(String string) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.triggersPaused(string);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of paused trigger group." + string, exception);
            }
        }
    }

    public void notifySchedulerListenersResumedTrigger(TriggerKey triggerKey) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.triggerResumed(triggerKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of resumed trigger: " + triggerKey, exception);
            }
        }
    }

    public void notifySchedulerListenersResumedTriggers(String string) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.triggersResumed(string);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of resumed group: " + string, exception);
            }
        }
    }

    public void notifySchedulerListenersPausedJob(JobKey jobKey) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.jobPaused(jobKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of paused job: " + jobKey, exception);
            }
        }
    }

    public void notifySchedulerListenersPausedJobs(String string) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.jobsPaused(string);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of paused job group: " + string, exception);
            }
        }
    }

    public void notifySchedulerListenersResumedJob(JobKey jobKey) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.jobResumed(jobKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of resumed job: " + jobKey, exception);
            }
        }
    }

    public void notifySchedulerListenersResumedJobs(String string) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.jobsResumed(string);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of resumed job group: " + string, exception);
            }
        }
    }

    public void notifySchedulerListenersInStandbyMode() {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.schedulerInStandbyMode();
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of inStandByMode.", exception);
            }
        }
    }

    public void notifySchedulerListenersStarted() {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.schedulerStarted();
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of startup.", exception);
            }
        }
    }

    public void notifySchedulerListenersStarting() {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.schedulerStarting();
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of startup.", exception);
            }
        }
    }

    public void notifySchedulerListenersShutdown() {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.schedulerShutdown();
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of shutdown.", exception);
            }
        }
    }

    public void notifySchedulerListenersShuttingdown() {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.schedulerShuttingdown();
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of shutdown.", exception);
            }
        }
    }

    public void notifySchedulerListenersJobAdded(JobDetail jobDetail) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.jobAdded(jobDetail);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of JobAdded.", exception);
            }
        }
    }

    public void notifySchedulerListenersJobDeleted(JobKey jobKey) {
        List<SchedulerListener> list = this.buildSchedulerListenerList();
        for (SchedulerListener schedulerListener : list) {
            try {
                schedulerListener.jobDeleted(jobKey);
            }
            catch (Exception exception) {
                this.getLog().error("Error while notifying SchedulerListener of JobAdded.", exception);
            }
        }
    }

    public void setJobFactory(JobFactory jobFactory) throws SchedulerException {
        if (jobFactory == null) {
            throw new IllegalArgumentException("JobFactory cannot be set to null!");
        }
        this.getLog().info("JobFactory set to: " + jobFactory);
        this.jobFactory = jobFactory;
    }

    public JobFactory getJobFactory() {
        return this.jobFactory;
    }

    @Override
    public boolean interrupt(JobKey jobKey) throws UnableToInterruptJobException {
        List<JobExecutionContext> list = this.getCurrentlyExecutingJobs();
        JobDetail jobDetail = null;
        Job job = null;
        boolean bl = false;
        for (JobExecutionContext jobExecutionContext : list) {
            jobDetail = jobExecutionContext.getJobDetail();
            if (!jobKey.equals(jobDetail.getKey())) continue;
            job = jobExecutionContext.getJobInstance();
            if (job instanceof InterruptableJob) {
                ((InterruptableJob)job).interrupt();
                bl = true;
                continue;
            }
            throw new UnableToInterruptJobException("Job " + jobDetail.getKey() + " can not be interrupted, since it does not implement " + InterruptableJob.class.getName());
        }
        return bl;
    }

    @Override
    public boolean interrupt(String string) throws UnableToInterruptJobException {
        List<JobExecutionContext> list = this.getCurrentlyExecutingJobs();
        Job job = null;
        for (JobExecutionContext jobExecutionContext : list) {
            if (!jobExecutionContext.getFireInstanceId().equals(string)) continue;
            job = jobExecutionContext.getJobInstance();
            if (job instanceof InterruptableJob) {
                ((InterruptableJob)job).interrupt();
                return true;
            }
            throw new UnableToInterruptJobException("Job " + jobExecutionContext.getJobDetail().getKey() + " can not be interrupted, since it does not implement " + InterruptableJob.class.getName());
        }
        return false;
    }

    private void shutdownPlugins() {
        for (SchedulerPlugin schedulerPlugin : this.resources.getSchedulerPlugins()) {
            schedulerPlugin.shutdown();
        }
    }

    private void startPlugins() {
        for (SchedulerPlugin schedulerPlugin : this.resources.getSchedulerPlugins()) {
            schedulerPlugin.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = QuartzScheduler.class.getResourceAsStream("quartz-build.properties");
            if (inputStream != null) {
                properties.load(inputStream);
                String string = properties.getProperty("version");
                if (string != null) {
                    String[] stringArray = string.split("\\.");
                    VERSION_MAJOR = stringArray[0];
                    VERSION_MINOR = stringArray[1];
                    VERSION_ITERATION = stringArray.length > 2 ? stringArray[2] : "0";
                } else {
                    LoggerFactory.getLogger(QuartzScheduler.class).error("Can't parse Quartz version from quartz-build.properties");
                }
            }
        }
        catch (Exception exception) {
            LoggerFactory.getLogger(QuartzScheduler.class).error("Error loading version info from quartz-build.properties.", exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

