/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.JobExecutionContextImpl;
import org.quartz.listeners.SchedulerListenerSupport;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunShell
extends SchedulerListenerSupport
implements Runnable {
    protected JobExecutionContextImpl jec = null;
    protected QuartzScheduler qs = null;
    protected TriggerFiredBundle firedTriggerBundle = null;
    protected Scheduler scheduler = null;
    protected volatile boolean shutdownRequested = false;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public JobRunShell(Scheduler scheduler, TriggerFiredBundle triggerFiredBundle) {
        this.scheduler = scheduler;
        this.firedTriggerBundle = triggerFiredBundle;
    }

    @Override
    public void schedulerShuttingdown() {
        this.requestShutdown();
    }

    @Override
    protected Logger getLog() {
        return this.log;
    }

    public void initialize(QuartzScheduler quartzScheduler) throws SchedulerException {
        this.qs = quartzScheduler;
        Job job = null;
        JobDetail jobDetail = this.firedTriggerBundle.getJobDetail();
        try {
            job = quartzScheduler.getJobFactory().newJob(this.firedTriggerBundle, this.scheduler);
        }
        catch (SchedulerException schedulerException) {
            quartzScheduler.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getKey() + "'", schedulerException);
            throw schedulerException;
        }
        catch (Throwable throwable) {
            SchedulerException schedulerException = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "' - ", throwable);
            quartzScheduler.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getKey() + "'", schedulerException);
            throw schedulerException;
        }
        this.jec = new JobExecutionContextImpl(this.scheduler, this.firedTriggerBundle, job);
    }

    public void requestShutdown() {
        this.shutdownRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            this.qs.addInternalSchedulerListener(this);
            try {
                Trigger.CompletedExecutionInstruction completedExecutionInstruction;
                OperableTrigger operableTrigger = (OperableTrigger)this.jec.getTrigger();
                JobDetail jobDetail = this.jec.getJobDetail();
                while (true) {
                    long l;
                    Job job;
                    JobExecutionException jobExecutionException;
                    block25: {
                        jobExecutionException = null;
                        job = this.jec.getJobInstance();
                        try {
                            this.begin();
                        }
                        catch (SchedulerException schedulerException) {
                            this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getKey() + ": couldn't begin execution.", schedulerException);
                            break block24;
                        }
                        try {
                            if (!this.notifyListenersBeginning(this.jec)) {
                            }
                            break block25;
                        }
                        catch (VetoedException vetoedException) {
                            try {
                                Trigger.CompletedExecutionInstruction completedExecutionInstruction2 = operableTrigger.executionComplete(this.jec, null);
                                this.qs.notifyJobStoreJobVetoed(operableTrigger, jobDetail, completedExecutionInstruction2);
                                if (this.jec.getTrigger().getNextFireTime() == null) {
                                    this.qs.notifySchedulerListenersFinalized(this.jec.getTrigger());
                                }
                                this.complete(true);
                                break block24;
                            }
                            catch (SchedulerException schedulerException) {
                                this.qs.notifySchedulerListenersError("Error during veto of Job (" + this.jec.getJobDetail().getKey() + ": couldn't finalize execution.", schedulerException);
                            }
                        }
                        break block24;
                    }
                    long l2 = l = System.currentTimeMillis();
                    try {
                        this.log.debug("Calling execute on job " + jobDetail.getKey());
                        job.execute(this.jec);
                        l2 = System.currentTimeMillis();
                    }
                    catch (JobExecutionException jobExecutionException2) {
                        l2 = System.currentTimeMillis();
                        jobExecutionException = jobExecutionException2;
                        this.getLog().info("Job " + jobDetail.getKey() + " threw a JobExecutionException: ", jobExecutionException);
                    }
                    catch (Throwable throwable) {
                        l2 = System.currentTimeMillis();
                        this.getLog().error("Job " + jobDetail.getKey() + " threw an unhandled Exception: ", throwable);
                        SchedulerException schedulerException = new SchedulerException("Job threw an unhandled exception.", throwable);
                        this.qs.notifySchedulerListenersError("Job (" + this.jec.getJobDetail().getKey() + " threw an exception.", schedulerException);
                        jobExecutionException = new JobExecutionException(schedulerException, false);
                    }
                    this.jec.setJobRunTime(l2 - l);
                    if (!this.notifyJobListenersComplete(this.jec, jobExecutionException)) {
                        break block24;
                    }
                    completedExecutionInstruction = Trigger.CompletedExecutionInstruction.NOOP;
                    try {
                        completedExecutionInstruction = operableTrigger.executionComplete(this.jec, jobExecutionException);
                    }
                    catch (Exception exception) {
                        SchedulerException schedulerException = new SchedulerException("Trigger threw an unhandled exception.", exception);
                        this.qs.notifySchedulerListenersError("Please report this error to the Quartz developers.", schedulerException);
                    }
                    if (!this.notifyTriggerListenersComplete(this.jec, completedExecutionInstruction)) {
                        break block24;
                    }
                    if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.RE_EXECUTE_JOB) {
                        this.jec.incrementRefireCount();
                        try {
                            this.complete(false);
                        }
                        catch (SchedulerException schedulerException) {
                            this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getKey() + ": couldn't finalize execution.", schedulerException);
                        }
                        continue;
                    }
                    try {
                        this.complete(true);
                    }
                    catch (SchedulerException schedulerException) {
                        this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getKey() + ": couldn't finalize execution.", schedulerException);
                        continue;
                    }
                    break;
                }
                this.qs.notifyJobStoreJobComplete(operableTrigger, jobDetail, completedExecutionInstruction);
            }
            finally {
                this.qs.removeInternalSchedulerListener(this);
            }
        }
    }

    protected void begin() throws SchedulerException {
    }

    protected void complete(boolean bl) throws SchedulerException {
    }

    public void passivate() {
        this.jec = null;
        this.qs = null;
    }

    private boolean notifyListenersBeginning(JobExecutionContext jobExecutionContext) throws VetoedException {
        boolean bl = false;
        try {
            bl = this.qs.notifyTriggerListenersFired(jobExecutionContext);
        }
        catch (SchedulerException schedulerException) {
            this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jobExecutionContext.getTrigger().getKey() + " job= " + jobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        if (bl) {
            try {
                this.qs.notifyJobListenersWasVetoed(jobExecutionContext);
            }
            catch (SchedulerException schedulerException) {
                this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of vetoed execution while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jobExecutionContext.getTrigger().getKey() + " job= " + jobExecutionContext.getJobDetail().getKey(), schedulerException);
            }
            throw new VetoedException();
        }
        try {
            this.qs.notifyJobListenersToBeExecuted(jobExecutionContext);
        }
        catch (SchedulerException schedulerException) {
            this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job to be executed: (Job will NOT be executed!). trigger= " + jobExecutionContext.getTrigger().getKey() + " job= " + jobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        return true;
    }

    private boolean notifyJobListenersComplete(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        try {
            this.qs.notifyJobListenersWasExecuted(jobExecutionContext, jobExecutionException);
        }
        catch (SchedulerException schedulerException) {
            this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job that was executed: (error will be ignored). trigger= " + jobExecutionContext.getTrigger().getKey() + " job= " + jobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        return true;
    }

    private boolean notifyTriggerListenersComplete(JobExecutionContext jobExecutionContext, Trigger.CompletedExecutionInstruction completedExecutionInstruction) {
        try {
            this.qs.notifyTriggerListenersComplete(jobExecutionContext, completedExecutionInstruction);
        }
        catch (SchedulerException schedulerException) {
            this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) of Job that was executed: (error will be ignored). trigger= " + jobExecutionContext.getTrigger().getKey() + " job= " + jobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        if (jobExecutionContext.getTrigger().getNextFireTime() == null) {
            this.qs.notifySchedulerListenersFinalized(jobExecutionContext.getTrigger());
        }
        return true;
    }

    static class VetoedException
    extends Exception {
        private static final long serialVersionUID = 1539955697495918463L;
    }
}

