/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import org.quartz.ScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.MutableTrigger;

public class SimpleScheduleBuilder
extends ScheduleBuilder<SimpleTrigger> {
    private long interval = 0L;
    private int repeatCount = 0;
    private int misfireInstruction = 0;

    protected SimpleScheduleBuilder() {
    }

    public static SimpleScheduleBuilder simpleSchedule() {
        return new SimpleScheduleBuilder();
    }

    public static SimpleScheduleBuilder repeatMinutelyForever() {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(1).repeatForever();
    }

    public static SimpleScheduleBuilder repeatMinutelyForever(int n) {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(n).repeatForever();
    }

    public static SimpleScheduleBuilder repeatSecondlyForever() {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(1).repeatForever();
    }

    public static SimpleScheduleBuilder repeatSecondlyForever(int n) {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(n).repeatForever();
    }

    public static SimpleScheduleBuilder repeatHourlyForever() {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(1).repeatForever();
    }

    public static SimpleScheduleBuilder repeatHourlyForever(int n) {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(n).repeatForever();
    }

    public static SimpleScheduleBuilder repeatMinutelyForTotalCount(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + n);
        }
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(1).withRepeatCount(n - 1);
    }

    public static SimpleScheduleBuilder repeatMinutelyForTotalCount(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + n);
        }
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(n2).withRepeatCount(n - 1);
    }

    public static SimpleScheduleBuilder repeatSecondlyForTotalCount(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + n);
        }
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(1).withRepeatCount(n - 1);
    }

    public static SimpleScheduleBuilder repeatSecondlyForTotalCount(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + n);
        }
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(n2).withRepeatCount(n - 1);
    }

    public static SimpleScheduleBuilder repeatHourlyForTotalCount(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + n);
        }
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(1).withRepeatCount(n - 1);
    }

    public static SimpleScheduleBuilder repeatHourlyForTotalCount(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("Total count of firings must be at least one! Given count: " + n);
        }
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(n2).withRepeatCount(n - 1);
    }

    @Override
    public MutableTrigger build() {
        SimpleTriggerImpl simpleTriggerImpl = new SimpleTriggerImpl();
        simpleTriggerImpl.setRepeatInterval(this.interval);
        simpleTriggerImpl.setRepeatCount(this.repeatCount);
        simpleTriggerImpl.setMisfireInstruction(this.misfireInstruction);
        return simpleTriggerImpl;
    }

    public SimpleScheduleBuilder withIntervalInMilliseconds(long l) {
        this.interval = l;
        return this;
    }

    public SimpleScheduleBuilder withIntervalInSeconds(int n) {
        this.interval = (long)n * 1000L;
        return this;
    }

    public SimpleScheduleBuilder withIntervalInMinutes(int n) {
        this.interval = (long)n * 60000L;
        return this;
    }

    public SimpleScheduleBuilder withIntervalInHours(int n) {
        this.interval = (long)n * 3600000L;
        return this;
    }

    public SimpleScheduleBuilder withRepeatCount(int n) {
        this.repeatCount = n;
        return this;
    }

    public SimpleScheduleBuilder repeatForever() {
        this.repeatCount = -1;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.misfireInstruction = -1;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionFireNow() {
        this.misfireInstruction = 1;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionNextWithExistingCount() {
        this.misfireInstruction = 5;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionNextWithRemainingCount() {
        this.misfireInstruction = 4;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionNowWithExistingCount() {
        this.misfireInstruction = 2;
        return this;
    }

    public SimpleScheduleBuilder withMisfireHandlingInstructionNowWithRemainingCount() {
        this.misfireInstruction = 3;
        return this;
    }
}

