/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateBuilder {
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final long MILLISECONDS_IN_MINUTE = 60000L;
    public static final long MILLISECONDS_IN_HOUR = 3600000L;
    public static final long SECONDS_IN_MOST_DAYS = 86400L;
    public static final long MILLISECONDS_IN_DAY = 86400000L;
    private int month;
    private int day;
    private int year;
    private int hour;
    private int minute;
    private int second;
    private TimeZone tz;
    private Locale lc;
    private static final int MAX_YEAR = Calendar.getInstance().get(1) + 100;

    private DateBuilder() {
        Calendar calendar = Calendar.getInstance();
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.year = calendar.get(1);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
    }

    private DateBuilder(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        this.tz = timeZone;
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.year = calendar.get(1);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
    }

    private DateBuilder(Locale locale) {
        Calendar calendar = Calendar.getInstance(locale);
        this.lc = locale;
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.year = calendar.get(1);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
    }

    private DateBuilder(TimeZone timeZone, Locale locale) {
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        this.tz = timeZone;
        this.lc = locale;
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.year = calendar.get(1);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
    }

    public static DateBuilder newDate() {
        return new DateBuilder();
    }

    public static DateBuilder newDateInTimezone(TimeZone timeZone) {
        return new DateBuilder(timeZone);
    }

    public static DateBuilder newDateInLocale(Locale locale) {
        return new DateBuilder(locale);
    }

    public static DateBuilder newDateInTimeZoneAndLocale(TimeZone timeZone, Locale locale) {
        return new DateBuilder(timeZone, locale);
    }

    public Date build() {
        Calendar calendar = this.tz != null && this.lc != null ? Calendar.getInstance(this.tz, this.lc) : (this.tz != null ? Calendar.getInstance(this.tz) : (this.lc != null ? Calendar.getInstance(this.lc) : Calendar.getInstance()));
        calendar.set(1, this.year);
        calendar.set(2, this.month - 1);
        calendar.set(5, this.day);
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, this.second);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public DateBuilder atHourOfDay(int n) {
        DateBuilder.validateHour(n);
        this.hour = n;
        return this;
    }

    public DateBuilder atMinute(int n) {
        DateBuilder.validateMinute(n);
        this.minute = n;
        return this;
    }

    public DateBuilder atSecond(int n) {
        DateBuilder.validateSecond(n);
        this.second = n;
        return this;
    }

    public DateBuilder atHourMinuteAndSecond(int n, int n2, int n3) {
        DateBuilder.validateHour(n);
        DateBuilder.validateMinute(n2);
        DateBuilder.validateSecond(n3);
        this.hour = n;
        this.second = n3;
        this.minute = n2;
        return this;
    }

    public DateBuilder onDay(int n) {
        DateBuilder.validateDayOfMonth(n);
        this.day = n;
        return this;
    }

    public DateBuilder inMonth(int n) {
        DateBuilder.validateMonth(n);
        this.month = n;
        return this;
    }

    public DateBuilder inMonthOnDay(int n, int n2) {
        DateBuilder.validateMonth(n);
        DateBuilder.validateDayOfMonth(n2);
        this.month = n;
        this.day = n2;
        return this;
    }

    public DateBuilder inYear(int n) {
        DateBuilder.validateYear(n);
        this.year = n;
        return this;
    }

    public DateBuilder inTimeZone(TimeZone timeZone) {
        this.tz = timeZone;
        return this;
    }

    public DateBuilder inLocale(Locale locale) {
        this.lc = locale;
        return this;
    }

    public static Date futureDate(int n, IntervalUnit intervalUnit) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.setLenient(true);
        calendar.add(DateBuilder.translate(intervalUnit), n);
        return calendar.getTime();
    }

    private static int translate(IntervalUnit intervalUnit) {
        switch (intervalUnit) {
            case DAY: {
                return 6;
            }
            case HOUR: {
                return 11;
            }
            case MINUTE: {
                return 12;
            }
            case MONTH: {
                return 2;
            }
            case SECOND: {
                return 13;
            }
            case MILLISECOND: {
                return 14;
            }
            case WEEK: {
                return 3;
            }
            case YEAR: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unknown IntervalUnit");
    }

    public static Date tomorrowAt(int n, int n2, int n3) {
        DateBuilder.validateSecond(n3);
        DateBuilder.validateMinute(n2);
        DateBuilder.validateHour(n);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setLenient(true);
        calendar.add(6, 1);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date todayAt(int n, int n2, int n3) {
        return DateBuilder.dateOf(n, n2, n3);
    }

    public static Date dateOf(int n, int n2, int n3) {
        DateBuilder.validateSecond(n3);
        DateBuilder.validateMinute(n2);
        DateBuilder.validateHour(n);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setLenient(true);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date dateOf(int n, int n2, int n3, int n4, int n5) {
        DateBuilder.validateSecond(n3);
        DateBuilder.validateMinute(n2);
        DateBuilder.validateHour(n);
        DateBuilder.validateDayOfMonth(n4);
        DateBuilder.validateMonth(n5);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, n5 - 1);
        calendar.set(5, n4);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date dateOf(int n, int n2, int n3, int n4, int n5, int n6) {
        DateBuilder.validateSecond(n3);
        DateBuilder.validateMinute(n2);
        DateBuilder.validateHour(n);
        DateBuilder.validateDayOfMonth(n4);
        DateBuilder.validateMonth(n5);
        DateBuilder.validateYear(n6);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, n6);
        calendar.set(2, n5 - 1);
        calendar.set(5, n4);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenHourDateAfterNow() {
        return DateBuilder.evenHourDate(null);
    }

    public static Date evenHourDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setLenient(true);
        calendar.set(11, calendar.get(11) + 1);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenHourDateBefore(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenMinuteDateAfterNow() {
        return DateBuilder.evenMinuteDate(null);
    }

    public static Date evenMinuteDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setLenient(true);
        calendar.set(12, calendar.get(12) + 1);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenMinuteDateBefore(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenSecondDateAfterNow() {
        return DateBuilder.evenSecondDate(null);
    }

    public static Date evenSecondDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setLenient(true);
        calendar.set(13, calendar.get(13) + 1);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenSecondDateBefore(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date nextGivenMinuteDate(Date date, int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException("minuteBase must be >=0 and <= 59");
        }
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setLenient(true);
        if (n == 0) {
            calendar.set(11, calendar.get(11) + 1);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        int n2 = calendar.get(12);
        int n3 = n2 / n;
        int n4 = n * (n3 + 1);
        if (n4 < 60) {
            calendar.set(12, n4);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        calendar.set(11, calendar.get(11) + 1);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date nextGivenSecondDate(Date date, int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException("secondBase must be >=0 and <= 59");
        }
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setLenient(true);
        if (n == 0) {
            calendar.set(12, calendar.get(12) + 1);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        int n2 = calendar.get(13);
        int n3 = n2 / n;
        int n4 = n * (n3 + 1);
        if (n4 < 60) {
            calendar.set(13, n4);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        calendar.set(12, calendar.get(12) + 1);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date translateTime(Date date, TimeZone timeZone, TimeZone timeZone2) {
        Date date2 = new Date();
        int n = timeZone2.getOffset(date.getTime()) - timeZone.getOffset(date.getTime());
        date2.setTime(date.getTime() - (long)n);
        return date2;
    }

    public static void validateDayOfWeek(int n) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Invalid day of week.");
        }
    }

    public static void validateHour(int n) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("Invalid hour (must be >= 0 and <= 23).");
        }
    }

    public static void validateMinute(int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException("Invalid minute (must be >= 0 and <= 59).");
        }
    }

    public static void validateSecond(int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException("Invalid second (must be >= 0 and <= 59).");
        }
    }

    public static void validateDayOfMonth(int n) {
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException("Invalid day of month.");
        }
    }

    public static void validateMonth(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Invalid month (must be >= 1 and <= 12.");
        }
    }

    public static void validateYear(int n) {
        if (n < 0 || n > MAX_YEAR) {
            throw new IllegalArgumentException("Invalid year (must be >= 0 and <= " + MAX_YEAR);
        }
    }

    public static enum IntervalUnit {
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

