/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.TimeZone;
import org.quartz.CalendarIntervalTrigger;
import org.quartz.DateBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;
import org.quartz.spi.MutableTrigger;

public class CalendarIntervalScheduleBuilder
extends ScheduleBuilder<CalendarIntervalTrigger> {
    private int interval = 1;
    private DateBuilder.IntervalUnit intervalUnit = DateBuilder.IntervalUnit.DAY;
    private int misfireInstruction = 0;
    private TimeZone timeZone;
    private boolean preserveHourOfDayAcrossDaylightSavings;
    private boolean skipDayIfHourDoesNotExist;

    protected CalendarIntervalScheduleBuilder() {
    }

    public static CalendarIntervalScheduleBuilder calendarIntervalSchedule() {
        return new CalendarIntervalScheduleBuilder();
    }

    @Override
    public MutableTrigger build() {
        CalendarIntervalTriggerImpl calendarIntervalTriggerImpl = new CalendarIntervalTriggerImpl();
        calendarIntervalTriggerImpl.setRepeatInterval(this.interval);
        calendarIntervalTriggerImpl.setRepeatIntervalUnit(this.intervalUnit);
        calendarIntervalTriggerImpl.setMisfireInstruction(this.misfireInstruction);
        calendarIntervalTriggerImpl.setTimeZone(this.timeZone);
        calendarIntervalTriggerImpl.setPreserveHourOfDayAcrossDaylightSavings(this.preserveHourOfDayAcrossDaylightSavings);
        calendarIntervalTriggerImpl.setSkipDayIfHourDoesNotExist(this.skipDayIfHourDoesNotExist);
        return calendarIntervalTriggerImpl;
    }

    public CalendarIntervalScheduleBuilder withInterval(int n, DateBuilder.IntervalUnit intervalUnit) {
        if (intervalUnit == null) {
            throw new IllegalArgumentException("TimeUnit must be specified.");
        }
        this.validateInterval(n);
        this.interval = n;
        this.intervalUnit = intervalUnit;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInSeconds(int n) {
        this.validateInterval(n);
        this.interval = n;
        this.intervalUnit = DateBuilder.IntervalUnit.SECOND;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInMinutes(int n) {
        this.validateInterval(n);
        this.interval = n;
        this.intervalUnit = DateBuilder.IntervalUnit.MINUTE;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInHours(int n) {
        this.validateInterval(n);
        this.interval = n;
        this.intervalUnit = DateBuilder.IntervalUnit.HOUR;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInDays(int n) {
        this.validateInterval(n);
        this.interval = n;
        this.intervalUnit = DateBuilder.IntervalUnit.DAY;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInWeeks(int n) {
        this.validateInterval(n);
        this.interval = n;
        this.intervalUnit = DateBuilder.IntervalUnit.WEEK;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInMonths(int n) {
        this.validateInterval(n);
        this.interval = n;
        this.intervalUnit = DateBuilder.IntervalUnit.MONTH;
        return this;
    }

    public CalendarIntervalScheduleBuilder withIntervalInYears(int n) {
        this.validateInterval(n);
        this.interval = n;
        this.intervalUnit = DateBuilder.IntervalUnit.YEAR;
        return this;
    }

    public CalendarIntervalScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.misfireInstruction = -1;
        return this;
    }

    public CalendarIntervalScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.misfireInstruction = 2;
        return this;
    }

    public CalendarIntervalScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.misfireInstruction = 1;
        return this;
    }

    public CalendarIntervalScheduleBuilder inTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public CalendarIntervalScheduleBuilder preserveHourOfDayAcrossDaylightSavings(boolean bl) {
        this.preserveHourOfDayAcrossDaylightSavings = bl;
        return this;
    }

    public CalendarIntervalScheduleBuilder skipDayIfHourDoesNotExist(boolean bl) {
        this.skipDayIfHourDoesNotExist = bl;
        return this;
    }

    private void validateInterval(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Interval must be a positive value.");
        }
    }
}

