/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaXMember;
import org.hibernate.annotations.common.reflection.java.JavaXType;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;

class JavaXProperty
extends JavaXMember
implements XProperty {
    static JavaXProperty create(Member member, TypeEnvironment typeEnvironment, JavaReflectionManager javaReflectionManager) {
        Type type = JavaXProperty.typeOf(member, typeEnvironment);
        JavaXType javaXType = javaReflectionManager.toXType(typeEnvironment, type);
        return new JavaXProperty(member, type, typeEnvironment, javaReflectionManager, javaXType);
    }

    private JavaXProperty(Member member, Type type, TypeEnvironment typeEnvironment, JavaReflectionManager javaReflectionManager, JavaXType javaXType) {
        super(member, type, typeEnvironment, javaReflectionManager, javaXType);
        assert (member instanceof Field || member instanceof Method);
    }

    public String getName() {
        String string = this.getMember().getName();
        if (this.getMember() instanceof Method) {
            if (string.startsWith("get")) {
                return Introspector.decapitalize(string.substring("get".length()));
            }
            if (string.startsWith("is")) {
                return Introspector.decapitalize(string.substring("is".length()));
            }
            throw new RuntimeException("Method " + string + " is not a property getter");
        }
        return string;
    }

    public Object invoke(Object object, Object ... objectArray) {
        if (objectArray.length != 0) {
            throw new IllegalArgumentException("An XProperty cannot have invoke parameters");
        }
        try {
            if (this.getMember() instanceof Method) {
                return ((Method)this.getMember()).invoke(object, new Object[0]);
            }
            return ((Field)this.getMember()).get(object);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Invoking " + this.getName() + " on a  null object", nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invoking " + this.getName() + " with wrong parameters", illegalArgumentException);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to invoke " + this.getName(), exception);
        }
    }

    public String toString() {
        return this.getName();
    }
}

