/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaXMember;
import org.hibernate.annotations.common.reflection.java.JavaXType;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;

public class JavaXMethod
extends JavaXMember
implements XMethod {
    static JavaXMethod create(Member member, TypeEnvironment typeEnvironment, JavaReflectionManager javaReflectionManager) {
        Type type = JavaXMethod.typeOf(member, typeEnvironment);
        JavaXType javaXType = javaReflectionManager.toXType(typeEnvironment, type);
        return new JavaXMethod(member, type, typeEnvironment, javaReflectionManager, javaXType);
    }

    private JavaXMethod(Member member, Type type, TypeEnvironment typeEnvironment, JavaReflectionManager javaReflectionManager, JavaXType javaXType) {
        super(member, type, typeEnvironment, javaReflectionManager, javaXType);
        assert (member instanceof Method);
    }

    public String getName() {
        return this.getMember().getName();
    }

    public Object invoke(Object object, Object ... objectArray) {
        try {
            return ((Method)this.getMember()).invoke(object, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Invoking " + this.getName() + " on a  null object", nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invoking " + this.getName() + " with wrong parameters", illegalArgumentException);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to invoke " + this.getName(), exception);
        }
    }
}

