/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.ReflectionUtil;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaXAnnotatedElement;
import org.hibernate.annotations.common.reflection.java.generics.CompoundTypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaXClass
extends JavaXAnnotatedElement
implements XClass {
    private final TypeEnvironment context;
    private final Class clazz;

    public JavaXClass(Class clazz, TypeEnvironment typeEnvironment, JavaReflectionManager javaReflectionManager) {
        super(clazz, javaReflectionManager);
        this.clazz = clazz;
        this.context = typeEnvironment;
    }

    @Override
    public String getName() {
        return this.toClass().getName();
    }

    @Override
    public XClass getSuperclass() {
        return this.getFactory().toXClass(this.toClass().getSuperclass(), CompoundTypeEnvironment.create(this.getTypeEnvironment(), this.getFactory().getTypeEnvironment(this.toClass())));
    }

    @Override
    public XClass[] getInterfaces() {
        Class<?>[] classArray = this.toClass().getInterfaces();
        int n = classArray.length;
        XClass[] xClassArray = new XClass[n];
        if (n != 0) {
            TypeEnvironment typeEnvironment = CompoundTypeEnvironment.create(this.getTypeEnvironment(), this.getFactory().getTypeEnvironment(this.toClass()));
            for (int i = 0; i < n; ++i) {
                xClassArray[i] = this.getFactory().toXClass(classArray[i], typeEnvironment);
            }
        }
        return xClassArray;
    }

    @Override
    public boolean isInterface() {
        return this.toClass().isInterface();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.toClass().getModifiers());
    }

    @Override
    public boolean isPrimitive() {
        return this.toClass().isPrimitive();
    }

    @Override
    public boolean isEnum() {
        return this.toClass().isEnum();
    }

    private List<XProperty> getDeclaredFieldProperties(Filter filter) {
        LinkedList<XProperty> linkedList = new LinkedList<XProperty>();
        for (Field field : this.toClass().getDeclaredFields()) {
            if (!ReflectionUtil.isProperty(field, this.getTypeEnvironment().bind(field.getGenericType()), filter)) continue;
            linkedList.add(this.getFactory().getXProperty(field, this.getTypeEnvironment()));
        }
        return linkedList;
    }

    private List<XProperty> getDeclaredMethodProperties(Filter filter) {
        LinkedList<XProperty> linkedList = new LinkedList<XProperty>();
        for (Method method : this.toClass().getDeclaredMethods()) {
            if (!ReflectionUtil.isProperty(method, this.getTypeEnvironment().bind(method.getGenericReturnType()), filter)) continue;
            linkedList.add(this.getFactory().getXProperty(method, this.getTypeEnvironment()));
        }
        return linkedList;
    }

    @Override
    public List<XProperty> getDeclaredProperties(String string) {
        return this.getDeclaredProperties(string, XClass.DEFAULT_FILTER);
    }

    @Override
    public List<XProperty> getDeclaredProperties(String string, Filter filter) {
        if (string.equals("field")) {
            return this.getDeclaredFieldProperties(filter);
        }
        if (string.equals("property")) {
            return this.getDeclaredMethodProperties(filter);
        }
        throw new IllegalArgumentException("Unknown access type " + string);
    }

    @Override
    public List<XMethod> getDeclaredMethods() {
        LinkedList<XMethod> linkedList = new LinkedList<XMethod>();
        for (Method method : this.toClass().getDeclaredMethods()) {
            linkedList.add(this.getFactory().getXMethod(method, this.getTypeEnvironment()));
        }
        return linkedList;
    }

    public Class<?> toClass() {
        return this.clazz;
    }

    @Override
    public boolean isAssignableFrom(XClass xClass) {
        return this.toClass().isAssignableFrom(((JavaXClass)xClass).toClass());
    }

    boolean isArray() {
        return this.toClass().isArray();
    }

    TypeEnvironment getTypeEnvironment() {
        return this.context;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

