/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.annotations.common.Version;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaMetadataProvider;
import org.hibernate.annotations.common.reflection.java.JavaXAnnotatedElement;
import org.hibernate.annotations.common.reflection.java.JavaXArrayType;
import org.hibernate.annotations.common.reflection.java.JavaXClass;
import org.hibernate.annotations.common.reflection.java.JavaXCollectionType;
import org.hibernate.annotations.common.reflection.java.JavaXMethod;
import org.hibernate.annotations.common.reflection.java.JavaXPackage;
import org.hibernate.annotations.common.reflection.java.JavaXProperty;
import org.hibernate.annotations.common.reflection.java.JavaXSimpleType;
import org.hibernate.annotations.common.reflection.java.JavaXType;
import org.hibernate.annotations.common.reflection.java.Pair;
import org.hibernate.annotations.common.reflection.java.generics.IdentityTypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironmentFactory;
import org.hibernate.annotations.common.reflection.java.generics.TypeSwitch;
import org.hibernate.annotations.common.reflection.java.generics.TypeUtils;
import org.hibernate.annotations.common.util.ReflectHelper;

public class JavaReflectionManager
implements ReflectionManager,
MetadataProviderInjector {
    private MetadataProvider metadataProvider;
    private final Map<TypeKey, JavaXClass> xClasses = new HashMap<TypeKey, JavaXClass>();
    private final Map<Package, JavaXPackage> packagesToXPackages = new HashMap<Package, JavaXPackage>();
    private final Map<MemberKey, JavaXProperty> xProperties = new HashMap<MemberKey, JavaXProperty>();
    private final Map<MemberKey, JavaXMethod> xMethods = new HashMap<MemberKey, JavaXMethod>();
    private final TypeEnvironmentFactory typeEnvs = new TypeEnvironmentFactory();

    public MetadataProvider getMetadataProvider() {
        if (this.metadataProvider == null) {
            this.setMetadataProvider(new JavaMetadataProvider());
        }
        return this.metadataProvider;
    }

    public void setMetadataProvider(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public XClass toXClass(Class clazz) {
        return this.toXClass(clazz, IdentityTypeEnvironment.INSTANCE);
    }

    public Class toClass(XClass xClass) {
        if (!(xClass instanceof JavaXClass)) {
            throw new IllegalArgumentException("XClass not coming from this ReflectionManager implementation");
        }
        return (Class)((JavaXClass)xClass).toAnnotatedElement();
    }

    public Method toMethod(XMethod xMethod) {
        if (!(xMethod instanceof JavaXMethod)) {
            throw new IllegalArgumentException("XMethod not coming from this ReflectionManager implementation");
        }
        return (Method)((JavaXAnnotatedElement)((Object)xMethod)).toAnnotatedElement();
    }

    public XClass classForName(String string, Class clazz) throws ClassNotFoundException {
        return this.toXClass(ReflectHelper.classForName(string, clazz));
    }

    public XPackage packageForName(String string) throws ClassNotFoundException {
        return this.getXAnnotatedElement(ReflectHelper.classForName(string + ".package-info").getPackage());
    }

    XClass toXClass(Type type, final TypeEnvironment typeEnvironment) {
        return (XClass)new TypeSwitch<XClass>(){

            @Override
            public XClass caseClass(Class clazz) {
                TypeKey typeKey = new TypeKey(clazz, typeEnvironment);
                JavaXClass javaXClass = (JavaXClass)JavaReflectionManager.this.xClasses.get(typeKey);
                if (javaXClass == null) {
                    javaXClass = new JavaXClass(clazz, typeEnvironment, JavaReflectionManager.this);
                    JavaReflectionManager.this.xClasses.put(typeKey, javaXClass);
                }
                return javaXClass;
            }

            @Override
            public XClass caseParameterizedType(ParameterizedType parameterizedType) {
                return JavaReflectionManager.this.toXClass(parameterizedType.getRawType(), JavaReflectionManager.this.typeEnvs.getEnvironment(parameterizedType, typeEnvironment));
            }
        }.doSwitch(typeEnvironment.bind(type));
    }

    XPackage getXAnnotatedElement(Package package_) {
        JavaXPackage javaXPackage = this.packagesToXPackages.get(package_);
        if (javaXPackage == null) {
            javaXPackage = new JavaXPackage(package_, this);
            this.packagesToXPackages.put(package_, javaXPackage);
        }
        return javaXPackage;
    }

    XProperty getXProperty(Member member, TypeEnvironment typeEnvironment) {
        MemberKey memberKey = new MemberKey(member, typeEnvironment);
        JavaXProperty javaXProperty = this.xProperties.get(memberKey);
        if (javaXProperty == null) {
            javaXProperty = JavaXProperty.create(member, typeEnvironment, this);
            this.xProperties.put(memberKey, javaXProperty);
        }
        return javaXProperty;
    }

    XMethod getXMethod(Member member, TypeEnvironment typeEnvironment) {
        MemberKey memberKey = new MemberKey(member, typeEnvironment);
        JavaXMethod javaXMethod = this.xMethods.get(memberKey);
        if (javaXMethod == null) {
            javaXMethod = JavaXMethod.create(member, typeEnvironment, this);
            this.xMethods.put(memberKey, javaXMethod);
        }
        return javaXMethod;
    }

    TypeEnvironment getTypeEnvironment(Type type) {
        return (TypeEnvironment)new TypeSwitch<TypeEnvironment>(){

            @Override
            public TypeEnvironment caseClass(Class clazz) {
                return JavaReflectionManager.this.typeEnvs.getEnvironment(clazz);
            }

            @Override
            public TypeEnvironment caseParameterizedType(ParameterizedType parameterizedType) {
                return JavaReflectionManager.this.typeEnvs.getEnvironment(parameterizedType);
            }

            @Override
            public TypeEnvironment defaultCase(Type type) {
                return IdentityTypeEnvironment.INSTANCE;
            }
        }.doSwitch(type);
    }

    public JavaXType toXType(TypeEnvironment typeEnvironment, Type type) {
        Type type2 = this.toApproximatingEnvironment(typeEnvironment).bind(type);
        if (TypeUtils.isArray(type2)) {
            return new JavaXArrayType(type, typeEnvironment, this);
        }
        if (TypeUtils.isCollection(type2)) {
            return new JavaXCollectionType(type, typeEnvironment, this);
        }
        if (TypeUtils.isSimple(type2)) {
            return new JavaXSimpleType(type, typeEnvironment, this);
        }
        throw new IllegalArgumentException("No PropertyTypeExtractor available for type void ");
    }

    public boolean equals(XClass xClass, Class clazz) {
        if (xClass == null) {
            return clazz == null;
        }
        return ((JavaXClass)xClass).toClass().equals(clazz);
    }

    public TypeEnvironment toApproximatingEnvironment(TypeEnvironment typeEnvironment) {
        return this.typeEnvs.toApproximatingEnvironment(typeEnvironment);
    }

    public AnnotationReader buildAnnotationReader(AnnotatedElement annotatedElement) {
        return this.getMetadataProvider().getAnnotationReader(annotatedElement);
    }

    public Map getDefaults() {
        return this.getMetadataProvider().getDefaults();
    }

    static {
        Version.touch();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberKey
    extends Pair<Member, TypeEnvironment> {
        MemberKey(Member member, TypeEnvironment typeEnvironment) {
            super(member, typeEnvironment);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeKey
    extends Pair<Type, TypeEnvironment> {
        TypeKey(Type type, TypeEnvironment typeEnvironment) {
            super(type, typeEnvironment);
        }
    }
}

