/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.annotationfactory;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProxy
implements Annotation,
InvocationHandler {
    private final Class<? extends Annotation> annotationType;
    private final Map<Method, Object> values;

    public AnnotationProxy(AnnotationDescriptor annotationDescriptor) {
        this.annotationType = annotationDescriptor.type();
        this.values = this.getAnnotationValues(annotationDescriptor);
    }

    private Map<Method, Object> getAnnotationValues(AnnotationDescriptor annotationDescriptor) {
        HashMap<Method, Object> hashMap = new HashMap<Method, Object>();
        int n = 0;
        for (Method method : this.annotationType.getDeclaredMethods()) {
            if (annotationDescriptor.containsElement(method.getName())) {
                hashMap.put(method, annotationDescriptor.valueOf(method.getName()));
                ++n;
                continue;
            }
            if (method.getDefaultValue() != null) {
                hashMap.put(method, method.getDefaultValue());
                continue;
            }
            throw new IllegalArgumentException("No value provided for " + method.getName());
        }
        if (n != annotationDescriptor.numberOfElements()) {
            throw new RuntimeException("Trying to instanciate " + this.annotationType + " with unknown elements");
        }
        return hashMap;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (this.values.containsKey(method)) {
            return this.values.get(method);
        }
        return method.invoke((Object)this, objectArray);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('@').append(this.annotationType().getName()).append('(');
        for (Method method : this.getRegisteredMethodsInAlphabeticalOrder()) {
            stringBuilder.append(method.getName()).append('=').append(this.values.get(method)).append(", ");
        }
        if (this.values.size() > 0) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            stringBuilder.append(")");
        } else {
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    private SortedSet<Method> getRegisteredMethodsInAlphabeticalOrder() {
        TreeSet<Method> treeSet = new TreeSet<Method>(new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                return method.getName().compareTo(method2.getName());
            }
        });
        treeSet.addAll(this.values.keySet());
        return treeSet;
    }
}

