/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.io.ByteBufferAccumulator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public abstract class CompressExtension
extends AbstractExtension {
    protected static final byte[] TAIL_BYTES = new byte[]{0, 0, -1, -1};
    protected static final ByteBuffer TAIL_BYTES_BUF = ByteBuffer.wrap(TAIL_BYTES);
    private static final Logger LOG = Log.getLogger(CompressExtension.class);
    protected static final int TAIL_DROP_NEVER = 0;
    protected static final int TAIL_DROP_ALWAYS = 1;
    protected static final int TAIL_DROP_FIN_ONLY = 2;
    protected static final int RSV_USE_ALWAYS = 0;
    protected static final int RSV_USE_ONLY_FIRST = 1;
    protected static final int INFLATE_BUFFER_SIZE = 8192;
    protected static final int INPUT_MAX_BUFFER_SIZE = 8192;
    private static final int DECOMPRESS_BUF_SIZE = 8192;
    private final Queue<FrameEntry> entries = new ArrayDeque<FrameEntry>();
    private final IteratingCallback flusher = new Flusher();
    private DeflaterPool deflaterPool;
    private InflaterPool inflaterPool;
    private Deflater deflaterImpl;
    private Inflater inflaterImpl;
    protected AtomicInteger decompressCount = new AtomicInteger(0);
    private int tailDrop = this.getTailDropMode();
    private int rsvUse = this.getRsvUseMode();

    protected CompressExtension() {
    }

    public void setInflaterPool(InflaterPool inflaterPool) {
        this.inflaterPool = inflaterPool;
    }

    public void setDeflaterPool(DeflaterPool deflaterPool) {
        this.deflaterPool = deflaterPool;
    }

    public Deflater getDeflater() {
        if (this.deflaterImpl == null) {
            this.deflaterImpl = (Deflater)this.deflaterPool.acquire();
        }
        return this.deflaterImpl;
    }

    public Inflater getInflater() {
        if (this.inflaterImpl == null) {
            this.inflaterImpl = (Inflater)this.inflaterPool.acquire();
        }
        return this.inflaterImpl;
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    abstract int getTailDropMode();

    abstract int getRsvUseMode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardIncoming(Frame frame, ByteAccumulator byteAccumulator) {
        DataFrame dataFrame = new DataFrame(frame);
        dataFrame.setRsv1(false);
        ByteBuffer byteBuffer = this.getBufferPool().acquire(byteAccumulator.getLength(), false);
        try {
            BufferUtil.clearToFill(byteBuffer);
            byteAccumulator.transferTo(byteBuffer);
            dataFrame.setPayload(byteBuffer);
            this.nextIncomingFrame(dataFrame);
        }
        finally {
            this.getBufferPool().release(byteBuffer);
        }
    }

    protected ByteAccumulator newByteAccumulator() {
        int n = Math.max(this.getPolicy().getMaxTextMessageSize(), this.getPolicy().getMaxBinaryMessageSize());
        return new ByteAccumulator(n, this.getBufferPool());
    }

    protected void decompress(ByteAccumulator byteAccumulator, ByteBuffer byteBuffer) throws DataFormatException {
        if (BufferUtil.isEmpty(byteBuffer)) {
            return;
        }
        Inflater inflater = this.getInflater();
        while (byteBuffer.hasRemaining() && inflater.needsInput()) {
            int n;
            if (!CompressExtension.supplyInput(inflater, byteBuffer)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Needed input, but no buffer could supply input", new Object[0]);
                }
                return;
            }
            do {
                ByteBuffer byteBuffer2 = byteAccumulator.ensureBuffer(8192);
                n = inflater.inflate(byteBuffer2.array(), byteBuffer2.arrayOffset() + byteBuffer2.limit(), byteBuffer2.capacity() - byteBuffer2.limit());
                byteBuffer2.limit(byteBuffer2.limit() + n);
                byteAccumulator.addLength(n);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Decompressed {} bytes into buffer {} from {}", n, BufferUtil.toDetailString(byteBuffer2), CompressExtension.toDetail(inflater));
            } while (n > 0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decompress: exiting {}", CompressExtension.toDetail(inflater));
        }
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        if (this.flusher.isFailed()) {
            this.notifyCallbackFailure(writeCallback, new ZipException());
            return;
        }
        FrameEntry frameEntry = new FrameEntry(frame, writeCallback, batchMode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", frameEntry);
        }
        this.offerEntry(frameEntry);
        this.flusher.iterate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEntry(FrameEntry frameEntry) {
        CompressExtension compressExtension = this;
        synchronized (compressExtension) {
            this.entries.offer(frameEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameEntry pollEntry() {
        CompressExtension compressExtension = this;
        synchronized (compressExtension) {
            return this.entries.poll();
        }
    }

    protected void notifyCallbackSuccess(WriteCallback writeCallback) {
        block3: {
            try {
                if (writeCallback != null) {
                    writeCallback.writeSuccess();
                }
            }
            catch (Throwable throwable) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying success of callback " + writeCallback, throwable);
            }
        }
    }

    protected void notifyCallbackFailure(WriteCallback writeCallback, Throwable throwable) {
        block3: {
            try {
                if (writeCallback != null) {
                    writeCallback.writeFailed(throwable);
                }
            }
            catch (Throwable throwable2) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying failure of callback " + writeCallback, throwable2);
            }
        }
    }

    private static boolean supplyInput(Inflater inflater, ByteBuffer byteBuffer) {
        int n;
        byte[] byArray;
        int n2;
        if (byteBuffer == null || byteBuffer.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Inflater", new Object[0]);
            }
            return false;
        }
        if (byteBuffer.hasArray()) {
            n2 = byteBuffer.remaining();
            byArray = byteBuffer.array();
            n = byteBuffer.position() + byteBuffer.arrayOffset();
            byteBuffer.position(byteBuffer.position() + n2);
        } else {
            n2 = Math.min(8192, byteBuffer.remaining());
            byArray = new byte[n2];
            n = 0;
            byteBuffer.get(byArray, 0, n2);
        }
        inflater.setInput(byArray, n, n2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", byArray.length, CompressExtension.toDetail(inflater));
        }
        return true;
    }

    private static boolean supplyInput(Deflater deflater, ByteBuffer byteBuffer) {
        int n;
        byte[] byArray;
        int n2;
        if (byteBuffer == null || byteBuffer.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Deflater", new Object[0]);
            }
            return false;
        }
        if (byteBuffer.hasArray()) {
            n2 = byteBuffer.remaining();
            byArray = byteBuffer.array();
            n = byteBuffer.position() + byteBuffer.arrayOffset();
            byteBuffer.position(byteBuffer.position() + n2);
        } else {
            n2 = Math.min(8192, byteBuffer.remaining());
            byArray = new byte[n2];
            n = 0;
            byteBuffer.get(byArray, 0, n2);
        }
        deflater.setInput(byArray, n, n2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", byArray.length, CompressExtension.toDetail(deflater));
        }
        return true;
    }

    private static String toDetail(Inflater inflater) {
        return String.format("Inflater[finished=%b,read=%d,written=%d,remaining=%d,in=%d,out=%d]", inflater.finished(), inflater.getBytesRead(), inflater.getBytesWritten(), inflater.getRemaining(), inflater.getTotalIn(), inflater.getTotalOut());
    }

    private static String toDetail(Deflater deflater) {
        return String.format("Deflater[finished=%b,read=%d,written=%d,in=%d,out=%d]", deflater.finished(), deflater.getBytesRead(), deflater.getBytesWritten(), deflater.getTotalIn(), deflater.getTotalOut());
    }

    public static boolean endsWithTail(ByteBuffer byteBuffer) {
        if (byteBuffer == null || byteBuffer.remaining() < TAIL_BYTES.length) {
            return false;
        }
        int n = byteBuffer.limit();
        for (int i = TAIL_BYTES.length; i > 0; --i) {
            if (byteBuffer.get(n - i) == TAIL_BYTES[TAIL_BYTES.length - i]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.deflaterImpl != null) {
            this.deflaterPool.release(this.deflaterImpl);
            this.deflaterImpl = null;
        }
        if (this.inflaterImpl != null) {
            this.inflaterPool.release(this.inflaterImpl);
            this.inflaterImpl = null;
        }
        super.doStop();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;
        private boolean finished = true;

        private Flusher() {
        }

        @Override
        public void failed(Throwable throwable) {
            CompressExtension.this.notifyCallbackFailure(this.current.callback, throwable);
            super.failed(throwable);
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (this.finished) {
                this.current = CompressExtension.this.pollEntry();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Processing {}", this.current);
                }
                if (this.current == null) {
                    return IteratingCallback.Action.IDLE;
                }
                this.deflate(this.current);
            } else {
                this.compress(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void deflate(FrameEntry frameEntry) {
            Frame frame = frameEntry.frame;
            BatchMode batchMode = frameEntry.batchMode;
            if (OpCode.isControlFrame(frame.getOpCode())) {
                CompressExtension.this.nextOutgoingFrame(frame, this, batchMode);
                return;
            }
            this.compress(frameEntry, true);
        }

        private void compress(FrameEntry frameEntry, boolean bl) {
            Object object;
            Frame frame = frameEntry.frame;
            boolean bl2 = frame.isFin();
            ByteBuffer byteBuffer = frame.getPayload();
            Deflater deflater = CompressExtension.this.getDeflater();
            if (byteBuffer == null) {
                byteBuffer = BufferUtil.EMPTY_BUFFER;
            }
            int n = byteBuffer.remaining();
            int n2 = Math.max(256, byteBuffer.remaining());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressing {}: {} bytes in {} bytes chunk", frameEntry, n, n2);
            }
            ByteBuffer byteBuffer2 = BufferUtil.EMPTY_BUFFER;
            WriteCallback writeCallback = this;
            if (!deflater.needsInput() || CompressExtension.supplyInput(deflater, byteBuffer)) {
                final ByteBufferPool byteBufferPool = CompressExtension.this.getBufferPool();
                object = new ByteBufferAccumulator(byteBufferPool, false);
                try {
                    ByteBuffer byteBuffer3;
                    int n3;
                    do {
                        byteBuffer3 = ((ByteBufferAccumulator)object).ensureBuffer(8, n2);
                        n3 = deflater.deflate(byteBuffer3.array(), byteBuffer3.arrayOffset() + byteBuffer3.limit(), byteBuffer3.capacity() - byteBuffer3.limit(), 2);
                        byteBuffer3.limit(byteBuffer3.limit() + n3);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Wrote {} bytes to output buffer", object);
                    } while (n3 > 0);
                    byteBuffer2 = byteBuffer3 = ((ByteBufferAccumulator)object).takeByteBuffer();
                    writeCallback = new WriteCallback(){

                        @Override
                        public void writeFailed(Throwable throwable) {
                            byteBufferPool.release(byteBuffer3);
                            Flusher.this.writeFailed(throwable);
                        }

                        @Override
                        public void writeSuccess() {
                            byteBufferPool.release(byteBuffer3);
                            Flusher.this.writeSuccess();
                        }
                    };
                }
                finally {
                    ((ByteBufferAccumulator)object).close();
                }
            }
            if (byteBuffer2.remaining() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("compressed[] bytes = {}", BufferUtil.toDetailString(byteBuffer2));
                }
                if (CompressExtension.this.tailDrop == 1) {
                    if (CompressExtension.endsWithTail(byteBuffer2)) {
                        byteBuffer2.limit(byteBuffer2.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_ALWAYS) = {}", BufferUtil.toDetailString(byteBuffer2));
                    }
                } else if (CompressExtension.this.tailDrop == 2) {
                    if (frame.isFin() && CompressExtension.endsWithTail(byteBuffer2)) {
                        byteBuffer2.limit(byteBuffer2.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_FIN_ONLY) = {}", BufferUtil.toDetailString(byteBuffer2));
                    }
                }
            } else if (bl2) {
                byteBuffer2 = ByteBuffer.wrap(new byte[]{0});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressed {}: input:{} -> payload:{}", frameEntry, n2, byteBuffer2.remaining());
            }
            boolean bl3 = frame.getType().isContinuation() || !bl;
            object = new DataFrame(frame, bl3);
            if (CompressExtension.this.rsvUse == 1) {
                ((WebSocketFrame)object).setRsv1(!bl3);
            } else {
                ((WebSocketFrame)object).setRsv1(true);
            }
            ((WebSocketFrame)object).setPayload(byteBuffer2);
            ((WebSocketFrame)object).setFin(bl2);
            CompressExtension.this.nextOutgoingFrame((Frame)object, writeCallback, frameEntry.batchMode);
        }

        @Override
        protected void onCompleteSuccess() {
        }

        @Override
        protected void onCompleteFailure(Throwable throwable) {
            FrameEntry frameEntry;
            while ((frameEntry = CompressExtension.this.pollEntry()) != null) {
                CompressExtension.this.notifyCallbackFailure(frameEntry.callback, throwable);
            }
        }

        @Override
        public void writeSuccess() {
            if (this.finished) {
                CompressExtension.this.notifyCallbackSuccess(this.current.callback);
            }
            this.succeeded();
        }

        @Override
        public void writeFailed(Throwable throwable) {
            this.failed(throwable);
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = writeCallback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

