/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.events.AbstractEventDriver;
import org.eclipse.jetty.websocket.common.events.JettyAnnotatedMetadata;
import org.eclipse.jetty.websocket.common.message.MessageInputStream;
import org.eclipse.jetty.websocket.common.message.MessageReader;
import org.eclipse.jetty.websocket.common.message.NullMessage;
import org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import org.eclipse.jetty.websocket.common.message.SimpleTextMessage;
import org.eclipse.jetty.websocket.common.util.TextUtil;

public class JettyAnnotatedEventDriver
extends AbstractEventDriver {
    private static final Logger LOG = Log.getLogger(JettyAnnotatedEventDriver.class);
    private final JettyAnnotatedMetadata events;
    private boolean hasCloseBeenCalled = false;
    private final BatchMode batchMode;

    public JettyAnnotatedEventDriver(WebSocketPolicy webSocketPolicy, Object object, JettyAnnotatedMetadata jettyAnnotatedMetadata) {
        super(webSocketPolicy, object);
        this.events = Objects.requireNonNull(jettyAnnotatedMetadata, "JettyAnnotatedMetadata may not be null");
        WebSocket webSocket = object.getClass().getAnnotation(WebSocket.class);
        if (webSocket.maxTextMessageSize() > 0) {
            this.policy.setMaxTextMessageSize(webSocket.maxTextMessageSize());
        }
        if (webSocket.maxBinaryMessageSize() > 0) {
            this.policy.setMaxBinaryMessageSize(webSocket.maxBinaryMessageSize());
        }
        if (webSocket.inputBufferSize() > 0) {
            this.policy.setInputBufferSize(webSocket.inputBufferSize());
        }
        if (webSocket.maxIdleTime() > 0) {
            this.policy.setIdleTimeout(webSocket.maxIdleTime());
        }
        this.batchMode = webSocket.batchMode();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ctor / object={}, policy={}, batchMode={}, events={}", new Object[]{object, webSocketPolicy, this.batchMode, jettyAnnotatedMetadata});
        }
    }

    @Override
    public BatchMode getBatchMode() {
        return this.batchMode;
    }

    @Override
    public void onBinaryFrame(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBinaryFrame({}, {}) - events.onBinary={}, activeMessage={}", BufferUtil.toDetailString(byteBuffer), bl, this.events.onBinary, this.activeMessage);
        }
        if (this.activeMessage == null) {
            if (this.events.onBinary == null) {
                this.activeMessage = NullMessage.INSTANCE;
            } else if (this.events.onBinary.isStreaming()) {
                MessageInputStream messageInputStream = new MessageInputStream(this.session);
                this.activeMessage = messageInputStream;
                this.dispatch(() -> {
                    try {
                        this.events.onBinary.call(this.websocket, this.session, messageInputStream);
                    }
                    catch (Throwable throwable) {
                        this.session.close(throwable);
                        return;
                    }
                    messageInputStream.handlerComplete();
                });
            } else {
                this.activeMessage = new SimpleBinaryMessage(this);
            }
        }
        this.appendMessage(byteBuffer, bl);
    }

    @Override
    public void onBinaryMessage(byte[] byArray) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBinaryMessage([{}]) - events.onBinary={}", byArray.length, this.events.onBinary);
        }
        if (this.events.onBinary != null) {
            this.events.onBinary.call(this.websocket, this.session, byArray, 0, byArray.length);
        }
    }

    @Override
    public void onClose(CloseInfo closeInfo) {
        if (this.hasCloseBeenCalled) {
            return;
        }
        this.hasCloseBeenCalled = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose({}) - events.onClose={}", closeInfo, this.events.onClose);
        }
        if (this.events.onClose != null) {
            this.events.onClose.call(this.websocket, this.session, closeInfo.getStatusCode(), closeInfo.getReason());
        }
    }

    @Override
    public void onConnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onConnect() - events.onConnect={}", this.events.onConnect);
        }
        if (this.events.onConnect != null) {
            this.events.onConnect.call(this.websocket, this.session);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onError({}) - events.onError={}", throwable.getClass().getName(), this.events.onError);
        }
        if (this.events.onError != null) {
            this.events.onError.call(this.websocket, this.session, throwable);
        } else {
            LOG.warn("Unable to report throwable to websocket (no @OnWebSocketError handler declared): " + this.websocket.getClass().getName(), throwable);
        }
    }

    @Override
    public void onFrame(Frame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFrame({}) - events.onFrame={}", frame, this.events.onFrame);
        }
        if (this.events.onFrame != null) {
            this.events.onFrame.call(this.websocket, this.session, frame);
        }
    }

    @Override
    public void onInputStream(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "InputStream may not be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("onInputStream({}) - events.onBinary={}", inputStream.getClass().getName(), this.events.onBinary);
        }
        if (this.events.onBinary != null) {
            this.events.onBinary.call(this.websocket, this.session, inputStream);
        }
    }

    @Override
    public void onReader(Reader reader) {
        Objects.requireNonNull(reader, "Reader may not be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("onReader({}) - events.onText={}", reader.getClass().getName(), this.events.onText);
        }
        if (this.events.onText != null) {
            this.events.onText.call(this.websocket, this.session, reader);
        }
    }

    @Override
    public void onTextFrame(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTextFrame({}, {}) - events.onText={}, activeMessage={}", BufferUtil.toDetailString(byteBuffer), bl, this.events.onText, this.activeMessage);
        }
        if (this.activeMessage == null) {
            if (this.events.onText == null) {
                this.activeMessage = NullMessage.INSTANCE;
            } else if (this.events.onText.isStreaming()) {
                MessageReader messageReader = new MessageReader(this.session);
                this.activeMessage = messageReader;
                this.dispatch(() -> {
                    try {
                        this.events.onText.call(this.websocket, this.session, messageReader);
                    }
                    catch (Throwable throwable) {
                        this.session.close(throwable);
                        return;
                    }
                    messageReader.handlerComplete();
                });
            } else {
                this.activeMessage = new SimpleTextMessage(this);
            }
        }
        this.appendMessage(byteBuffer, bl);
    }

    @Override
    public void onTextMessage(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTextMessage([{}] \"{}\") - events.onText={}", string.length(), TextUtil.maxStringLength(60, string), this.events.onText);
        }
        if (this.events.onText != null) {
            this.events.onText.call(this.websocket, this.session, string);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.websocket);
    }
}

