/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class UpgradeResponseAdapter
implements UpgradeResponse {
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private int statusCode;
    private String statusReason;
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
    private boolean success = false;

    @Override
    public void addHeader(String string, String string2) {
        String string3 = string;
        List<String> list = this.headers.get(string3);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(string2);
        this.headers.put(string3, list);
    }

    @Override
    public String getAcceptedSubProtocol() {
        return this.getHeader(SEC_WEBSOCKET_PROTOCOL);
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getHeader(String string) {
        List<String> list = this.getHeaders(string);
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n <= 0) {
            return null;
        }
        if (n == 1) {
            return list.get(0);
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (bl) {
                stringBuilder.append(", ");
            }
            QuoteUtil.quoteIfNeeded(stringBuilder, string2, "\"'\\\n\r\t\f\b%+ ;=");
            bl = true;
        }
        return stringBuilder.toString();
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<String> getHeaders(String string) {
        return this.headers.get(string);
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusReason() {
        return this.statusReason;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public void sendForbidden(String string) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setAcceptedSubProtocol(String string) {
        this.setHeader(SEC_WEBSOCKET_PROTOCOL, string);
    }

    @Override
    public void setExtensions(List<ExtensionConfig> list) {
        this.extensions.clear();
        if (list != null) {
            this.extensions.addAll(list);
        }
    }

    @Override
    public void setHeader(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.headers.put(string, arrayList);
    }

    @Override
    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Override
    public void setStatusReason(String string) {
        this.statusReason = string;
    }

    @Override
    public void setSuccess(boolean bl) {
        this.success = bl;
    }
}

