/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionUpgrader;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.io.WebSocketClientConnection;
import org.eclipse.jetty.websocket.common.AcceptHash;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;

public class WebSocketUpgradeRequest
extends HttpRequest
implements Response.CompleteListener,
HttpConnectionUpgrader {
    private static final Logger LOG = Log.getLogger(WebSocketUpgradeRequest.class);
    private final WebSocketClient wsClient;
    private final EventDriver localEndpoint;
    private final CompletableFuture<Session> fut;
    private final ClientUpgradeRequestFacade apiRequestFacade = new ClientUpgradeRequestFacade();
    private UpgradeListener upgradeListener;

    protected WebSocketUpgradeRequest(WebSocketClient webSocketClient, HttpClient httpClient, ClientUpgradeRequest clientUpgradeRequest) {
        this(webSocketClient, httpClient, clientUpgradeRequest.getRequestURI(), clientUpgradeRequest.getLocalEndpoint());
        this.apiRequestFacade.init(clientUpgradeRequest);
    }

    public WebSocketUpgradeRequest(WebSocketClient webSocketClient, HttpClient httpClient, URI uRI, Object object) {
        super(httpClient, new HttpConversation(), uRI);
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be an absolute URI: " + uRI);
        }
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("ws") && !string.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("WebSocket URI must use 'ws' or 'wss' scheme: " + uRI);
        }
        this.wsClient = webSocketClient;
        try {
            if (!this.wsClient.isRunning()) {
                this.wsClient.start();
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to start WebSocketClient", exception);
        }
        this.localEndpoint = this.wsClient.getEventDriverFactory().wrap(object);
        this.fut = new CompletableFuture();
        this.fut.whenComplete((session, throwable) -> {
            if (throwable != null) {
                this.abort((Throwable)throwable);
            }
        });
        this.getConversation().setAttribute(HttpConnectionUpgrader.class.getName(), this);
    }

    private String genRandomKey() {
        byte[] byArray = new byte[16];
        ThreadLocalRandom.current().nextBytes(byArray);
        return Base64.getEncoder().encodeToString(byArray);
    }

    private ExtensionFactory getExtensionFactory() {
        return this.wsClient.getExtensionFactory();
    }

    private SessionFactory getSessionFactory() {
        return this.wsClient.getSessionFactory();
    }

    private void initWebSocketHeaders() {
        this.method(HttpMethod.GET);
        this.version(HttpVersion.HTTP_1_1);
        this.header(HttpHeader.UPGRADE, "websocket");
        this.header(HttpHeader.CONNECTION, "Upgrade");
        this.header(HttpHeader.SEC_WEBSOCKET_KEY, this.genRandomKey());
        this.header(HttpHeader.SEC_WEBSOCKET_VERSION, "13");
        this.header(HttpHeader.PRAGMA, "no-cache");
        this.header(HttpHeader.CACHE_CONTROL, "no-cache");
        if (!this.apiRequestFacade.getExtensions().isEmpty()) {
            for (ExtensionConfig object : this.apiRequestFacade.getExtensions()) {
                this.header(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, object.getParameterizedName());
            }
        }
        if (!this.apiRequestFacade.getSubProtocols().isEmpty()) {
            for (String string : this.apiRequestFacade.getSubProtocols()) {
                this.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, string);
            }
        }
        if (this.upgradeListener != null) {
            this.upgradeListener.onHandshakeRequest(this.apiRequestFacade);
        }
    }

    @Override
    public void onComplete(Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onComplete() - {}", result);
        }
        URI uRI = result.getRequest().getURI();
        Response response = result.getResponse();
        int n = response.getStatus();
        String string = n + " " + response.getReason();
        if (result.isFailed()) {
            Throwable throwable;
            if (LOG.isDebugEnabled()) {
                if (result.getFailure() != null) {
                    LOG.debug("General Failure", result.getFailure());
                }
                if (result.getRequestFailure() != null) {
                    LOG.debug("Request Failure", result.getRequestFailure());
                }
                if (result.getResponseFailure() != null) {
                    LOG.debug("Response Failure", result.getResponseFailure());
                }
            }
            if ((throwable = result.getFailure()) instanceof IOException || throwable instanceof UpgradeException) {
                this.handleException(throwable);
            } else {
                this.handleException(new UpgradeException(uRI, n, string, throwable));
            }
            return;
        }
        if (n != 101) {
            this.handleException(new UpgradeException(uRI, n, "Failed to upgrade to websocket: Unexpected HTTP Response Status Code: " + string));
        }
    }

    private void handleException(Throwable throwable) {
        try {
            this.localEndpoint.onError(throwable);
        }
        catch (Throwable throwable2) {
            LOG.warn("Exception while notifying onError", throwable2);
        }
        this.fut.completeExceptionally(throwable);
    }

    @Override
    public ContentResponse send() throws InterruptedException, TimeoutException, ExecutionException {
        throw new RuntimeException("Working with raw ContentResponse is invalid for WebSocket");
    }

    @Override
    public void send(Response.CompleteListener completeListener) {
        this.initWebSocketHeaders();
        super.send(completeListener);
    }

    public CompletableFuture<Session> sendAsync() {
        this.send(this);
        return this.fut;
    }

    @Override
    public void upgrade(HttpResponse httpResponse, HttpConnectionOverHTTP httpConnectionOverHTTP) {
        Object object;
        String string;
        if (!this.getHeaders().get(HttpHeader.UPGRADE).equalsIgnoreCase("websocket")) {
            throw new HttpResponseException("Not WebSocket Upgrade", httpResponse);
        }
        String string2 = this.getHeaders().get(HttpHeader.SEC_WEBSOCKET_KEY);
        String string3 = AcceptHash.hashKey(string2);
        if (!string3.equalsIgnoreCase(string = httpResponse.getHeaders().get(HttpHeader.SEC_WEBSOCKET_ACCEPT))) {
            throw new HttpResponseException("Invalid Sec-WebSocket-Accept hash", httpResponse);
        }
        EndPoint endPoint = httpConnectionOverHTTP.getEndPoint();
        WebSocketClientConnection webSocketClientConnection = new WebSocketClientConnection(endPoint, this.wsClient.getExecutor(), this.wsClient.getScheduler(), this.localEndpoint.getPolicy(), this.wsClient.getBufferPool());
        Collection<Connection.Listener> collection = this.wsClient.getBeans(Connection.Listener.class);
        if (collection != null) {
            collection.forEach(listener -> {
                if (!(listener instanceof WebSocketSession)) {
                    webSocketClientConnection.addListener((Connection.Listener)listener);
                }
            });
        }
        URI uRI = this.getURI();
        ClientUpgradeResponse clientUpgradeResponse = new ClientUpgradeResponse(httpResponse);
        WebSocketSession webSocketSession = this.getSessionFactory().createSession(uRI, this.localEndpoint, webSocketClientConnection);
        webSocketSession.setUpgradeRequest(new ClientUpgradeRequest(this));
        webSocketSession.setUpgradeResponse(clientUpgradeResponse);
        webSocketClientConnection.addListener(webSocketSession);
        ArrayList<ExtensionConfig> arrayList = new ArrayList<ExtensionConfig>();
        HttpField httpField = httpResponse.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (httpField != null && (object = httpField.getValues()) != null) {
            for (String string4 : object) {
                QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string4, ",");
                while (quotedStringTokenizer.hasMoreTokens()) {
                    arrayList.add(ExtensionConfig.parse(quotedStringTokenizer.nextToken()));
                }
            }
        }
        object = new ExtensionStack(this.getExtensionFactory());
        ((ExtensionStack)object).negotiate(arrayList);
        ((ExtensionStack)object).configure(webSocketClientConnection.getParser());
        ((ExtensionStack)object).configure(webSocketClientConnection.getGenerator());
        webSocketClientConnection.setNextIncomingFrames((IncomingFrames)object);
        ((ExtensionStack)object).setNextIncoming(webSocketSession);
        webSocketSession.setOutgoingHandler((OutgoingFrames)object);
        ((ExtensionStack)object).setNextOutgoing(webSocketClientConnection);
        webSocketSession.addManaged((LifeCycle)object);
        webSocketSession.setFuture(this.fut);
        if (this.upgradeListener != null) {
            this.upgradeListener.onHandshakeResponse(clientUpgradeResponse);
        }
        endPoint.upgrade(webSocketClientConnection);
    }

    public void setUpgradeListener(UpgradeListener upgradeListener) {
        this.upgradeListener = upgradeListener;
    }

    private HttpFields getHttpFields() {
        return super.getHeaders();
    }

    private class ClientUpgradeRequestFacade
    implements UpgradeRequest {
        private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        private List<String> subProtocols = new ArrayList<String>();
        private Object session;

        public void init(ClientUpgradeRequest clientUpgradeRequest) {
            this.extensions = new ArrayList<ExtensionConfig>(clientUpgradeRequest.getExtensions());
            this.subProtocols = new ArrayList<String>(clientUpgradeRequest.getSubProtocols());
            clientUpgradeRequest.getHeaders().forEach((string, list) -> list.forEach(string2 -> WebSocketUpgradeRequest.this.header((String)string, (String)string2)));
            for (HttpCookie httpCookie : clientUpgradeRequest.getCookies()) {
                WebSocketUpgradeRequest.this.cookie(httpCookie);
            }
        }

        @Override
        public List<ExtensionConfig> getExtensions() {
            return this.extensions;
        }

        @Override
        public List<String> getSubProtocols() {
            return this.subProtocols;
        }

        @Override
        public void addExtensions(ExtensionConfig ... extensionConfigArray) {
            for (ExtensionConfig extensionConfig : extensionConfigArray) {
                this.extensions.add(extensionConfig);
            }
            this.updateExtensionHeader();
        }

        @Override
        public void addExtensions(String ... stringArray) {
            this.extensions.addAll(ExtensionConfig.parseList(stringArray));
            this.updateExtensionHeader();
        }

        @Override
        public void clearHeaders() {
            throw new UnsupportedOperationException("Clearing all headers breaks WebSocket upgrade");
        }

        @Override
        public String getHeader(String string) {
            return WebSocketUpgradeRequest.this.getHttpFields().get(string);
        }

        @Override
        public int getHeaderInt(String string) {
            String string2 = WebSocketUpgradeRequest.this.getHttpFields().get(string);
            if (string2 == null) {
                return -1;
            }
            return Integer.parseInt(string2);
        }

        @Override
        public List<String> getHeaders(String string) {
            return WebSocketUpgradeRequest.this.getHttpFields().getValuesList(string);
        }

        @Override
        public String getHttpVersion() {
            return WebSocketUpgradeRequest.this.getVersion().asString();
        }

        @Override
        public String getOrigin() {
            return WebSocketUpgradeRequest.this.getHttpFields().get(HttpHeader.ORIGIN);
        }

        @Override
        public Map<String, List<String>> getParameterMap() {
            TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            String string = this.getQueryString();
            MultiMap<String> multiMap = new MultiMap<String>();
            UrlEncoded.decodeTo(string, multiMap, StandardCharsets.UTF_8);
            treeMap.putAll(multiMap);
            return treeMap;
        }

        @Override
        public String getProtocolVersion() {
            String string = WebSocketUpgradeRequest.this.getHttpFields().get(HttpHeader.SEC_WEBSOCKET_VERSION);
            if (string == null) {
                return Integer.toString(13);
            }
            return string;
        }

        @Override
        public String getQueryString() {
            return WebSocketUpgradeRequest.this.getURI().getQuery();
        }

        @Override
        public URI getRequestURI() {
            return WebSocketUpgradeRequest.this.getURI();
        }

        @Override
        public Object getSession() {
            return this.session;
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }

        @Override
        public boolean hasSubProtocol(String string) {
            return this.getSubProtocols().contains(string);
        }

        @Override
        public boolean isOrigin(String string) {
            return string.equalsIgnoreCase(this.getOrigin());
        }

        @Override
        public boolean isSecure() {
            return "wss".equalsIgnoreCase(WebSocketUpgradeRequest.this.getURI().getScheme());
        }

        @Override
        public void setCookies(List<HttpCookie> list) {
            for (HttpCookie httpCookie : list) {
                WebSocketUpgradeRequest.this.cookie(httpCookie);
            }
        }

        @Override
        public void setExtensions(List<ExtensionConfig> list) {
            this.extensions = list;
            this.updateExtensionHeader();
        }

        private void updateExtensionHeader() {
            HttpFields httpFields = WebSocketUpgradeRequest.this.getHttpFields();
            httpFields.remove(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
            for (ExtensionConfig extensionConfig : this.extensions) {
                httpFields.add(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, extensionConfig.getParameterizedName());
            }
        }

        @Override
        public void setHeader(String string, List<String> list) {
            WebSocketUpgradeRequest.this.getHttpFields().put(string, list);
        }

        @Override
        public void setHeader(String string, String string2) {
            WebSocketUpgradeRequest.this.getHttpFields().put(string, string2);
        }

        @Override
        public void setHeaders(Map<String, List<String>> map) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                WebSocketUpgradeRequest.this.getHttpFields().put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void setHttpVersion(String string) {
            WebSocketUpgradeRequest.this.version(HttpVersion.fromString(string));
        }

        @Override
        public void setMethod(String string) {
            WebSocketUpgradeRequest.this.method(string);
        }

        @Override
        public void setRequestURI(URI uRI) {
            throw new UnsupportedOperationException("Cannot reset/change RequestURI");
        }

        @Override
        public void setSession(Object object) {
            this.session = object;
        }

        @Override
        public void setSubProtocols(List<String> list) {
            this.subProtocols = list;
        }

        @Override
        public void setSubProtocols(String ... stringArray) {
            this.subProtocols.clear();
            this.subProtocols.addAll(Arrays.asList(stringArray));
        }

        @Override
        public List<HttpCookie> getCookies() {
            return WebSocketUpgradeRequest.this.getCookies();
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            HttpFields httpFields = WebSocketUpgradeRequest.this.getHttpFields();
            for (String string : httpFields.getFieldNamesCollection()) {
                treeMap.put(string, httpFields.getValuesList(string));
            }
            return treeMap;
        }

        @Override
        public String getHost() {
            return WebSocketUpgradeRequest.this.getHost();
        }

        @Override
        public String getMethod() {
            return WebSocketUpgradeRequest.this.getMethod();
        }
    }
}

