/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.statistic;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

public class CounterStatistic {
    private final LongAccumulator _max = new LongAccumulator(Math::max, 0L);
    private final AtomicLong _current = new AtomicLong();
    private final LongAdder _total = new LongAdder();

    public void reset() {
        this._total.reset();
        this._max.reset();
        long l = this._current.get();
        this._total.add(l);
        this._max.accumulate(l);
    }

    public void reset(long l) {
        this._current.set(l);
        this._total.reset();
        this._max.reset();
        if (l > 0L) {
            this._total.add(l);
            this._max.accumulate(l);
        }
    }

    public long add(long l) {
        long l2 = this._current.addAndGet(l);
        if (l > 0L) {
            this._total.add(l);
            this._max.accumulate(l2);
        }
        return l2;
    }

    public long increment() {
        long l = this._current.incrementAndGet();
        this._total.increment();
        this._max.accumulate(l);
        return l;
    }

    public long decrement() {
        return this._current.decrementAndGet();
    }

    public long getMax() {
        return this._max.get();
    }

    public long getCurrent() {
        return this._current.get();
    }

    public long getTotal() {
        return this._total.sum();
    }

    public String toString() {
        return String.format("%s@%x{c=%d,m=%d,t=%d}", this.getClass().getSimpleName(), this.hashCode(), this.getCurrent(), this.getMax(), this.getTotal());
    }
}

