/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JavaUtilLog
extends AbstractLogger {
    private static final String THIS_CLASS = JavaUtilLog.class.getName();
    private static final boolean __source = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.SOURCE", Log.__props.getProperty("org.eclipse.jetty.util.log.javautil.SOURCE", "true")));
    private static boolean _initialized = false;
    private Level configuredLevel;
    private java.util.logging.Logger _logger;

    public JavaUtilLog() {
        this("org.eclipse.jetty.util.log.javautil");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaUtilLog(String string) {
        Class<JavaUtilLog> clazz = JavaUtilLog.class;
        synchronized (JavaUtilLog.class) {
            if (!_initialized) {
                _initialized = true;
                final String string2 = Log.__props.getProperty("org.eclipse.jetty.util.log.javautil.PROPERTIES", null);
                if (string2 != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                URL uRL = Loader.getResource(string2);
                                if (uRL != null) {
                                    LogManager.getLogManager().readConfiguration(uRL.openStream());
                                }
                            }
                            catch (Throwable throwable) {
                                System.err.println("[WARN] Error loading logging config: " + string2);
                                throwable.printStackTrace(System.err);
                            }
                            return null;
                        }
                    });
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this._logger = java.util.logging.Logger.getLogger(string);
            switch (JavaUtilLog.lookupLoggingLevel(Log.__props, string)) {
                case 0: {
                    this._logger.setLevel(Level.ALL);
                    break;
                }
                case 1: {
                    this._logger.setLevel(Level.FINE);
                    break;
                }
                case 2: {
                    this._logger.setLevel(Level.INFO);
                    break;
                }
                case 3: {
                    this._logger.setLevel(Level.WARNING);
                    break;
                }
                case 10: {
                    this._logger.setLevel(Level.OFF);
                    break;
                }
            }
            this.configuredLevel = this._logger.getLevel();
            return;
        }
    }

    @Override
    public String getName() {
        return this._logger.getName();
    }

    protected void log(Level level, String string, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string);
        if (throwable != null) {
            logRecord.setThrown(throwable);
        }
        logRecord.setLoggerName(this._logger.getName());
        if (__source) {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                if (stackTraceElement.getClassName().equals(THIS_CLASS)) continue;
                logRecord.setSourceClassName(stackTraceElement.getClassName());
                logRecord.setSourceMethodName(stackTraceElement.getMethodName());
                break;
            }
        }
        this._logger.log(logRecord);
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, this.format(string, objectArray), null);
        }
    }

    @Override
    public void warn(Throwable throwable) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, "", throwable);
        }
    }

    @Override
    public void warn(String string, Throwable throwable) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, string, throwable);
        }
    }

    @Override
    public void info(String string, Object ... objectArray) {
        if (this._logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, this.format(string, objectArray), null);
        }
    }

    @Override
    public void info(Throwable throwable) {
        if (this._logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, "", throwable);
        }
    }

    @Override
    public void info(String string, Throwable throwable) {
        if (this._logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, string, throwable);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this._logger.isLoggable(Level.FINE);
    }

    @Override
    public void setDebugEnabled(boolean bl) {
        if (bl) {
            this.configuredLevel = this._logger.getLevel();
            this._logger.setLevel(Level.FINE);
        } else {
            this._logger.setLevel(this.configuredLevel);
        }
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        if (this._logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, this.format(string, objectArray), null);
        }
    }

    @Override
    public void debug(String string, long l) {
        if (this._logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, this.format(string, l), null);
        }
    }

    @Override
    public void debug(Throwable throwable) {
        if (this._logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "", throwable);
        }
    }

    @Override
    public void debug(String string, Throwable throwable) {
        if (this._logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, string, throwable);
        }
    }

    @Override
    protected Logger newLogger(String string) {
        return new JavaUtilLog(string);
    }

    @Override
    public void ignore(Throwable throwable) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "IGNORED EXCEPTION ", throwable);
        }
    }

    private String format(String string, Object ... objectArray) {
        string = String.valueOf(string);
        String string2 = "{}";
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Object object : objectArray) {
            int n2 = string.indexOf(string2, n);
            if (n2 < 0) {
                stringBuilder.append(string.substring(n));
                stringBuilder.append(" ");
                stringBuilder.append(object);
                n = string.length();
                continue;
            }
            stringBuilder.append(string, n, n2);
            stringBuilder.append(object);
            n = n2 + string2.length();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }
}

