/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Implementation of Container and LifeCycle")
public class ContainerLifeCycle
extends AbstractLifeCycle
implements Container,
Destroyable,
Dumpable.DumpableContainer {
    private static final Logger LOG = Log.getLogger(ContainerLifeCycle.class);
    private final List<Bean> _beans = new CopyOnWriteArrayList<Bean>();
    private final List<Container.Listener> _listeners = new CopyOnWriteArrayList<Container.Listener>();
    private boolean _doStarted;
    private boolean _destroyed;

    @Override
    protected void doStart() throws Exception {
        if (this._destroyed) {
            throw new IllegalStateException("Destroyed container cannot be restarted");
        }
        this._doStarted = true;
        try {
            for (Bean bean : this._beans) {
                if (!(bean._bean instanceof LifeCycle)) continue;
                LifeCycle lifeCycle = (LifeCycle)bean._bean;
                switch (bean._managed) {
                    case MANAGED: {
                        if (!lifeCycle.isStopped() && !lifeCycle.isFailed()) break;
                        this.start(lifeCycle);
                        break;
                    }
                    case AUTO: {
                        if (lifeCycle.isStopped()) {
                            this.manage(bean);
                            this.start(lifeCycle);
                            break;
                        }
                        this.unmanage(bean);
                        break;
                    }
                }
            }
            super.doStart();
        }
        catch (Throwable throwable) {
            ArrayList<Bean> arrayList = new ArrayList<Bean>(this._beans);
            Collections.reverse(arrayList);
            for (Bean bean : arrayList) {
                LifeCycle lifeCycle;
                if (!(bean._bean instanceof LifeCycle) || bean._managed != Managed.MANAGED || !(lifeCycle = (LifeCycle)bean._bean).isRunning()) continue;
                try {
                    this.stop(lifeCycle);
                }
                catch (Throwable throwable2) {
                    if (throwable2 == throwable) continue;
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    protected void start(LifeCycle lifeCycle) throws Exception {
        lifeCycle.start();
    }

    protected void stop(LifeCycle lifeCycle) throws Exception {
        lifeCycle.stop();
    }

    @Override
    protected void doStop() throws Exception {
        this._doStarted = false;
        super.doStop();
        ArrayList<Bean> arrayList = new ArrayList<Bean>(this._beans);
        Collections.reverse(arrayList);
        MultiException multiException = new MultiException();
        for (Bean bean : arrayList) {
            if (bean._managed != Managed.MANAGED || !(bean._bean instanceof LifeCycle)) continue;
            LifeCycle lifeCycle = (LifeCycle)bean._bean;
            try {
                this.stop(lifeCycle);
            }
            catch (Throwable throwable) {
                multiException.add(throwable);
            }
        }
        multiException.ifExceptionThrow();
    }

    @Override
    public void destroy() {
        this._destroyed = true;
        ArrayList<Bean> arrayList = new ArrayList<Bean>(this._beans);
        Collections.reverse(arrayList);
        for (Bean bean : arrayList) {
            if (!(bean._bean instanceof Destroyable) || bean._managed != Managed.MANAGED && bean._managed != Managed.POJO) continue;
            Destroyable destroyable = (Destroyable)bean._bean;
            try {
                destroyable.destroy();
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
            }
        }
        this._beans.clear();
    }

    public boolean contains(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isManaged(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            return bean.isManaged();
        }
        return false;
    }

    public boolean isAuto(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            return bean._managed == Managed.AUTO;
        }
        return false;
    }

    public boolean isUnmanaged(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            return bean._managed == Managed.UNMANAGED;
        }
        return false;
    }

    @Override
    public boolean addBean(Object object) {
        if (object instanceof LifeCycle) {
            LifeCycle lifeCycle = (LifeCycle)object;
            return this.addBean(object, lifeCycle.isRunning() ? Managed.UNMANAGED : Managed.AUTO);
        }
        return this.addBean(object, Managed.POJO);
    }

    @Override
    public boolean addBean(Object object, boolean bl) {
        if (object instanceof LifeCycle) {
            return this.addBean(object, bl ? Managed.MANAGED : Managed.UNMANAGED);
        }
        return this.addBean(object, bl ? Managed.POJO : Managed.UNMANAGED);
    }

    private boolean addBean(Object object, Managed managed) {
        if (object == null || this.contains(object)) {
            return false;
        }
        Bean bean = new Bean(object);
        if (object instanceof Container.Listener) {
            this.addEventListener((Container.Listener)object);
        }
        this._beans.add(bean);
        for (Container.Listener listener : this._listeners) {
            listener.beanAdded(this, object);
        }
        try {
            switch (managed) {
                case UNMANAGED: {
                    this.unmanage(bean);
                    break;
                }
                case MANAGED: {
                    this.manage(bean);
                    if (!this.isStarting() || !this._doStarted) break;
                    Object object2 = (LifeCycle)object;
                    if (!object2.isRunning()) {
                        this.start((LifeCycle)object2);
                    }
                    break;
                }
                case AUTO: {
                    Object object2;
                    if (object instanceof LifeCycle) {
                        object2 = (LifeCycle)object;
                        if (this.isStarting()) {
                            if (object2.isRunning()) {
                                this.unmanage(bean);
                                break;
                            }
                            if (this._doStarted) {
                                this.manage(bean);
                                this.start((LifeCycle)object2);
                                break;
                            }
                            bean._managed = Managed.AUTO;
                            break;
                        }
                        if (this.isStarted()) {
                            this.unmanage(bean);
                            break;
                        }
                        bean._managed = Managed.AUTO;
                        break;
                    }
                    bean._managed = Managed.POJO;
                    break;
                }
                case POJO: {
                    bean._managed = Managed.POJO;
                }
            }
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added {}", this, bean);
        }
        return true;
    }

    public void addManaged(LifeCycle lifeCycle) {
        this.addBean((Object)lifeCycle, true);
        try {
            if (this.isRunning() && !lifeCycle.isRunning()) {
                this.start(lifeCycle);
            }
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void addEventListener(Container.Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
        for (Bean bean : this._beans) {
            listener.beanAdded(this, bean._bean);
            if (!(listener instanceof Container.InheritedListener) || !bean.isManaged() || !(bean._bean instanceof Container)) continue;
            if (bean._bean instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)bean._bean).addBean((Object)listener, false);
                continue;
            }
            ((Container)bean._bean).addBean(listener);
        }
    }

    @Override
    public void manage(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            this.manage(bean);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + object);
    }

    private void manage(Bean bean) {
        if (bean._managed != Managed.MANAGED) {
            bean._managed = Managed.MANAGED;
            if (bean._bean instanceof Container) {
                for (Container.Listener listener : this._listeners) {
                    if (!(listener instanceof Container.InheritedListener)) continue;
                    if (bean._bean instanceof ContainerLifeCycle) {
                        ((ContainerLifeCycle)bean._bean).addBean((Object)listener, false);
                        continue;
                    }
                    ((Container)bean._bean).addBean(listener);
                }
            }
            if (bean._bean instanceof AbstractLifeCycle) {
                ((AbstractLifeCycle)bean._bean).setStopTimeout(this.getStopTimeout());
            }
        }
    }

    @Override
    public void unmanage(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            this.unmanage(bean);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + object);
    }

    private void unmanage(Bean bean) {
        if (bean._managed != Managed.UNMANAGED) {
            if (bean._managed == Managed.MANAGED && bean._bean instanceof Container) {
                for (Container.Listener listener : this._listeners) {
                    if (!(listener instanceof Container.InheritedListener)) continue;
                    ((Container)bean._bean).removeBean(listener);
                }
            }
            bean._managed = Managed.UNMANAGED;
        }
    }

    @Override
    public Collection<Object> getBeans() {
        return this.getBeans(Object.class);
    }

    public void setBeans(Collection<Object> collection) {
        for (Object object : collection) {
            this.addBean(object);
        }
    }

    @Override
    public <T> Collection<T> getBeans(Class<T> clazz) {
        ArrayList<T> arrayList = null;
        for (Bean bean : this._beans) {
            if (!clazz.isInstance(bean._bean)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<T>();
            }
            arrayList.add(clazz.cast(bean._bean));
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        for (Bean bean : this._beans) {
            if (!clazz.isInstance(bean._bean)) continue;
            return clazz.cast(bean._bean);
        }
        return null;
    }

    public void removeBeans() {
        ArrayList<Bean> arrayList = new ArrayList<Bean>(this._beans);
        for (Bean bean : arrayList) {
            this.remove(bean);
        }
    }

    private Bean getBean(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            return bean;
        }
        return null;
    }

    @Override
    public boolean removeBean(Object object) {
        Bean bean = this.getBean(object);
        return bean != null && this.remove(bean);
    }

    private boolean remove(Bean bean) {
        if (this._beans.remove(bean)) {
            boolean bl = bean.isManaged();
            this.unmanage(bean);
            for (Container.Listener listener : this._listeners) {
                listener.beanRemoved(this, bean._bean);
            }
            if (bean._bean instanceof Container.Listener) {
                this.removeEventListener((Container.Listener)bean._bean);
            }
            if (bl && bean._bean instanceof LifeCycle) {
                try {
                    this.stop((LifeCycle)bean._bean);
                }
                catch (Error | RuntimeException throwable) {
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeEventListener(Container.Listener listener) {
        if (this._listeners.remove(listener)) {
            for (Bean bean : this._beans) {
                listener.beanRemoved(this, bean._bean);
                if (!(listener instanceof Container.InheritedListener) || !bean.isManaged() || !(bean._bean instanceof Container)) continue;
                ((Container)bean._bean).removeBean(listener);
            }
        }
    }

    @Override
    public void setStopTimeout(long l) {
        super.setStopTimeout(l);
        for (Bean bean : this._beans) {
            if (!bean.isManaged() || !(bean._bean instanceof AbstractLifeCycle)) continue;
            ((AbstractLifeCycle)bean._bean).setStopTimeout(l);
        }
    }

    @ManagedOperation(value="Dump the object to stderr")
    public void dumpStdErr() {
        try {
            this.dump(System.err, "");
            System.err.println("key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined");
        }
        catch (IOException iOException) {
            LOG.warn(iOException);
        }
    }

    @Override
    @ManagedOperation(value="Dump the object to a string")
    public String dump() {
        return Dumpable.dump(this);
    }

    @Deprecated
    public static String dump(Dumpable dumpable) {
        return Dumpable.dump(dumpable);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        this.dumpObjects(appendable, string, new Object[0]);
    }

    public void dump(Appendable appendable) throws IOException {
        this.dump(appendable, "");
    }

    @Deprecated
    protected void dumpThis(Appendable appendable) throws IOException {
        appendable.append(String.valueOf(this)).append(" - ").append(this.getState()).append("\n");
    }

    @Deprecated
    public static void dumpObject(Appendable appendable, Object object) throws IOException {
        Dumpable.dumpObject(appendable, object);
    }

    protected void dumpObjects(Appendable appendable, String string, Object ... objectArray) throws IOException {
        Dumpable.dumpObjects(appendable, string, this, objectArray);
    }

    @Deprecated
    protected void dumpBeans(Appendable appendable, String string, Collection<?> ... collectionArray) throws IOException {
        ContainerLifeCycle.dump(appendable, string, collectionArray);
    }

    @Deprecated
    public static void dump(Appendable appendable, String string, Collection<?> ... collectionArray) throws IOException {
        if (collectionArray.length == 0) {
            return;
        }
        int n = 0;
        for (Collection<?> collection : collectionArray) {
            n += collection.size();
        }
        if (n == 0) {
            return;
        }
        int n2 = 0;
        for (Collection<?> collection : collectionArray) {
            for (Object obj : collection) {
                appendable.append(string).append(" +- ");
                Dumpable.dumpObjects(appendable, string + (++n2 < n ? " |  " : "    "), obj, new Object[0]);
            }
        }
    }

    public void updateBean(Object object, Object object2) {
        if (object2 != object) {
            if (object != null) {
                this.removeBean(object);
            }
            if (object2 != null) {
                this.addBean(object2);
            }
        }
    }

    public void updateBean(Object object, Object object2, boolean bl) {
        if (object2 != object) {
            if (object != null) {
                this.removeBean(object);
            }
            if (object2 != null) {
                this.addBean(object2, bl);
            }
        }
    }

    public void updateBeans(Object[] objectArray, Object[] objectArray2) {
        if (objectArray != null) {
            block0: for (Object object : objectArray) {
                if (objectArray2 != null) {
                    for (Object object2 : objectArray2) {
                        if (object == object2) continue block0;
                    }
                }
                this.removeBean(object);
            }
        }
        if (objectArray2 != null) {
            block2: for (Object object : objectArray2) {
                if (objectArray != null) {
                    for (Object object2 : objectArray) {
                        if (object2 == object) continue block2;
                    }
                }
                this.addBean(object);
            }
        }
    }

    @Override
    public <T> Collection<T> getContainedBeans(Class<T> clazz) {
        HashSet hashSet = new HashSet();
        this.getContainedBeans(clazz, hashSet);
        return hashSet;
    }

    protected <T> void getContainedBeans(Class<T> clazz, Collection<T> collection) {
        collection.addAll(this.getBeans(clazz));
        for (Container container : this.getBeans(Container.class)) {
            Bean bean = this.getBean(container);
            if (bean == null || !bean.isManageable()) continue;
            if (container instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)container).getContainedBeans(clazz, collection);
                continue;
            }
            collection.addAll(container.getContainedBeans(clazz));
        }
    }

    private static class Bean {
        private final Object _bean;
        private volatile Managed _managed = Managed.POJO;

        private Bean(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            this._bean = object;
        }

        public boolean isManaged() {
            return this._managed == Managed.MANAGED;
        }

        public boolean isManageable() {
            switch (this._managed) {
                case MANAGED: {
                    return true;
                }
                case AUTO: {
                    return this._bean instanceof LifeCycle && ((LifeCycle)this._bean).isStopped();
                }
            }
            return false;
        }

        public String toString() {
            return String.format("{%s,%s}", new Object[]{this._bean, this._managed});
        }
    }

    static enum Managed {
        POJO,
        MANAGED,
        UNMANAGED,
        AUTO;

    }
}

