/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Uptime {
    public static final int NOIMPL = -1;
    private static final Uptime INSTANCE = new Uptime();
    private Impl impl;

    public static Uptime getInstance() {
        return INSTANCE;
    }

    private Uptime() {
        try {
            this.impl = new DefaultImpl();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            System.err.printf("Defaulting Uptime to NOIMPL due to (%s) %s%n", unsupportedOperationException.getClass().getName(), unsupportedOperationException.getMessage());
            this.impl = null;
        }
    }

    public Impl getImpl() {
        return this.impl;
    }

    public void setImpl(Impl impl) {
        this.impl = impl;
    }

    public static long getUptime() {
        Uptime uptime = Uptime.getInstance();
        if (uptime == null || uptime.impl == null) {
            return -1L;
        }
        return uptime.impl.getUptime();
    }

    public static class DefaultImpl
    implements Impl {
        public Object mxBean;
        public Method uptimeMethod;

        public DefaultImpl() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = Class.forName("java.lang.management.ManagementFactory", true, classLoader);
                Class<?> clazz2 = Class.forName("java.lang.management.RuntimeMXBean", true, classLoader);
                Class[] classArray = new Class[]{};
                Method method = clazz.getMethod("getRuntimeMXBean", classArray);
                if (method == null) {
                    throw new UnsupportedOperationException("method getRuntimeMXBean() not found");
                }
                this.mxBean = method.invoke(clazz, new Object[0]);
                if (this.mxBean == null) {
                    throw new UnsupportedOperationException("getRuntimeMXBean() method returned null");
                }
                this.uptimeMethod = clazz2.getMethod("getUptime", classArray);
                if (this.mxBean == null) {
                    throw new UnsupportedOperationException("method getUptime() not found");
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException throwable) {
                throw new UnsupportedOperationException("Implementation not available in this environment", throwable);
            }
        }

        @Override
        public long getUptime() {
            try {
                return (Long)this.uptimeMethod.invoke(this.mxBean, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                return -1L;
            }
        }
    }

    public static interface Impl {
        public long getUptime();
    }
}

