/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SearchPattern {
    private static final int ALPHABET_SIZE = 256;
    private final int[] table = new int[256];
    private final byte[] pattern;

    public static SearchPattern compile(byte[] byArray) {
        return new SearchPattern(Arrays.copyOf(byArray, byArray.length));
    }

    public static SearchPattern compile(String string) {
        return new SearchPattern(string.getBytes(StandardCharsets.UTF_8));
    }

    private SearchPattern(byte[] byArray) {
        this.pattern = byArray;
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Empty Pattern");
        }
        Arrays.fill(this.table, byArray.length);
        for (int i = 0; i < byArray.length - 1; ++i) {
            this.table[0xFF & byArray[i]] = byArray.length - 1 - i;
        }
    }

    public int match(byte[] byArray, int n, int n2) {
        this.validateArgs(byArray, n, n2);
        for (int i = n; i <= n + n2 - this.pattern.length; i += this.table[0xFF & byArray[i + this.pattern.length - 1]]) {
            int n3 = this.pattern.length - 1;
            while (byArray[i + n3] == this.pattern[n3]) {
                if (n3 == 0) {
                    return i;
                }
                --n3;
            }
        }
        return -1;
    }

    public int endsWith(byte[] byArray, int n, int n2) {
        int n3;
        this.validateArgs(byArray, n, n2);
        int n4 = n3 = this.pattern.length <= n2 ? n + n2 - this.pattern.length : n;
        while (n3 < n + n2) {
            int n5 = n + n2 - 1 - n3;
            while (byArray[n3 + n5] == this.pattern[n5]) {
                if (n5 == 0) {
                    return n + n2 - n3;
                }
                --n5;
            }
            ++n3;
        }
        return 0;
    }

    public int startsWith(byte[] byArray, int n, int n2, int n3) {
        this.validateArgs(byArray, n, n2);
        int n4 = 0;
        for (int i = 0; i < this.pattern.length - n3 && i < n2; ++i) {
            if (byArray[n + i] == this.pattern[i + n3]) {
                ++n4;
                continue;
            }
            return 0;
        }
        return n3 + n4;
    }

    private void validateArgs(byte[] byArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("offset was negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length was negative");
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("(offset+length) out of bounds of data[]");
        }
    }

    public int getLength() {
        return this.pattern.length;
    }
}

