/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;

public class RolloverFileOutputStream
extends OutputStream {
    private static Timer __rollover;
    static final String YYYY_MM_DD = "yyyy_mm_dd";
    static final String ROLLOVER_FILE_DATE_FORMAT = "yyyy_MM_dd";
    static final String ROLLOVER_FILE_BACKUP_FORMAT = "HHmmssSSS";
    static final int ROLLOVER_FILE_RETAIN_DAYS = 31;
    private OutputStream _out;
    private RollTask _rollTask;
    private SimpleDateFormat _fileBackupFormat;
    private SimpleDateFormat _fileDateFormat;
    private String _filename;
    private File _file;
    private boolean _append;
    private int _retainDays;

    public RolloverFileOutputStream(String string) throws IOException {
        this(string, true, 31);
    }

    public RolloverFileOutputStream(String string, boolean bl) throws IOException {
        this(string, bl, 31);
    }

    public RolloverFileOutputStream(String string, boolean bl, int n) throws IOException {
        this(string, bl, n, TimeZone.getDefault());
    }

    public RolloverFileOutputStream(String string, boolean bl, int n, TimeZone timeZone) throws IOException {
        this(string, bl, n, timeZone, null, null, ZonedDateTime.now(timeZone.toZoneId()));
    }

    public RolloverFileOutputStream(String string, boolean bl, int n, TimeZone timeZone, String string2, String string3) throws IOException {
        this(string, bl, n, timeZone, string2, string3, ZonedDateTime.now(timeZone.toZoneId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RolloverFileOutputStream(String string, boolean bl, int n, TimeZone timeZone, String string2, String string3, ZonedDateTime zonedDateTime) throws IOException {
        if (string2 == null) {
            string2 = ROLLOVER_FILE_DATE_FORMAT;
        }
        this._fileDateFormat = new SimpleDateFormat(string2);
        if (string3 == null) {
            string3 = ROLLOVER_FILE_BACKUP_FORMAT;
        }
        this._fileBackupFormat = new SimpleDateFormat(string3);
        this._fileBackupFormat.setTimeZone(timeZone);
        this._fileDateFormat.setTimeZone(timeZone);
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (string == null) {
            throw new IllegalArgumentException("Invalid filename");
        }
        this._filename = string;
        this._append = bl;
        this._retainDays = n;
        this.setFile(zonedDateTime);
        Class<RolloverFileOutputStream> clazz = RolloverFileOutputStream.class;
        synchronized (RolloverFileOutputStream.class) {
            if (__rollover == null) {
                __rollover = new Timer(RolloverFileOutputStream.class.getName(), true);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            this.scheduleNextRollover(zonedDateTime);
            return;
        }
    }

    public static ZonedDateTime toMidnight(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toLocalDate().atStartOfDay(zonedDateTime.getZone()).plus(1L, ChronoUnit.DAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextRollover(ZonedDateTime zonedDateTime) {
        this._rollTask = new RollTask();
        ZonedDateTime zonedDateTime2 = RolloverFileOutputStream.toMidnight(zonedDateTime);
        long l = zonedDateTime2.toInstant().toEpochMilli() - zonedDateTime.toInstant().toEpochMilli();
        Class<RolloverFileOutputStream> clazz = RolloverFileOutputStream.class;
        synchronized (RolloverFileOutputStream.class) {
            __rollover.schedule((TimerTask)this._rollTask, l);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._file == null) {
            return null;
        }
        return this._file.toString();
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFile(ZonedDateTime zonedDateTime) throws IOException {
        File file = null;
        File file2 = null;
        File file3 = null;
        RolloverFileOutputStream rolloverFileOutputStream = this;
        synchronized (rolloverFileOutputStream) {
            File file4 = new File(this._filename);
            this._filename = file4.getCanonicalPath();
            file4 = new File(this._filename);
            File file5 = new File(file4.getParent());
            if (!file5.isDirectory() || !file5.canWrite()) {
                throw new IOException("Cannot write log directory " + file5);
            }
            String string = file4.getName();
            int n = string.toLowerCase(Locale.ENGLISH).indexOf(YYYY_MM_DD);
            if (n >= 0) {
                file4 = new File(file5, string.substring(0, n) + this._fileDateFormat.format(new Date(zonedDateTime.toInstant().toEpochMilli())) + string.substring(n + YYYY_MM_DD.length()));
            }
            if (file4.exists() && !file4.canWrite()) {
                throw new IOException("Cannot write log file " + file4);
            }
            if (this._out == null || n >= 0) {
                file = this._file;
                file2 = this._file = file4;
                OutputStream outputStream = this._out;
                if (outputStream != null) {
                    outputStream.close();
                }
                if (!this._append && file4.exists()) {
                    file3 = new File(file4.toString() + "." + this._fileBackupFormat.format(new Date(zonedDateTime.toInstant().toEpochMilli())));
                    this.renameFile(file4, file3);
                }
                this._out = new FileOutputStream(file4.toString(), this._append);
            }
        }
        if (file2 != null) {
            this.rollover(file, file3, file2);
        }
    }

    private void renameFile(File file, File file2) throws IOException {
        if (!file.renameTo(file2)) {
            try {
                Files.move(file.toPath(), file2.toPath(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                Files.copy(file.toPath(), file2.toPath(), new CopyOption[0]);
                Files.deleteIfExists(file.toPath());
            }
        }
    }

    protected void rollover(File file, File file2, File file3) {
    }

    void removeOldFiles(ZonedDateTime zonedDateTime) {
        if (this._retainDays > 0) {
            long l = zonedDateTime.minus(this._retainDays, ChronoUnit.DAYS).toInstant().toEpochMilli();
            File file = new File(this._filename);
            File file2 = new File(file.getParent());
            String string = file.getName();
            int n = string.toLowerCase(Locale.ENGLISH).indexOf(YYYY_MM_DD);
            if (n < 0) {
                return;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + YYYY_MM_DD.length());
            String[] stringArray = file2.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file3;
                string = stringArray[i];
                if (!string.startsWith(string2) || string.indexOf(string3, string2.length()) < 0 || (file3 = new File(file2, string)).lastModified() >= l) continue;
                file3.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        RolloverFileOutputStream rolloverFileOutputStream = this;
        synchronized (rolloverFileOutputStream) {
            this._out.write(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray) throws IOException {
        RolloverFileOutputStream rolloverFileOutputStream = this;
        synchronized (rolloverFileOutputStream) {
            this._out.write(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        RolloverFileOutputStream rolloverFileOutputStream = this;
        synchronized (rolloverFileOutputStream) {
            this._out.write(byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        RolloverFileOutputStream rolloverFileOutputStream = this;
        synchronized (rolloverFileOutputStream) {
            this._out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            try {
                this._out.close();
            }
            finally {
                this._out = null;
                this._file = null;
            }
        }
        object = RolloverFileOutputStream.class;
        synchronized (RolloverFileOutputStream.class) {
            if (this._rollTask != null) {
                this._rollTask.cancel();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class RollTask
    extends TimerTask {
        private RollTask() {
        }

        @Override
        public void run() {
            try {
                ZonedDateTime zonedDateTime = ZonedDateTime.now(RolloverFileOutputStream.this._fileDateFormat.getTimeZone().toZoneId());
                RolloverFileOutputStream.this.setFile(zonedDateTime);
                RolloverFileOutputStream.this.removeOldFiles(zonedDateTime);
                RolloverFileOutputStream.this.scheduleNextRollover(zonedDateTime);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
    }
}

