/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class RegexSet
extends AbstractSet<String>
implements Predicate<String> {
    private final Set<String> _patterns = new HashSet<String>();
    private final Set<String> _unmodifiable = Collections.unmodifiableSet(this._patterns);
    private Pattern _pattern;

    @Override
    public Iterator<String> iterator() {
        return this._unmodifiable.iterator();
    }

    @Override
    public int size() {
        return this._patterns.size();
    }

    @Override
    public boolean add(String string) {
        boolean bl = this._patterns.add(string);
        if (bl) {
            this.updatePattern();
        }
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = this._patterns.remove(object);
        if (bl) {
            this.updatePattern();
        }
        return bl;
    }

    @Override
    public boolean isEmpty() {
        return this._patterns.isEmpty();
    }

    @Override
    public void clear() {
        this._patterns.clear();
        this._pattern = null;
    }

    private void updatePattern() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("^(");
        for (String string : this._patterns) {
            if (stringBuilder.length() > 2) {
                stringBuilder.append('|');
            }
            stringBuilder.append('(');
            stringBuilder.append(string);
            stringBuilder.append(')');
        }
        stringBuilder.append(")$");
        this._pattern = Pattern.compile(stringBuilder.toString());
    }

    @Override
    public boolean test(String string) {
        return this._pattern != null && this._pattern.matcher(string).matches();
    }

    public boolean matches(String string) {
        return this._pattern != null && this._pattern.matcher(string).matches();
    }
}

