/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.eclipse.jetty.util.JavaVersion;
import org.eclipse.jetty.util.TypeUtil;

public class MultiReleaseJarFile
implements Closeable {
    private static final String META_INF_VERSIONS = "META-INF/versions/";
    private final JarFile jarFile;
    private final int platform;
    private final boolean multiRelease;
    private final Map<String, VersionedJarEntry> entries;

    public MultiReleaseJarFile(File file) throws IOException {
        this(file, JavaVersion.VERSION.getPlatform(), false);
    }

    public MultiReleaseJarFile(File file, int n, boolean bl) throws IOException {
        if (file == null || !file.exists() || !file.canRead() || file.isDirectory()) {
            throw new IllegalArgumentException("bad jar file: " + file);
        }
        this.jarFile = new JarFile(file, true, 1);
        this.platform = n;
        Manifest manifest = this.jarFile.getManifest();
        this.multiRelease = manifest == null ? false : Boolean.parseBoolean(String.valueOf(manifest.getMainAttributes().getValue("Multi-Release")));
        TreeMap treeMap = new TreeMap();
        this.jarFile.stream().map(jarEntry -> new VersionedJarEntry((JarEntry)jarEntry)).filter(versionedJarEntry -> (bl || !versionedJarEntry.isDirectory()) && versionedJarEntry.isApplicable()).forEach(versionedJarEntry -> treeMap.compute(versionedJarEntry.name, (string, versionedJarEntry2) -> versionedJarEntry2 == null || versionedJarEntry2.isReplacedBy((VersionedJarEntry)versionedJarEntry) ? versionedJarEntry : versionedJarEntry2));
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            VersionedJarEntry versionedJarEntry2;
            Map.Entry entry = iterator.next();
            VersionedJarEntry versionedJarEntry3 = (VersionedJarEntry)entry.getValue();
            if (!versionedJarEntry3.inner) continue;
            VersionedJarEntry versionedJarEntry4 = versionedJarEntry2 = versionedJarEntry3.outer == null ? null : (VersionedJarEntry)treeMap.get(versionedJarEntry3.outer);
            if (versionedJarEntry2 != null && versionedJarEntry2.version == versionedJarEntry3.version) continue;
            iterator.remove();
        }
        this.entries = Collections.unmodifiableMap(treeMap);
    }

    public boolean isMultiRelease() {
        return this.multiRelease;
    }

    public int getVersion() {
        return this.platform;
    }

    public Stream<VersionedJarEntry> stream() {
        return this.entries.values().stream();
    }

    public VersionedJarEntry getEntry(String string) {
        return this.entries.get(string);
    }

    @Override
    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    public String toString() {
        return String.format("%s[%b,%d]", this.jarFile.getName(), this.isMultiRelease(), this.getVersion());
    }

    public class VersionedJarEntry {
        final JarEntry entry;
        final String name;
        final int version;
        final boolean inner;
        final String outer;

        VersionedJarEntry(JarEntry jarEntry) {
            int n = 0;
            String string = jarEntry.getName();
            if (string.startsWith(MultiReleaseJarFile.META_INF_VERSIONS)) {
                n = -1;
                int n2 = string.indexOf(47, MultiReleaseJarFile.META_INF_VERSIONS.length());
                if (n2 > MultiReleaseJarFile.META_INF_VERSIONS.length() && n2 < string.length()) {
                    try {
                        n = TypeUtil.parseInt(string, MultiReleaseJarFile.META_INF_VERSIONS.length(), n2 - MultiReleaseJarFile.META_INF_VERSIONS.length(), 10);
                        string = string.substring(n2 + 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new RuntimeException("illegal version in " + MultiReleaseJarFile.this.jarFile, numberFormatException);
                    }
                }
            }
            this.entry = jarEntry;
            this.name = string;
            this.version = n;
            this.inner = string.contains("$") && string.toLowerCase(Locale.ENGLISH).endsWith(".class");
            this.outer = this.inner ? string.substring(0, string.indexOf(36)) + ".class" : null;
        }

        public String getName() {
            return this.name;
        }

        public String getNameInJar() {
            return this.entry.getName();
        }

        public int getVersion() {
            return this.version;
        }

        public boolean isVersioned() {
            return this.version > 0;
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public InputStream getInputStream() throws IOException {
            return MultiReleaseJarFile.this.jarFile.getInputStream(this.entry);
        }

        boolean isApplicable() {
            if (MultiReleaseJarFile.this.multiRelease) {
                return (this.version == 0 || this.version == MultiReleaseJarFile.this.platform) && this.name.length() > 0;
            }
            return this.version == 0;
        }

        boolean isReplacedBy(VersionedJarEntry versionedJarEntry) {
            if (this.isDirectory()) {
                return versionedJarEntry.version == 0;
            }
            return this.name.equals(versionedJarEntry.name) && versionedJarEntry.version > this.version;
        }

        public String toString() {
            return String.format("%s->%s[%d]", this.name, this.entry.getName(), this.version);
        }
    }
}

