/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Part;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.ReadLineInputStream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated
public class MultiPartInputStreamParser {
    private static final Logger LOG = Log.getLogger(MultiPartInputStreamParser.class);
    private static final int DEFAULT_MAX_FORM_KEYS = 1000;
    public static final MultipartConfigElement __DEFAULT_MULTIPART_CONFIG = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
    public static final MultiMap<Part> EMPTY_MAP = new MultiMap(Collections.emptyMap());
    private final int _maxParts;
    private int _numParts;
    protected InputStream _in;
    protected MultipartConfigElement _config;
    protected String _contentType;
    protected MultiMap<Part> _parts;
    protected Exception _err;
    protected File _tmpDir;
    protected File _contextTmpDir;
    protected boolean _writeFilesWithFilenames;
    protected boolean _parsed;
    private EnumSet<NonCompliance> nonComplianceWarnings = EnumSet.noneOf(NonCompliance.class);

    public EnumSet<NonCompliance> getNonComplianceWarnings() {
        return this.nonComplianceWarnings;
    }

    public MultiPartInputStreamParser(InputStream inputStream, String string, MultipartConfigElement multipartConfigElement, File file) {
        this(inputStream, string, multipartConfigElement, file, 1000);
    }

    public MultiPartInputStreamParser(InputStream inputStream, String string, MultipartConfigElement multipartConfigElement, File file, int n) {
        this._contentType = string;
        this._config = multipartConfigElement;
        this._contextTmpDir = file;
        this._maxParts = n;
        if (this._contextTmpDir == null) {
            this._contextTmpDir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (this._config == null) {
            this._config = new MultipartConfigElement(this._contextTmpDir.getAbsolutePath());
        }
        if (inputStream instanceof ServletInputStream && ((ServletInputStream)inputStream).isFinished()) {
            this._parts = EMPTY_MAP;
            this._parsed = true;
            return;
        }
        this._in = new ReadLineInputStream(inputStream);
    }

    public Collection<Part> getParsedParts() {
        if (this._parts == null) {
            return Collections.emptyList();
        }
        Collection collection = this._parts.values();
        ArrayList<Part> arrayList = new ArrayList<Part>();
        for (List list : collection) {
            List list2 = LazyList.getList(list, false);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public void deleteParts() {
        if (!this._parsed) {
            return;
        }
        Collection<Part> collection = this.getParsedParts();
        MultiException multiException = new MultiException();
        for (Part part : collection) {
            try {
                ((MultiPart)part).cleanUp();
            }
            catch (Exception exception) {
                multiException.add(exception);
            }
        }
        this._parts.clear();
        multiException.ifExceptionThrowRuntime();
    }

    public Collection<Part> getParts() throws IOException {
        if (!this._parsed) {
            this.parse();
        }
        this.throwIfError();
        Collection collection = this._parts.values();
        ArrayList<Part> arrayList = new ArrayList<Part>();
        for (List list : collection) {
            List list2 = LazyList.getList(list, false);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public Part getPart(String string) throws IOException {
        if (!this._parsed) {
            this.parse();
        }
        this.throwIfError();
        return this._parts.getValue(string, 0);
    }

    protected void throwIfError() throws IOException {
        if (this._err != null) {
            if (this._err instanceof IOException) {
                throw (IOException)this._err;
            }
            if (this._err instanceof IllegalStateException) {
                throw (IllegalStateException)this._err;
            }
            throw new IllegalStateException(this._err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse() {
        block52: {
            if (this._parsed) {
                return;
            }
            this._parsed = true;
            long l = 0L;
            this._parts = new MultiMap();
            if (this._contentType == null || !this._contentType.startsWith("multipart/form-data")) {
                return;
            }
            try {
                EnumSet<ReadLineInputStream.Termination> enumSet;
                Object object;
                this._tmpDir = this._config.getLocation() == null ? this._contextTmpDir : ("".equals(this._config.getLocation()) ? this._contextTmpDir : (((File)(object = new File(this._config.getLocation()))).isAbsolute() ? object : new File(this._contextTmpDir, this._config.getLocation())));
                if (!this._tmpDir.exists()) {
                    this._tmpDir.mkdirs();
                }
                object = "";
                int n = this._contentType.indexOf("boundary=");
                if (n >= 0) {
                    int n2 = this._contentType.indexOf(";", n);
                    n2 = n2 < 0 ? this._contentType.length() : n2;
                    object = QuotedStringTokenizer.unquote(this.value(this._contentType.substring(n, n2)).trim());
                }
                String string = "--" + (String)object;
                String string2 = string + "--";
                byte[] byArray = string2.getBytes(StandardCharsets.ISO_8859_1);
                String string3 = null;
                try {
                    string3 = ((ReadLineInputStream)this._in).readLine();
                }
                catch (IOException iOException) {
                    LOG.warn("Badly formatted multipart request", new Object[0]);
                    throw iOException;
                }
                if (string3 == null) {
                    throw new IOException("Missing content for multipart request");
                }
                boolean bl = false;
                String string4 = string3;
                string3 = string3.trim();
                while (string3 != null && !string3.equals(string) && !string3.equals(string2)) {
                    if (!bl) {
                        LOG.warn("Badly formatted multipart request", new Object[0]);
                        bl = true;
                    }
                    string4 = string3 = ((ReadLineInputStream)this._in).readLine();
                    if (string3 == null) continue;
                    string3 = string3.trim();
                }
                if (string3 == null || string3.length() == 0) {
                    throw new IOException("Missing initial multi part boundary");
                }
                if (string3.equals(string2)) {
                    return;
                }
                if (Character.isWhitespace(string4.charAt(0))) {
                    this.nonComplianceWarnings.add(NonCompliance.NO_CRLF_AFTER_PREAMBLE);
                }
                boolean bl2 = false;
                block8: while (!bl2) {
                    enumSet = null;
                    String string5 = null;
                    String string6 = null;
                    MultiMap<String> multiMap = new MultiMap<String>();
                    while ((string3 = ((ReadLineInputStream)this._in).readLine()) != null) {
                        Object object2;
                        Object object3;
                        String string7;
                        Object object4;
                        int n3;
                        if (!"".equals(string3)) {
                            if (this._config.getMaxRequestSize() > 0L && (l += (long)string3.length()) > this._config.getMaxRequestSize()) {
                                throw new IllegalStateException("Request exceeds maxRequestSize (" + this._config.getMaxRequestSize() + ")");
                            }
                            n3 = string3.indexOf(58);
                            if (n3 <= 0) continue;
                            object4 = string3.substring(0, n3).trim().toLowerCase(Locale.ENGLISH);
                            string7 = string3.substring(n3 + 1).trim();
                            multiMap.put((String)object4, string7);
                            if (((String)object4).equalsIgnoreCase("content-disposition")) {
                                enumSet = string7;
                            }
                            if (((String)object4).equalsIgnoreCase("content-type")) {
                                string5 = string7;
                            }
                            if (!((String)object4).equals("content-transfer-encoding")) continue;
                            string6 = string7;
                            continue;
                        }
                        n3 = 0;
                        if (enumSet == null) {
                            throw new IOException("Missing content-disposition");
                        }
                        object4 = new QuotedStringTokenizer((String)((Object)enumSet), ";", false, true);
                        string7 = null;
                        String string8 = null;
                        while (((QuotedStringTokenizer)object4).hasMoreTokens()) {
                            object3 = ((QuotedStringTokenizer)object4).nextToken().trim();
                            object2 = ((String)object3).toLowerCase(Locale.ENGLISH);
                            if (((String)object2).startsWith("form-data")) {
                                n3 = 1;
                                continue;
                            }
                            if (((String)object2).startsWith("name=")) {
                                string7 = this.value((String)object3);
                                continue;
                            }
                            if (!((String)object2).startsWith("filename=")) continue;
                            string8 = this.filenameValue((String)object3);
                        }
                        if (n3 == 0 || string7 == null) continue block8;
                        ++this._numParts;
                        if (this._maxParts >= 0 && this._numParts > this._maxParts) {
                            throw new IllegalStateException(String.format("Form with too many parts [%d > %d]", this._numParts, this._maxParts));
                        }
                        object3 = new MultiPart(string7, string8);
                        ((MultiPart)object3).setHeaders(multiMap);
                        ((MultiPart)object3).setContentType(string5);
                        this._parts.add(string7, (Part)object3);
                        ((MultiPart)object3).open();
                        object2 = null;
                        if ("base64".equalsIgnoreCase(string6)) {
                            this.nonComplianceWarnings.add(NonCompliance.BASE64_TRANSFER_ENCODING);
                            object2 = new Base64InputStream((ReadLineInputStream)this._in);
                        } else if ("quoted-printable".equalsIgnoreCase(string6)) {
                            this.nonComplianceWarnings.add(NonCompliance.QUOTED_PRINTABLE_TRANSFER_ENCODING);
                            object2 = new FilterInputStream(this._in){

                                @Override
                                public int read() throws IOException {
                                    int n = this.in.read();
                                    if (n >= 0 && n == 61) {
                                        int n2 = this.in.read();
                                        int n3 = this.in.read();
                                        if (n2 < 0 || n3 < 0) {
                                            throw new IOException("Unexpected end to quoted-printable byte");
                                        }
                                        char[] cArray = new char[]{(char)n2, (char)n3};
                                        n = Integer.parseInt(new String(cArray), 16);
                                    }
                                    return n;
                                }
                            };
                        } else {
                            object2 = this._in;
                        }
                        try {
                            int n4 = -2;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            while (true) {
                                int n5;
                                int n6 = 0;
                                while ((n5 = n4 != -2 ? n4 : ((InputStream)object2).read()) != -1) {
                                    if (this._config.getMaxRequestSize() > 0L && ++l > this._config.getMaxRequestSize()) {
                                        throw new IllegalStateException("Request exceeds maxRequestSize (" + this._config.getMaxRequestSize() + ")");
                                    }
                                    n4 = -2;
                                    if (n5 == 13 || n5 == 10) {
                                        if (n5 != 13) break;
                                        ((InputStream)object2).mark(1);
                                        int n7 = ((InputStream)object2).read();
                                        if (n7 != 10) {
                                            ((InputStream)object2).reset();
                                            break;
                                        }
                                        n4 = n7;
                                        break;
                                    }
                                    if (n6 >= 0 && n6 < byArray.length && n5 == byArray[n6]) {
                                        ++n6;
                                        continue;
                                    }
                                    if (bl3) {
                                        ((MultiPart)object3).write(13);
                                    }
                                    if (bl4) {
                                        ((MultiPart)object3).write(10);
                                    }
                                    bl4 = false;
                                    bl3 = false;
                                    if (n6 > 0) {
                                        ((MultiPart)object3).write(byArray, 0, n6);
                                    }
                                    n6 = -1;
                                    ((MultiPart)object3).write(n5);
                                }
                                if (n6 > 0 && n6 < byArray.length - 2 || n6 == byArray.length - 1) {
                                    if (bl3) {
                                        ((MultiPart)object3).write(13);
                                    }
                                    if (bl4) {
                                        ((MultiPart)object3).write(10);
                                    }
                                    bl4 = false;
                                    bl3 = false;
                                    ((MultiPart)object3).write(byArray, 0, n6);
                                    n6 = -1;
                                }
                                if (n6 > 0 || n5 == -1) {
                                    if (n6 == byArray.length) {
                                        bl2 = true;
                                    }
                                    if (n4 != 10) continue block8;
                                    n4 = -2;
                                    continue block8;
                                }
                                if (bl3) {
                                    ((MultiPart)object3).write(13);
                                }
                                if (bl4) {
                                    ((MultiPart)object3).write(10);
                                }
                                bl3 = n5 == 13;
                                boolean bl5 = bl4 = n5 == 10 || n4 == 10;
                                if (n4 != 10) continue;
                                n4 = -2;
                            }
                        }
                        finally {
                            ((MultiPart)object3).close();
                            continue block8;
                        }
                    }
                    break block8;
                }
                if (bl2) {
                    while (string3 != null) {
                        string3 = ((ReadLineInputStream)this._in).readLine();
                    }
                    enumSet = ((ReadLineInputStream)this._in).getLineTerminations();
                    if (enumSet.contains((Object)ReadLineInputStream.Termination.CR)) {
                        this.nonComplianceWarnings.add(NonCompliance.CR_LINE_TERMINATION);
                    }
                    if (enumSet.contains((Object)ReadLineInputStream.Termination.LF)) {
                        this.nonComplianceWarnings.add(NonCompliance.LF_LINE_TERMINATION);
                    }
                    break block52;
                }
                throw new IOException("Incomplete parts");
            }
            catch (Exception exception) {
                this._err = exception;
            }
        }
    }

    @Deprecated
    public void setDeleteOnExit(boolean bl) {
    }

    public void setWriteFilesWithFilenames(boolean bl) {
        this._writeFilesWithFilenames = bl;
    }

    public boolean isWriteFilesWithFilenames() {
        return this._writeFilesWithFilenames;
    }

    @Deprecated
    public boolean isDeleteOnExit() {
        return false;
    }

    private String value(String string) {
        int n = string.indexOf(61);
        String string2 = string.substring(n + 1).trim();
        return QuotedStringTokenizer.unquoteOnly(string2);
    }

    private String filenameValue(String string) {
        int n = string.indexOf(61);
        String string2 = string.substring(n + 1).trim();
        if (string2.matches(".??[a-z,A-Z]\\:\\\\[^\\\\].*")) {
            char c;
            char c2 = string2.charAt(0);
            if (c2 == '\"' || c2 == '\'') {
                string2 = string2.substring(1);
            }
            if ((c = string2.charAt(string2.length() - 1)) == '\"' || c == '\'') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        return QuotedStringTokenizer.unquoteOnly(string2, true);
    }

    private static class Base64InputStream
    extends InputStream {
        ReadLineInputStream _in;
        String _line;
        byte[] _buffer;
        int _pos;
        Base64.Decoder base64Decoder = Base64.getDecoder();

        public Base64InputStream(ReadLineInputStream readLineInputStream) {
            this._in = readLineInputStream;
        }

        @Override
        public int read() throws IOException {
            if (this._buffer == null || this._pos >= this._buffer.length) {
                this._line = this._in.readLine();
                if (this._line == null) {
                    return -1;
                }
                if (this._line.startsWith("--")) {
                    this._buffer = (this._line + "\r\n").getBytes();
                } else if (this._line.length() == 0) {
                    this._buffer = "\r\n".getBytes();
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4 * this._line.length() / 3 + 2);
                    byteArrayOutputStream.write(this.base64Decoder.decode(this._line));
                    byteArrayOutputStream.write(13);
                    byteArrayOutputStream.write(10);
                    this._buffer = byteArrayOutputStream.toByteArray();
                }
                this._pos = 0;
            }
            return this._buffer[this._pos++];
        }
    }

    public class MultiPart
    implements Part {
        protected String _name;
        protected String _filename;
        protected File _file;
        protected OutputStream _out;
        protected ByteArrayOutputStream2 _bout;
        protected String _contentType;
        protected MultiMap<String> _headers;
        protected long _size = 0L;
        protected boolean _temporary = true;

        public MultiPart(String string, String string2) throws IOException {
            this._name = string;
            this._filename = string2;
        }

        public String toString() {
            return String.format("Part{n=%s,fn=%s,ct=%s,s=%d,t=%b,f=%s}", this._name, this._filename, this._contentType, this._size, this._temporary, this._file);
        }

        protected void setContentType(String string) {
            this._contentType = string;
        }

        protected void open() throws IOException {
            if (MultiPartInputStreamParser.this.isWriteFilesWithFilenames() && this._filename != null && this._filename.trim().length() > 0) {
                this.createFile();
            } else {
                this._bout = new ByteArrayOutputStream2();
                this._out = this._bout;
            }
        }

        protected void close() throws IOException {
            this._out.close();
        }

        protected void write(int n) throws IOException {
            if (MultiPartInputStreamParser.this._config.getMaxFileSize() > 0L && this._size + 1L > MultiPartInputStreamParser.this._config.getMaxFileSize()) {
                throw new IllegalStateException("Multipart Mime part " + this._name + " exceeds max filesize");
            }
            if (MultiPartInputStreamParser.this._config.getFileSizeThreshold() > 0 && this._size + 1L > (long)MultiPartInputStreamParser.this._config.getFileSizeThreshold() && this._file == null) {
                this.createFile();
            }
            this._out.write(n);
            ++this._size;
        }

        protected void write(byte[] byArray, int n, int n2) throws IOException {
            if (MultiPartInputStreamParser.this._config.getMaxFileSize() > 0L && this._size + (long)n2 > MultiPartInputStreamParser.this._config.getMaxFileSize()) {
                throw new IllegalStateException("Multipart Mime part " + this._name + " exceeds max filesize");
            }
            if (MultiPartInputStreamParser.this._config.getFileSizeThreshold() > 0 && this._size + (long)n2 > (long)MultiPartInputStreamParser.this._config.getFileSizeThreshold() && this._file == null) {
                this.createFile();
            }
            this._out.write(byArray, n, n2);
            this._size += (long)n2;
        }

        protected void createFile() throws IOException {
            Path path = MultiPartInputStreamParser.this._tmpDir.toPath();
            Path path2 = Files.createTempFile(path, "MultiPart", "", new FileAttribute[0]);
            this._file = path2.toFile();
            OutputStream outputStream = Files.newOutputStream(path2, StandardOpenOption.WRITE);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            if (this._size > 0L && this._out != null) {
                this._out.flush();
                this._bout.writeTo(bufferedOutputStream);
                this._out.close();
            }
            this._bout = null;
            this._out = bufferedOutputStream;
        }

        protected void setHeaders(MultiMap<String> multiMap) {
            this._headers = multiMap;
        }

        public String getContentType() {
            return this._contentType;
        }

        public String getHeader(String string) {
            if (string == null) {
                return null;
            }
            return this._headers.getValue(string.toLowerCase(Locale.ENGLISH), 0);
        }

        public Collection<String> getHeaderNames() {
            return this._headers.keySet();
        }

        public Collection<String> getHeaders(String string) {
            return this._headers.getValues(string);
        }

        public InputStream getInputStream() throws IOException {
            if (this._file != null) {
                return new BufferedInputStream(new FileInputStream(this._file));
            }
            return new ByteArrayInputStream(this._bout.getBuf(), 0, this._bout.size());
        }

        public String getSubmittedFileName() {
            return this.getContentDispositionFilename();
        }

        public byte[] getBytes() {
            if (this._bout != null) {
                return this._bout.toByteArray();
            }
            return null;
        }

        public String getName() {
            return this._name;
        }

        public long getSize() {
            return this._size;
        }

        public void write(String string) throws IOException {
            if (this._file == null) {
                this._temporary = false;
                this._file = new File(MultiPartInputStreamParser.this._tmpDir, string);
                FilterOutputStream filterOutputStream = null;
                try {
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(this._file));
                    this._bout.writeTo(filterOutputStream);
                    ((BufferedOutputStream)filterOutputStream).flush();
                }
                finally {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                    this._bout = null;
                }
            } else {
                this._temporary = false;
                Path path = this._file.toPath();
                Path path2 = path.resolveSibling(string);
                Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
                this._file = path2.toFile();
            }
        }

        public void delete() throws IOException {
            if (this._file != null && this._file.exists()) {
                this._file.delete();
            }
        }

        public void cleanUp() throws IOException {
            if (this._temporary && this._file != null && this._file.exists()) {
                this._file.delete();
            }
        }

        public File getFile() {
            return this._file;
        }

        public String getContentDispositionFilename() {
            return this._filename;
        }
    }

    public static enum NonCompliance {
        CR_LINE_TERMINATION("https://tools.ietf.org/html/rfc2046#section-4.1.1"),
        LF_LINE_TERMINATION("https://tools.ietf.org/html/rfc2046#section-4.1.1"),
        NO_CRLF_AFTER_PREAMBLE("https://tools.ietf.org/html/rfc2046#section-5.1.1"),
        BASE64_TRANSFER_ENCODING("https://tools.ietf.org/html/rfc7578#section-4.7"),
        QUOTED_PRINTABLE_TRANSFER_ENCODING("https://tools.ietf.org/html/rfc7578#section-4.7");

        final String _rfcRef;

        private NonCompliance(String string2) {
            this._rfcRef = string2;
        }

        public String getURL() {
            return this._rfcRef;
        }
    }
}

