/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultiException
extends Exception {
    private static final String DEFAULT_MESSAGE = "Multiple exceptions";
    private List<Throwable> nested;

    public MultiException() {
        super(DEFAULT_MESSAGE, null, false, false);
        this.nested = new ArrayList<Throwable>();
    }

    private MultiException(List<Throwable> list) {
        super(DEFAULT_MESSAGE);
        this.nested = new ArrayList<Throwable>(list);
        if (list.size() > 0) {
            this.initCause(list.get(0));
        }
        for (Throwable throwable : list) {
            if (throwable == this) continue;
            this.addSuppressed(throwable);
        }
    }

    public void add(Throwable throwable) {
        if (throwable instanceof MultiException) {
            MultiException multiException = (MultiException)throwable;
            this.nested.addAll(multiException.nested);
        } else {
            this.nested.add(throwable);
        }
    }

    public int size() {
        return this.nested == null ? 0 : this.nested.size();
    }

    public List<Throwable> getThrowables() {
        if (this.nested == null) {
            return Collections.emptyList();
        }
        return this.nested;
    }

    public Throwable getThrowable(int n) {
        return this.nested.get(n);
    }

    public void ifExceptionThrow() throws Exception {
        if (this.nested == null) {
            return;
        }
        switch (this.nested.size()) {
            case 0: {
                break;
            }
            case 1: {
                Throwable throwable = this.nested.get(0);
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new MultiException(this.nested);
            }
            default: {
                throw new MultiException(this.nested);
            }
        }
    }

    public void ifExceptionThrowRuntime() throws Error {
        if (this.nested == null) {
            return;
        }
        switch (this.nested.size()) {
            case 0: {
                break;
            }
            case 1: {
                Throwable throwable = this.nested.get(0);
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable);
            }
            default: {
                throw new RuntimeException(new MultiException(this.nested));
            }
        }
    }

    public void ifExceptionThrowMulti() throws MultiException {
        if (this.nested == null) {
            return;
        }
        if (this.nested.size() > 0) {
            throw new MultiException(this.nested);
        }
    }

    public void ifExceptionThrowSuppressed() throws Exception {
        if (this.nested == null || this.nested.size() == 0) {
            return;
        }
        Throwable throwable = this.nested.get(0);
        if (!(throwable instanceof Error) && !(throwable instanceof Exception)) {
            throwable = new MultiException(Collections.emptyList());
        }
        for (Throwable throwable2 : this.nested) {
            if (throwable2 == throwable) continue;
            throwable.addSuppressed(throwable2);
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw (Exception)throwable;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MultiException.class.getSimpleName());
        if (this.nested == null || this.nested.size() <= 0) {
            stringBuilder.append("[]");
        } else {
            stringBuilder.append(this.nested);
        }
        return stringBuilder.toString();
    }
}

