/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.net.InetAddress;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jetty.util.StringUtil;

public class InetAddressSet
extends AbstractSet<String>
implements Set<String>,
Predicate<InetAddress> {
    private Map<String, InetPattern> _patterns = new HashMap<String, InetPattern>();

    @Override
    public boolean add(String string) {
        return this._patterns.put(string, this.newInetRange(string)) == null;
    }

    private InetPattern newInetRange(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(45);
        try {
            if (n >= 0) {
                return new CidrInetRange(string, InetAddress.getByName(string.substring(0, n).trim()), StringUtil.toInt(string, n + 1));
            }
            if (n2 >= 0) {
                return new MinMaxInetRange(string, InetAddress.getByName(string.substring(0, n2).trim()), InetAddress.getByName(string.substring(n2 + 1).trim()));
            }
            return new SingletonInetRange(string, InetAddress.getByName(string));
        }
        catch (Exception exception) {
            try {
                if (n < 0 && n2 > 0) {
                    return new LegacyInetRange(string);
                }
            }
            catch (Exception exception2) {
                exception.addSuppressed(exception2);
            }
            throw new IllegalArgumentException("Bad pattern: " + string, exception);
        }
    }

    @Override
    public boolean remove(Object object) {
        return this._patterns.remove(object) != null;
    }

    @Override
    public Iterator<String> iterator() {
        return this._patterns.keySet().iterator();
    }

    @Override
    public int size() {
        return this._patterns.size();
    }

    @Override
    public boolean test(InetAddress inetAddress) {
        if (inetAddress == null) {
            return false;
        }
        byte[] byArray = inetAddress.getAddress();
        for (InetPattern inetPattern : this._patterns.values()) {
            if (!inetPattern.test(inetAddress, byArray)) continue;
            return true;
        }
        return false;
    }

    static class LegacyInetRange
    extends InetPattern {
        int[] _min = new int[4];
        int[] _max = new int[4];

        public LegacyInetRange(String string) {
            super(string);
            String[] stringArray = string.split("\\.");
            if (stringArray.length != 4) {
                throw new IllegalArgumentException("Bad legacy pattern: " + string);
            }
            for (int i = 0; i < 4; ++i) {
                String string2 = stringArray[i].trim();
                int n = string2.indexOf(45);
                if (n < 0) {
                    this._min[i] = this._max[i] = Integer.parseInt(string2);
                } else {
                    this._min[i] = n == 0 ? 0 : StringUtil.toInt(string2, 0);
                    int n2 = this._max[i] = n == string2.length() - 1 ? 255 : StringUtil.toInt(string2, n + 1);
                }
                if (this._min[i] >= 0 && this._min[i] <= this._max[i] && this._max[i] <= 255) continue;
                throw new IllegalArgumentException("Bad legacy pattern: " + string);
            }
        }

        @Override
        public boolean test(InetAddress inetAddress, byte[] byArray) {
            if (byArray.length != 4) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                if ((0xFF & byArray[i]) >= this._min[i] && (0xFF & byArray[i]) <= this._max[i]) continue;
                return false;
            }
            return true;
        }
    }

    static class CidrInetRange
    extends InetPattern {
        final byte[] _raw;
        final int _octets;
        final int _mask;
        final int _masked;

        public CidrInetRange(String string, InetAddress inetAddress, int n) {
            super(string);
            this._raw = inetAddress.getAddress();
            this._octets = n / 8;
            this._mask = 0xFF & 255 << 8 - n % 8;
            int n2 = this._masked = this._mask == 0 ? 0 : this._raw[this._octets] & this._mask;
            if (n > this._raw.length * 8) {
                throw new IllegalArgumentException("CIDR too large: " + string);
            }
            if (this._mask != 0 && (0xFF & this._raw[this._octets]) != this._masked) {
                throw new IllegalArgumentException("CIDR bits non zero: " + string);
            }
            for (int i = this._octets + (this._mask == 0 ? 0 : 1); i < this._raw.length; ++i) {
                if (this._raw[i] == 0) continue;
                throw new IllegalArgumentException("CIDR bits non zero: " + string);
            }
        }

        @Override
        public boolean test(InetAddress inetAddress, byte[] byArray) {
            if (byArray.length != this._raw.length) {
                return false;
            }
            for (int i = 0; i < this._octets; ++i) {
                if (this._raw[i] == byArray[i]) continue;
                return false;
            }
            return this._mask == 0 || (byArray[this._octets] & this._mask) == this._masked;
        }
    }

    static class MinMaxInetRange
    extends InetPattern {
        final int[] _min;
        final int[] _max;

        public MinMaxInetRange(String string, InetAddress inetAddress, InetAddress inetAddress2) {
            super(string);
            int n;
            byte[] byArray = inetAddress.getAddress();
            byte[] byArray2 = inetAddress2.getAddress();
            if (byArray.length != byArray2.length) {
                throw new IllegalArgumentException("Cannot mix IPv4 and IPv6: " + string);
            }
            if (byArray.length == 4) {
                n = 0;
                for (char c : string.toCharArray()) {
                    if (c != '.') continue;
                    ++n;
                }
                if (n != 6) {
                    throw new IllegalArgumentException("Legacy pattern: " + string);
                }
            }
            this._min = new int[byArray.length];
            this._max = new int[byArray.length];
            for (n = 0; n < this._min.length; ++n) {
                this._min[n] = 0xFF & byArray[n];
                this._max[n] = 0xFF & byArray2[n];
            }
            for (n = 0; n < this._min.length; ++n) {
                if (this._min[n] > this._max[n]) {
                    throw new IllegalArgumentException("min is greater than max: " + string);
                }
                if (this._min[n] < this._max[n]) break;
            }
        }

        @Override
        public boolean test(InetAddress inetAddress, byte[] byArray) {
            if (byArray.length != this._min.length) {
                return false;
            }
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < this._min.length; ++i) {
                int n = 0xFF & byArray[i];
                if (!bl) {
                    if (n < this._min[i]) {
                        return false;
                    }
                    if (n > this._min[i]) {
                        bl = true;
                    }
                }
                if (!bl2) {
                    if (n > this._max[i]) {
                        return false;
                    }
                    if (n < this._max[i]) {
                        bl2 = true;
                    }
                }
                if (bl && bl2) break;
            }
            return true;
        }
    }

    static class SingletonInetRange
    extends InetPattern {
        final InetAddress _address;

        public SingletonInetRange(String string, InetAddress inetAddress) {
            super(string);
            this._address = inetAddress;
        }

        @Override
        public boolean test(InetAddress inetAddress, byte[] byArray) {
            return this._address.equals(inetAddress);
        }
    }

    static abstract class InetPattern {
        final String _pattern;

        InetPattern(String string) {
            this._pattern = string;
        }

        abstract boolean test(InetAddress var1, byte[] var2);

        public String toString() {
            return this._pattern;
        }
    }
}

