/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DeprecationWarning
implements Decorator {
    private static final Logger LOG = Log.getLogger(DeprecationWarning.class);

    @Override
    public <T> T decorate(T t) {
        if (t == null) {
            return null;
        }
        Class<?> clazz = t.getClass();
        try {
            Class<?>[] classArray = clazz.getAnnotation(Deprecated.class);
            if (classArray != null) {
                LOG.warn("Using @Deprecated Class {}", clazz.getName());
            }
        }
        catch (Throwable throwable) {
            LOG.ignore(throwable);
        }
        this.verifyIndirectTypes(clazz.getSuperclass(), clazz, "Class");
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.verifyIndirectTypes(clazz2, clazz, "Interface");
        }
        return t;
    }

    private void verifyIndirectTypes(Class<?> clazz, Class<?> clazz2, String string) {
        try {
            while (clazz != null && clazz != Object.class) {
                Deprecated deprecated = clazz.getAnnotation(Deprecated.class);
                if (deprecated != null) {
                    LOG.warn("Using indirect @Deprecated {} {} - (seen from {})", string, clazz.getName(), clazz2);
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Throwable throwable) {
            LOG.ignore(throwable);
        }
    }

    @Override
    public void destroy(Object object) {
    }
}

