/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateCache {
    public static final String DEFAULT_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private final String _formatString;
    private final String _tzFormatString;
    private final DateTimeFormatter _tzFormat;
    private final Locale _locale;
    private final ZoneId _zoneId;
    private volatile Tick _tick;

    public DateCache() {
        this(DEFAULT_FORMAT);
    }

    public DateCache(String string) {
        this(string, null, TimeZone.getDefault());
    }

    public DateCache(String string, Locale locale) {
        this(string, locale, TimeZone.getDefault());
    }

    public DateCache(String string, Locale locale, String string2) {
        this(string, locale, TimeZone.getTimeZone(string2));
    }

    public DateCache(String string, Locale locale, TimeZone timeZone) {
        this._formatString = string;
        this._locale = locale;
        int n = this._formatString.indexOf("ZZZ");
        if (n >= 0) {
            String string2 = this._formatString.substring(0, n);
            String string3 = this._formatString.substring(n + 3);
            int n2 = timeZone.getRawOffset();
            StringBuilder stringBuilder = new StringBuilder(this._formatString.length() + 10);
            stringBuilder.append(string2);
            stringBuilder.append("'");
            if (n2 >= 0) {
                stringBuilder.append('+');
            } else {
                n2 = -n2;
                stringBuilder.append('-');
            }
            int n3 = n2 / 60000;
            int n4 = n3 / 60;
            int n5 = n3 % 60;
            if (n4 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n4);
            if (n5 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n5);
            stringBuilder.append('\'');
            stringBuilder.append(string3);
            this._tzFormatString = stringBuilder.toString();
        } else {
            this._tzFormatString = this._formatString;
        }
        this._tzFormat = this._locale != null ? DateTimeFormatter.ofPattern(this._tzFormatString, this._locale) : DateTimeFormatter.ofPattern(this._tzFormatString);
        this._zoneId = timeZone.toZoneId();
        this._tzFormat.withZone(this._zoneId);
        this._tick = null;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this._zoneId);
    }

    public String format(Date date) {
        long l = date.getTime() / 1000L;
        Tick tick = this._tick;
        if (tick == null || l != tick._seconds) {
            return ZonedDateTime.ofInstant(date.toInstant(), this._zoneId).format(this._tzFormat);
        }
        return tick._string;
    }

    public String format(long l) {
        long l2 = l / 1000L;
        Tick tick = this._tick;
        if (tick == null || l2 != tick._seconds) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), this._zoneId).format(this._tzFormat);
        }
        return tick._string;
    }

    public String formatNow(long l) {
        long l2 = l / 1000L;
        Tick tick = this._tick;
        if (tick != null && tick._seconds == l2) {
            return tick._string;
        }
        return this.formatTick((long)l)._string;
    }

    public String now() {
        return this.formatNow(System.currentTimeMillis());
    }

    public Tick tick() {
        return this.formatTick(System.currentTimeMillis());
    }

    protected Tick formatTick(long l) {
        long l2 = l / 1000L;
        Tick tick = this._tick;
        if (tick == null || tick._seconds != l2) {
            String string = ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), this._zoneId).format(this._tzFormat);
            tick = this._tick = new Tick(l2, string);
        }
        return tick;
    }

    public String getFormatString() {
        return this._formatString;
    }

    public static class Tick {
        final long _seconds;
        final String _string;

        public Tick(long l, String string) {
            this._seconds = l;
            this._string = string;
        }
    }
}

