/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.CyclicTimeout;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class CyclicTimeouts<T extends Expirable>
implements Destroyable {
    private static final Logger LOG = Log.getLogger(CyclicTimeouts.class);
    private final AtomicLong earliestTimeout = new AtomicLong(Long.MAX_VALUE);
    private final CyclicTimeout cyclicTimeout;

    public CyclicTimeouts(Scheduler scheduler) {
        this.cyclicTimeout = new Timeouts(scheduler);
    }

    protected abstract Iterator<T> iterator();

    protected abstract boolean onExpired(T var1);

    private void onTimeoutExpired() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timeouts check for {}", this);
        }
        long l = System.nanoTime();
        long l2 = Long.MAX_VALUE;
        this.earliestTimeout.set(l2);
        Iterator<T> iterator = this.iterator();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Expirable expirable = (Expirable)iterator.next();
            long l3 = expirable.getExpireNanoTime();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Entity {} expires in {} ms for {}", expirable, TimeUnit.NANOSECONDS.toMillis(l3 - l), this);
            }
            if (l3 == -1L) continue;
            if (l3 <= l) {
                boolean bl = this.onExpired(expirable);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Entity {} expired, remove={} for {}", expirable, bl, this);
                }
                if (!bl) continue;
                iterator.remove();
                continue;
            }
            l2 = Math.min(l2, l3);
        }
        if (l2 < Long.MAX_VALUE) {
            this.schedule(l2);
        }
    }

    public void schedule(T t) {
        long l = t.getExpireNanoTime();
        if (l < Long.MAX_VALUE) {
            this.schedule(l);
        }
    }

    private void schedule(long l) {
        long l3 = this.earliestTimeout.getAndUpdate(l2 -> Math.min(l2, l));
        long l4 = l;
        while (l4 < l3) {
            long l5 = Math.max(0L, l4 - System.nanoTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling timeout in {} ms for {}", TimeUnit.NANOSECONDS.toMillis(l5), this);
            }
            this.schedule(this.cyclicTimeout, l5, TimeUnit.NANOSECONDS);
            l3 = l4;
            l4 = this.earliestTimeout.get();
        }
    }

    @Override
    public void destroy() {
        this.cyclicTimeout.destroy();
    }

    boolean schedule(CyclicTimeout cyclicTimeout, long l, TimeUnit timeUnit) {
        return cyclicTimeout.schedule(l, timeUnit);
    }

    private class Timeouts
    extends CyclicTimeout {
        private Timeouts(Scheduler scheduler) {
            super(scheduler);
        }

        @Override
        public void onTimeoutExpired() {
            CyclicTimeouts.this.onTimeoutExpired();
        }
    }

    public static interface Expirable {
        public long getExpireNanoTime();
    }
}

