/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class ChannelEndPoint
extends AbstractEndPoint
implements ManagedSelector.Selectable {
    private static final Logger LOG = Log.getLogger(ChannelEndPoint.class);
    private final SocketChannel _channel;
    private final ManagedSelector _selector;
    private SelectionKey _key;
    private boolean _updatePending;
    private int _currentInterestOps;
    private int _desiredInterestOps;
    private final ManagedSelector.SelectorUpdate _updateKeyAction = this::updateKeyAction;
    private final Runnable _runFillable = new RunnableCloseable("runFillable"){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return ChannelEndPoint.this.getFillInterest().getCallbackInvocationType();
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getFillInterest().fillable();
        }
    };
    private final Runnable _runCompleteWrite = new RunnableCloseable("runCompleteWrite"){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return ChannelEndPoint.this.getWriteFlusher().getCallbackInvocationType();
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getWriteFlusher().completeWrite();
        }

        @Override
        public String toString() {
            return String.format("CEP:%s:%s:%s->%s", new Object[]{ChannelEndPoint.this, this._operation, this.getInvocationType(), ChannelEndPoint.this.getWriteFlusher()});
        }
    };
    private final Runnable _runCompleteWriteFillable = new RunnableCloseable("runCompleteWriteFillable"){

        @Override
        public Invocable.InvocationType getInvocationType() {
            Invocable.InvocationType invocationType;
            Invocable.InvocationType invocationType2 = ChannelEndPoint.this.getFillInterest().getCallbackInvocationType();
            if (invocationType2 == (invocationType = ChannelEndPoint.this.getWriteFlusher().getCallbackInvocationType())) {
                return invocationType2;
            }
            if (invocationType2 == Invocable.InvocationType.EITHER && invocationType == Invocable.InvocationType.NON_BLOCKING) {
                return Invocable.InvocationType.EITHER;
            }
            if (invocationType2 == Invocable.InvocationType.NON_BLOCKING && invocationType == Invocable.InvocationType.EITHER) {
                return Invocable.InvocationType.EITHER;
            }
            return Invocable.InvocationType.BLOCKING;
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getWriteFlusher().completeWrite();
            ChannelEndPoint.this.getFillInterest().fillable();
        }
    };

    public ChannelEndPoint(SocketChannel socketChannel, ManagedSelector managedSelector, SelectionKey selectionKey, Scheduler scheduler) {
        super(scheduler);
        this._channel = socketChannel;
        this._selector = managedSelector;
        this._key = selectionKey;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this._channel.socket().getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this._channel.socket().getRemoteSocketAddress();
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    @Override
    protected void doShutdownOutput() {
        try {
            Socket socket = this._channel.socket();
            if (!socket.isOutputShutdown()) {
                socket.shutdownOutput();
            }
        }
        catch (IOException iOException) {
            LOG.debug(iOException);
        }
    }

    @Override
    public void doClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doClose {}", this);
        }
        try {
            this._key.cancel();
            this._channel.close();
        }
        catch (IOException iOException) {
            LOG.debug(iOException);
        }
        finally {
            super.doClose();
        }
    }

    @Override
    public void onClose() {
        try {
            super.onClose();
        }
        finally {
            if (this._selector != null) {
                this._selector.destroyEndPoint(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(ByteBuffer byteBuffer) throws IOException {
        int n;
        if (this.isInputShutdown()) {
            return -1;
        }
        int n2 = BufferUtil.flipToFill(byteBuffer);
        try {
            n = this._channel.read(byteBuffer);
            if (n > 0) {
                this.notIdle();
            } else if (n == -1) {
                this.shutdownInput();
            }
        }
        catch (IOException iOException) {
            LOG.debug(iOException);
            this.shutdownInput();
            n = -1;
        }
        finally {
            BufferUtil.flipToFlush(byteBuffer, n2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("filled {} {}", n, BufferUtil.toDetailString(byteBuffer));
        }
        return n;
    }

    @Override
    public boolean flush(ByteBuffer ... byteBufferArray) throws IOException {
        long l;
        try {
            l = this._channel.write(byteBufferArray);
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushed {} {}", l, this);
            }
        }
        catch (IOException iOException) {
            throw new EofException(iOException);
        }
        if (l > 0L) {
            this.notIdle();
        }
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (BufferUtil.isEmpty(byteBuffer)) continue;
            return false;
        }
        return true;
    }

    public SocketChannel getChannel() {
        return this._channel;
    }

    @Override
    public Object getTransport() {
        return this._channel;
    }

    @Override
    protected void needsFillInterest() {
        this.changeInterests(1);
    }

    @Override
    protected void onIncompleteFlush() {
        this.changeInterests(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable onSelected() {
        Runnable runnable;
        boolean bl;
        int n;
        int n2;
        int n3 = this._key.readyOps();
        ChannelEndPoint channelEndPoint = this;
        synchronized (channelEndPoint) {
            this._updatePending = true;
            n2 = this._desiredInterestOps;
            this._desiredInterestOps = n = n2 & ~n3;
        }
        boolean bl2 = (n3 & 1) != 0;
        boolean bl3 = bl = (n3 & 4) != 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSelected {}->{} r={} w={} for {}", n2, n, bl2, bl, this);
        }
        Runnable runnable2 = bl2 ? (bl ? this._runCompleteWriteFillable : this._runFillable) : (runnable = bl ? this._runCompleteWrite : null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("task {}", runnable);
        }
        return runnable;
    }

    private void updateKeyAction(Selector selector) {
        this.updateKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateKey() {
        try {
            int n;
            int n2;
            ChannelEndPoint channelEndPoint = this;
            synchronized (channelEndPoint) {
                this._updatePending = false;
                n2 = this._currentInterestOps;
                n = this._desiredInterestOps;
                if (n2 != n) {
                    this._currentInterestOps = n;
                    this._key.interestOps(n);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key interests updated {} -> {} on {}", n2, n, this);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring key update for cancelled key {}", this, cancelledKeyException);
            }
            this.close();
        }
        catch (Throwable throwable) {
            LOG.warn("Ignoring key update for {}", this, throwable);
            this.close();
        }
    }

    @Override
    public void replaceKey(SelectionKey selectionKey) {
        this._key = selectionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeInterests(int n) {
        int n2;
        int n3;
        boolean bl;
        ChannelEndPoint channelEndPoint = this;
        synchronized (channelEndPoint) {
            bl = this._updatePending;
            n3 = this._desiredInterestOps;
            n2 = n3 | n;
            if (n2 != n3) {
                this._desiredInterestOps = n2;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("changeInterests p={} {}->{} for {}", bl, n3, n2, this);
        }
        if (!bl && this._selector != null) {
            this._selector.submit(this._updateKeyAction);
        }
    }

    @Override
    public String toEndPointString() {
        return String.format("%s{io=%d/%d,kio=%d,kro=%d}", super.toEndPointString(), this._currentInterestOps, this._desiredInterestOps, ManagedSelector.safeInterestOps(this._key), ManagedSelector.safeReadyOps(this._key));
    }

    private abstract class RunnableCloseable
    extends RunnableTask
    implements Closeable {
        protected RunnableCloseable(String string) {
            super(string);
        }

        @Override
        public void close() {
            try {
                ChannelEndPoint.this.close();
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
            }
        }
    }

    private abstract class RunnableTask
    implements Runnable,
    Invocable {
        final String _operation;

        protected RunnableTask(String string) {
            this._operation = string;
        }

        public String toString() {
            return String.format("CEP:%s:%s:%s", new Object[]{ChannelEndPoint.this, this._operation, this.getInvocationType()});
        }
    }
}

