/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="Mapped Resource")
public class MappedResource<E>
implements Comparable<MappedResource<E>> {
    private final PathSpec pathSpec;
    private final E resource;

    public MappedResource(PathSpec pathSpec, E e) {
        this.pathSpec = pathSpec;
        this.resource = e;
    }

    @Override
    public int compareTo(MappedResource<E> mappedResource) {
        return this.pathSpec.compareTo(mappedResource.pathSpec);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MappedResource mappedResource = (MappedResource)object;
        if (this.pathSpec == null) {
            return mappedResource.pathSpec == null;
        }
        return this.pathSpec.equals(mappedResource.pathSpec);
    }

    @ManagedAttribute(value="path spec", readonly=true)
    public PathSpec getPathSpec() {
        return this.pathSpec;
    }

    @ManagedAttribute(value="resource", readonly=true)
    public E getResource() {
        return this.resource;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.pathSpec == null ? 0 : this.pathSpec.hashCode());
        return n2;
    }

    public String toString() {
        return String.format("MappedResource[pathSpec=%s,resource=%s]", this.pathSpec, this.resource);
    }
}

