/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.Objects;
import org.eclipse.jetty.http.pathmap.PathSpec;

public abstract class AbstractPathSpec
implements PathSpec {
    @Override
    public int compareTo(PathSpec pathSpec) {
        int n = this.getGroup().ordinal() - pathSpec.getGroup().ordinal();
        if (n != 0) {
            return n;
        }
        n = pathSpec.getSpecLength() - this.getSpecLength();
        if (n != 0) {
            return n;
        }
        n = this.getDeclaration().compareTo(pathSpec.getDeclaration());
        if (n != 0) {
            return n;
        }
        return this.getClass().getName().compareTo(pathSpec.getClass().getName());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.compareTo((AbstractPathSpec)object) == 0;
    }

    public final int hashCode() {
        return Objects.hash(this.getGroup().ordinal(), this.getSpecLength(), this.getDeclaration(), this.getClass().getName());
    }

    public String toString() {
        return String.format("%s@%s{%s}", this.getClass().getSimpleName(), Integer.toHexString(this.hashCode()), this.getDeclaration());
    }
}

