/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Objects;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.StringUtil;

public class HttpField {
    private static final String ZEROQUALITY = "q=0";
    private final HttpHeader _header;
    private final String _name;
    private final String _value;
    private int hash = 0;

    public HttpField(HttpHeader httpHeader, String string, String string2) {
        this._header = httpHeader;
        this._name = this._header != null && string == null ? this._header.asString() : Objects.requireNonNull(string, "name");
        this._value = string2;
    }

    public HttpField(HttpHeader httpHeader, String string) {
        this(httpHeader, httpHeader.asString(), string);
    }

    public HttpField(HttpHeader httpHeader, HttpHeaderValue httpHeaderValue) {
        this(httpHeader, httpHeader.asString(), httpHeaderValue.asString());
    }

    public HttpField(String string, String string2) {
        this(HttpHeader.CACHE.get(string), string, string2);
    }

    public HttpHeader getHeader() {
        return this._header;
    }

    public String getName() {
        return this._name;
    }

    public String getLowerCaseName() {
        return this._header != null ? this._header.lowerCaseName() : StringUtil.asciiToLowerCase(this._name);
    }

    public String getValue() {
        return this._value;
    }

    public int getIntValue() {
        return Integer.parseInt(this._value);
    }

    public long getLongValue() {
        return Long.parseLong(this._value);
    }

    public String[] getValues() {
        if (this._value == null) {
            return null;
        }
        QuotedCSV quotedCSV = new QuotedCSV(false, this._value);
        return quotedCSV.getValues().toArray(new String[quotedCSV.size()]);
    }

    public boolean contains(String string) {
        if (string == null) {
            return this._value == null;
        }
        if (string.isEmpty()) {
            return false;
        }
        if (this._value == null) {
            return false;
        }
        if (string.equals(this._value)) {
            return true;
        }
        string = StringUtil.asciiToLowerCase(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        block31: for (int i = 0; i < this._value.length(); ++i) {
            char c = this._value.charAt(i);
            switch (n) {
                case 0: {
                    switch (c) {
                        case '\"': {
                            n2 = 0;
                            n = 2;
                            continue block31;
                        }
                        case ',': {
                            continue block31;
                        }
                        case ';': {
                            n3 = -1;
                            n2 = -1;
                            n = 5;
                            continue block31;
                        }
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                    }
                    n2 = Character.toLowerCase(c) == string.charAt(0) ? 1 : -1;
                    n = 1;
                    continue block31;
                }
                case 1: {
                    switch (c) {
                        case ',': {
                            if (n2 == string.length()) {
                                return true;
                            }
                            n = 0;
                            continue block31;
                        }
                        case ';': {
                            n3 = n2 >= 0 ? 0 : -1;
                            n = 5;
                            continue block31;
                        }
                    }
                    if (n2 <= 0) continue block31;
                    if (n2 < string.length()) {
                        n2 = Character.toLowerCase(c) == string.charAt(n2) ? n2 + 1 : -1;
                        continue block31;
                    }
                    if (c == ' ' || c == '\t') continue block31;
                    n2 = -1;
                    continue block31;
                }
                case 2: {
                    switch (c) {
                        case '\\': {
                            n = 3;
                            continue block31;
                        }
                        case '\"': {
                            n = 4;
                            continue block31;
                        }
                    }
                    if (n2 < 0) continue block31;
                    if (n2 < string.length()) {
                        n2 = Character.toLowerCase(c) == string.charAt(n2) ? n2 + 1 : -1;
                        continue block31;
                    }
                    n2 = -1;
                    continue block31;
                }
                case 3: {
                    if (n2 >= 0) {
                        n2 = n2 < string.length() ? (Character.toLowerCase(c) == string.charAt(n2) ? n2 + 1 : -1) : -1;
                    }
                    n = 2;
                    continue block31;
                }
                case 4: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                        case ';': {
                            n = 5;
                            continue block31;
                        }
                        case ',': {
                            if (n2 == string.length()) {
                                return true;
                            }
                            n = 0;
                            continue block31;
                        }
                    }
                    n2 = -1;
                    continue block31;
                }
                case 5: {
                    switch (c) {
                        case ',': {
                            if (n3 != ZEROQUALITY.length() && n2 == string.length()) {
                                return true;
                            }
                            n3 = 0;
                            n = 0;
                            continue block31;
                        }
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                    }
                    if (n3 < 0) continue block31;
                    if (n3 < ZEROQUALITY.length()) {
                        n3 = Character.toLowerCase(c) == ZEROQUALITY.charAt(n3) ? n3 + 1 : -1;
                        continue block31;
                    }
                    if (c == '0' || c == '.') continue block31;
                    n3 = -1;
                    continue block31;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return n3 != ZEROQUALITY.length() && n2 == string.length();
    }

    public String toString() {
        String string = this.getValue();
        return this.getName() + ": " + (string == null ? "" : string);
    }

    public boolean isSameName(HttpField httpField) {
        if (httpField == null) {
            return false;
        }
        if (httpField == this) {
            return true;
        }
        if (this._header != null && this._header == httpField.getHeader()) {
            return true;
        }
        return this._name.equalsIgnoreCase(httpField.getName());
    }

    public boolean is(String string) {
        return this._name.equalsIgnoreCase(string);
    }

    private int nameHashCode() {
        int n = this.hash;
        int n2 = this._name.length();
        if (n == 0 && n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                char c = this._name.charAt(i);
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 32);
                }
                n = 31 * n + c;
            }
            this.hash = n;
        }
        return n;
    }

    public int hashCode() {
        int n = Objects.hashCode(this._value);
        if (this._header == null) {
            return n ^ this.nameHashCode();
        }
        return n ^ this._header.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpField)) {
            return false;
        }
        HttpField httpField = (HttpField)object;
        if (this._header != httpField.getHeader()) {
            return false;
        }
        if (!this._name.equalsIgnoreCase(httpField.getName())) {
            return false;
        }
        return Objects.equals(this._value, httpField.getValue());
    }

    public static class LongValueHttpField
    extends HttpField {
        private final long _long;

        public LongValueHttpField(HttpHeader httpHeader, String string, String string2, long l) {
            super(httpHeader, string, string2);
            this._long = l;
        }

        public LongValueHttpField(HttpHeader httpHeader, String string, String string2) {
            this(httpHeader, string, string2, Long.parseLong(string2));
        }

        public LongValueHttpField(HttpHeader httpHeader, String string, long l) {
            this(httpHeader, string, Long.toString(l), l);
        }

        public LongValueHttpField(HttpHeader httpHeader, long l) {
            this(httpHeader, httpHeader.asString(), l);
        }

        @Override
        public int getIntValue() {
            return (int)this._long;
        }

        @Override
        public long getLongValue() {
            return this._long;
        }
    }

    public static class IntValueHttpField
    extends HttpField {
        private final int _int;

        public IntValueHttpField(HttpHeader httpHeader, String string, String string2, int n) {
            super(httpHeader, string, string2);
            this._int = n;
        }

        public IntValueHttpField(HttpHeader httpHeader, String string, String string2) {
            this(httpHeader, string, string2, Integer.parseInt(string2));
        }

        public IntValueHttpField(HttpHeader httpHeader, String string, int n) {
            this(httpHeader, string, Integer.toString(n), n);
        }

        public IntValueHttpField(HttpHeader httpHeader, int n) {
            this(httpHeader, httpHeader.asString(), n);
        }

        @Override
        public int getIntValue() {
            return this._int;
        }

        @Override
        public long getLongValue() {
            return this._int;
        }
    }
}

