/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.HostPort;

public class HostPortHttpField
extends HttpField {
    final HostPort _hostPort;

    public HostPortHttpField(String string) {
        this(HttpHeader.HOST, HttpHeader.HOST.asString(), string);
    }

    protected HostPortHttpField(HttpHeader httpHeader, String string, String string2) {
        super(httpHeader, string, string2);
        try {
            this._hostPort = new HostPort(string2);
        }
        catch (Exception exception) {
            throw new BadMessageException(400, "Bad HostPort", exception);
        }
    }

    public HostPortHttpField(String string, int n) {
        this(new HostPort(string, n));
    }

    public HostPortHttpField(HostPort hostPort) {
        super(HttpHeader.HOST, HttpHeader.HOST.asString(), hostPort.toString());
        this._hostPort = hostPort;
    }

    public String getHost() {
        return this._hostPort.getHost();
    }

    public int getPort() {
        return this._hostPort.getPort();
    }

    public int getPort(int n) {
        return this._hostPort.getPort(n);
    }

    public HostPort getHostPort() {
        return this._hostPort;
    }
}

