/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    private int headerCacheSize = 1024;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int n) {
        super(n);
        this.setConnectionPoolFactory(httpDestination -> new DuplexConnectionPool(httpDestination, this.getHttpClient().getMaxConnectionsPerDestination(), (Callback)httpDestination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> map) throws IOException {
        HttpDestination httpDestination = (HttpDestination)map.get("http.destination");
        Promise promise = (Promise)map.get("http.connection.promise");
        HttpConnectionOverHTTP httpConnectionOverHTTP = this.newHttpConnection(endPoint, httpDestination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", httpConnectionOverHTTP);
        }
        return this.customize(httpConnectionOverHTTP, map);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination httpDestination, Promise<Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, httpDestination, promise);
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP header field cache")
    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    public void setHeaderCacheSize(int n) {
        this.headerCacheSize = n;
    }
}

