/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class RequestNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);
    private final HttpClient client;

    public RequestNotifier(HttpClient httpClient) {
        this.client = httpClient;
    }

    public void notifyQueued(Request request) {
        List list = request.getRequestListeners(null);
        for (int i = 0; i < list.size(); ++i) {
            Request.RequestListener requestListener = (Request.RequestListener)list.get(i);
            if (!(requestListener instanceof Request.QueuedListener)) continue;
            this.notifyQueued((Request.QueuedListener)requestListener, request);
        }
        List<Request.Listener> list2 = this.client.getRequestListeners();
        for (int i = 0; i < list2.size(); ++i) {
            Request.Listener listener = list2.get(i);
            this.notifyQueued(listener, request);
        }
    }

    private void notifyQueued(Request.QueuedListener queuedListener, Request request) {
        try {
            queuedListener.onQueued(request);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + queuedListener, throwable);
        }
    }

    public void notifyBegin(Request request) {
        List list = request.getRequestListeners(null);
        for (int i = 0; i < list.size(); ++i) {
            Request.RequestListener requestListener = (Request.RequestListener)list.get(i);
            if (!(requestListener instanceof Request.BeginListener)) continue;
            this.notifyBegin((Request.BeginListener)requestListener, request);
        }
        List<Request.Listener> list2 = this.client.getRequestListeners();
        for (int i = 0; i < list2.size(); ++i) {
            Request.Listener listener = list2.get(i);
            this.notifyBegin(listener, request);
        }
    }

    private void notifyBegin(Request.BeginListener beginListener, Request request) {
        try {
            beginListener.onBegin(request);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + beginListener, throwable);
        }
    }

    public void notifyHeaders(Request request) {
        List list = request.getRequestListeners(null);
        for (int i = 0; i < list.size(); ++i) {
            Request.RequestListener requestListener = (Request.RequestListener)list.get(i);
            if (!(requestListener instanceof Request.HeadersListener)) continue;
            this.notifyHeaders((Request.HeadersListener)requestListener, request);
        }
        List<Request.Listener> list2 = this.client.getRequestListeners();
        for (int i = 0; i < list2.size(); ++i) {
            Request.Listener listener = list2.get(i);
            this.notifyHeaders(listener, request);
        }
    }

    private void notifyHeaders(Request.HeadersListener headersListener, Request request) {
        try {
            headersListener.onHeaders(request);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + headersListener, throwable);
        }
    }

    public void notifyCommit(Request request) {
        List list = request.getRequestListeners(null);
        for (int i = 0; i < list.size(); ++i) {
            Request.RequestListener requestListener = (Request.RequestListener)list.get(i);
            if (!(requestListener instanceof Request.CommitListener)) continue;
            this.notifyCommit((Request.CommitListener)requestListener, request);
        }
        List<Request.Listener> list2 = this.client.getRequestListeners();
        for (int i = 0; i < list2.size(); ++i) {
            Request.Listener listener = list2.get(i);
            this.notifyCommit(listener, request);
        }
    }

    private void notifyCommit(Request.CommitListener commitListener, Request request) {
        try {
            commitListener.onCommit(request);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + commitListener, throwable);
        }
    }

    public void notifyContent(Request request, ByteBuffer byteBuffer) {
        if (!(byteBuffer = byteBuffer.slice()).hasRemaining()) {
            return;
        }
        List list = request.getRequestListeners(null);
        for (int i = 0; i < list.size(); ++i) {
            Request.RequestListener requestListener = (Request.RequestListener)list.get(i);
            if (!(requestListener instanceof Request.ContentListener)) continue;
            byteBuffer.clear();
            this.notifyContent((Request.ContentListener)requestListener, request, byteBuffer);
        }
        List<Request.Listener> list2 = this.client.getRequestListeners();
        for (int i = 0; i < list2.size(); ++i) {
            Request.Listener listener = list2.get(i);
            byteBuffer.clear();
            this.notifyContent(listener, request, byteBuffer);
        }
    }

    private void notifyContent(Request.ContentListener contentListener, Request request, ByteBuffer byteBuffer) {
        try {
            contentListener.onContent(request, byteBuffer);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + contentListener, throwable);
        }
    }

    public void notifySuccess(Request request) {
        List list = request.getRequestListeners(null);
        for (int i = 0; i < list.size(); ++i) {
            Request.RequestListener requestListener = (Request.RequestListener)list.get(i);
            if (!(requestListener instanceof Request.SuccessListener)) continue;
            this.notifySuccess((Request.SuccessListener)requestListener, request);
        }
        List<Request.Listener> list2 = this.client.getRequestListeners();
        for (int i = 0; i < list2.size(); ++i) {
            Request.Listener listener = list2.get(i);
            this.notifySuccess(listener, request);
        }
    }

    private void notifySuccess(Request.SuccessListener successListener, Request request) {
        try {
            successListener.onSuccess(request);
        }
        catch (Throwable throwable) {
            LOG.info("Exception while notifying listener " + successListener, throwable);
        }
    }

    public void notifyFailure(Request request, Throwable throwable) {
        List list = request.getRequestListeners(null);
        for (int i = 0; i < list.size(); ++i) {
            Request.RequestListener requestListener = (Request.RequestListener)list.get(i);
            if (!(requestListener instanceof Request.FailureListener)) continue;
            this.notifyFailure((Request.FailureListener)requestListener, request, throwable);
        }
        List<Request.Listener> list2 = this.client.getRequestListeners();
        for (int i = 0; i < list2.size(); ++i) {
            Request.Listener listener = list2.get(i);
            this.notifyFailure(listener, request, throwable);
        }
    }

    private void notifyFailure(Request.FailureListener failureListener, Request request, Throwable throwable) {
        try {
            failureListener.onFailure(request, throwable);
        }
        catch (Throwable throwable2) {
            LOG.info("Exception while notifying listener " + failureListener, throwable2);
        }
    }
}

