/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Pool;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class MultiplexConnectionPool
extends AbstractConnectionPool {
    public MultiplexConnectionPool(HttpDestination httpDestination, int n, Callback callback, int n2) {
        this(httpDestination, n, false, callback, n2);
    }

    public MultiplexConnectionPool(HttpDestination httpDestination, int n, boolean bl, Callback callback, int n2) {
        this(httpDestination, Pool.StrategyType.FIRST, n, bl, callback, n2);
    }

    public MultiplexConnectionPool(HttpDestination httpDestination, Pool.StrategyType strategyType, int n, boolean bl, Callback callback, int n2) {
        super(httpDestination, new Pool<Connection>(strategyType, n, bl){

            @Override
            protected int getMaxMultiplex(Connection connection) {
                int n = connection instanceof ConnectionPool.Multiplexable ? ((ConnectionPool.Multiplexable)((Object)connection)).getMaxMultiplex() : super.getMaxMultiplex(connection);
                return n > 0 ? n : 1;
            }
        }, callback);
        this.setMaxMultiplex(n2);
    }

    @Deprecated
    public MultiplexConnectionPool(HttpDestination httpDestination, Pool<Connection> pool, Callback callback, int n) {
        super(httpDestination, pool, callback);
        this.setMaxMultiplex(n);
    }

    @Override
    @ManagedAttribute(value="The multiplexing factor of connections")
    public int getMaxMultiplex() {
        return super.getMaxMultiplex();
    }

    @Override
    public void setMaxMultiplex(int n) {
        super.setMaxMultiplex(n);
    }

    @Override
    @ManagedAttribute(value="The maximum amount of times a connection is used before it gets closed")
    public int getMaxUsageCount() {
        return super.getMaxUsageCount();
    }

    @Override
    public void setMaxUsageCount(int n) {
        super.setMaxUsageCount(n);
    }
}

