/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.List;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;

public class ContinueProtocolHandler
implements ProtocolHandler {
    public static final String NAME = "continue";
    private static final String ATTRIBUTE = ContinueProtocolHandler.class.getName() + ".100continue";
    private final ResponseNotifier notifier = new ResponseNotifier();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        boolean bl = response.getStatus() == 100;
        boolean bl2 = request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
        boolean bl3 = request.getAttributes().containsKey(ATTRIBUTE);
        return (bl || bl2) && !bl3;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new ContinueListener();
    }

    protected void onContinue(Request request) {
    }

    protected class ContinueListener
    extends BufferingResponseListener {
        protected ContinueListener() {
        }

        @Override
        public void onSuccess(Response response) {
            Request request = response.getRequest();
            HttpConversation httpConversation = ((HttpRequest)request).getConversation();
            request.attribute(ATTRIBUTE, Boolean.TRUE);
            httpConversation.updateResponseListeners(null);
            HttpExchange httpExchange = httpConversation.getExchanges().peekLast();
            if (response.getStatus() == 100) {
                httpExchange.resetResponse();
                httpExchange.proceed(null);
                ContinueProtocolHandler.this.onContinue(request);
            } else {
                List<Response.ResponseListener> list = httpExchange.getResponseListeners();
                HttpContentResponse httpContentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
                ContinueProtocolHandler.this.notifier.forwardSuccess(list, httpContentResponse);
                httpExchange.proceed(new HttpRequestException("Expectation failed", request));
            }
        }

        @Override
        public void onFailure(Response response, Throwable throwable) {
            HttpConversation httpConversation = ((HttpRequest)response.getRequest()).getConversation();
            httpConversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            httpConversation.updateResponseListeners(null);
            HttpExchange httpExchange = httpConversation.getExchanges().peekLast();
            assert (httpExchange.getResponse() == response);
            List<Response.ResponseListener> list = httpExchange.getResponseListeners();
            HttpContentResponse httpContentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
            ContinueProtocolHandler.this.notifier.forwardFailureComplete(list, httpExchange.getRequest(), httpExchange.getRequestFailure(), httpContentResponse, throwable);
        }

        @Override
        public void onComplete(Result result) {
        }
    }
}

