/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;
import org.dom4j.tree.DefaultText;

public class DefaultElement
extends AbstractElement {
    private static final transient DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();
    private QName qname;
    private Branch parentBranch;
    private Object content;
    private Object attributes;

    public DefaultElement(String string) {
        this.qname = DOCUMENT_FACTORY.createQName(string);
    }

    public DefaultElement(QName qName) {
        this.qname = qName;
    }

    public DefaultElement(QName qName, int n) {
        this.qname = qName;
        if (n > 1) {
            this.attributes = new ArrayList(n);
        }
    }

    public DefaultElement(String string, Namespace namespace) {
        this.qname = DOCUMENT_FACTORY.createQName(string, namespace);
    }

    public Element getParent() {
        Element element = null;
        if (this.parentBranch instanceof Element) {
            element = (Element)this.parentBranch;
        }
        return element;
    }

    public void setParent(Element element) {
        if (this.parentBranch instanceof Element || element != null) {
            this.parentBranch = element;
        }
    }

    public Document getDocument() {
        if (this.parentBranch instanceof Document) {
            return (Document)this.parentBranch;
        }
        if (this.parentBranch instanceof Element) {
            Element element = (Element)this.parentBranch;
            return element.getDocument();
        }
        return null;
    }

    public void setDocument(Document document) {
        if (this.parentBranch instanceof Document || document != null) {
            this.parentBranch = document;
        }
    }

    public boolean supportsParent() {
        return true;
    }

    public QName getQName() {
        return this.qname;
    }

    public void setQName(QName qName) {
        this.qname = qName;
    }

    public String getText() {
        Object object = this.content;
        if (object instanceof List) {
            return super.getText();
        }
        if (object != null) {
            return this.getContentAsText(object);
        }
        return "";
    }

    public String getStringValue() {
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            if (n > 0) {
                if (n == 1) {
                    return this.getContentAsStringValue(list.get(0));
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    Object e = list.get(i);
                    String string = this.getContentAsStringValue(e);
                    if (string.length() <= 0) continue;
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
        } else if (object != null) {
            return this.getContentAsStringValue(object);
        }
        return "";
    }

    public Object clone() {
        DefaultElement defaultElement = (DefaultElement)super.clone();
        if (defaultElement != this) {
            defaultElement.content = null;
            defaultElement.attributes = null;
            defaultElement.appendAttributes(this);
            defaultElement.appendContent(this);
        }
        return defaultElement;
    }

    public Namespace getNamespaceForPrefix(String string) {
        Object object;
        if (string == null) {
            string = "";
        }
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (string.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        Object object2 = this.content;
        if (object2 instanceof List) {
            object = (List)object2;
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                Namespace namespace;
                Object e = object.get(i);
                if (!(e instanceof Namespace) || !string.equals((namespace = (Namespace)e).getPrefix())) continue;
                return namespace;
            }
        } else if (object2 instanceof Namespace && string.equals(((Namespace)(object = (Namespace)object2)).getPrefix())) {
            return object;
        }
        if ((object2 = this.getParent()) != null && (object = object2.getNamespaceForPrefix(string)) != null) {
            return object;
        }
        if (string == null || string.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        return null;
    }

    public Namespace getNamespaceForURI(String string) {
        Object object;
        if (string == null || string.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        if (string.equals(this.getNamespaceURI())) {
            return this.getNamespace();
        }
        Object object2 = this.content;
        if (object2 instanceof List) {
            object = (List)object2;
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                Namespace namespace;
                Object e = object.get(i);
                if (!(e instanceof Namespace) || !string.equals((namespace = (Namespace)e).getURI())) continue;
                return namespace;
            }
        } else if (object2 instanceof Namespace && string.equals(((Namespace)(object = (Namespace)object2)).getURI())) {
            return object;
        }
        if ((object = this.getParent()) != null) {
            return object.getNamespaceForURI(string);
        }
        return null;
    }

    public List declaredNamespaces() {
        BackedList backedList = this.createResultList();
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                if (!(e instanceof Namespace)) continue;
                backedList.addLocal(e);
            }
        } else if (object instanceof Namespace) {
            backedList.addLocal(object);
        }
        return backedList;
    }

    public List additionalNamespaces() {
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            BackedList backedList = this.createResultList();
            for (int i = 0; i < n; ++i) {
                Namespace namespace;
                Object e = list.get(i);
                if (!(e instanceof Namespace) || (namespace = (Namespace)e).equals(this.getNamespace())) continue;
                backedList.addLocal(namespace);
            }
            return backedList;
        }
        if (object instanceof Namespace) {
            Namespace namespace = (Namespace)object;
            if (namespace.equals(this.getNamespace())) {
                return this.createEmptyList();
            }
            return this.createSingleResultList(namespace);
        }
        return this.createEmptyList();
    }

    public List additionalNamespaces(String string) {
        Namespace namespace;
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            BackedList backedList = this.createResultList();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Namespace namespace2;
                Object e = list.get(i);
                if (!(e instanceof Namespace) || string.equals((namespace2 = (Namespace)e).getURI())) continue;
                backedList.addLocal(namespace2);
            }
            return backedList;
        }
        if (object instanceof Namespace && !string.equals((namespace = (Namespace)object).getURI())) {
            return this.createSingleResultList(namespace);
        }
        return this.createEmptyList();
    }

    public List processingInstructions() {
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            BackedList backedList = this.createResultList();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                if (!(e instanceof ProcessingInstruction)) continue;
                backedList.addLocal(e);
            }
            return backedList;
        }
        if (object instanceof ProcessingInstruction) {
            return this.createSingleResultList(object);
        }
        return this.createEmptyList();
    }

    public List processingInstructions(String string) {
        ProcessingInstruction processingInstruction;
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            BackedList backedList = this.createResultList();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ProcessingInstruction processingInstruction2;
                Object e = list.get(i);
                if (!(e instanceof ProcessingInstruction) || !string.equals((processingInstruction2 = (ProcessingInstruction)e).getName())) continue;
                backedList.addLocal(processingInstruction2);
            }
            return backedList;
        }
        if (object instanceof ProcessingInstruction && string.equals((processingInstruction = (ProcessingInstruction)object).getName())) {
            return this.createSingleResultList(processingInstruction);
        }
        return this.createEmptyList();
    }

    public ProcessingInstruction processingInstruction(String string) {
        ProcessingInstruction processingInstruction;
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ProcessingInstruction processingInstruction2;
                Object e = list.get(i);
                if (!(e instanceof ProcessingInstruction) || !string.equals((processingInstruction2 = (ProcessingInstruction)e).getName())) continue;
                return processingInstruction2;
            }
        } else if (object instanceof ProcessingInstruction && string.equals((processingInstruction = (ProcessingInstruction)object).getName())) {
            return processingInstruction;
        }
        return null;
    }

    public boolean removeProcessingInstruction(String string) {
        ProcessingInstruction processingInstruction;
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ProcessingInstruction processingInstruction2;
                Object e = iterator.next();
                if (!(e instanceof ProcessingInstruction) || !string.equals((processingInstruction2 = (ProcessingInstruction)e).getName())) continue;
                iterator.remove();
                return true;
            }
        } else if (object instanceof ProcessingInstruction && string.equals((processingInstruction = (ProcessingInstruction)object).getName())) {
            this.content = null;
            return true;
        }
        return false;
    }

    public Element element(String string) {
        Element element;
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Element element2;
                Object e = list.get(i);
                if (!(e instanceof Element) || !string.equals((element2 = (Element)e).getName())) continue;
                return element2;
            }
        } else if (object instanceof Element && string.equals((element = (Element)object).getName())) {
            return element;
        }
        return null;
    }

    public Element element(QName qName) {
        Element element;
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Element element2;
                Object e = list.get(i);
                if (!(e instanceof Element) || !qName.equals((element2 = (Element)e).getQName())) continue;
                return element2;
            }
        } else if (object instanceof Element && qName.equals((element = (Element)object).getQName())) {
            return element;
        }
        return null;
    }

    public Element element(String string, Namespace namespace) {
        return this.element(this.getDocumentFactory().createQName(string, namespace));
    }

    public void setContent(List list) {
        this.contentRemoved();
        if (list instanceof ContentListFacade) {
            list = ((ContentListFacade)list).getBackingList();
        }
        if (list == null) {
            this.content = null;
        } else {
            int n = list.size();
            List list2 = this.createContentList(n);
            for (int i = 0; i < n; ++i) {
                Node node;
                Object object;
                Object e = list.get(i);
                if (e instanceof Node) {
                    object = (Node)e;
                    node = object.getParent();
                    if (node != null && node != this) {
                        object = (Node)object.clone();
                    }
                    list2.add(object);
                    this.childAdded((Node)object);
                    continue;
                }
                if (e == null) continue;
                object = e.toString();
                node = this.getDocumentFactory().createText((String)object);
                list2.add(node);
                this.childAdded(node);
            }
            this.content = list2;
        }
    }

    public void clearContent() {
        if (this.content != null) {
            this.contentRemoved();
            this.content = null;
        }
    }

    public Node node(int n) {
        if (n >= 0) {
            Object object;
            Object object2 = this.content;
            if (object2 instanceof List) {
                List list = (List)object2;
                if (n >= list.size()) {
                    return null;
                }
                object = list.get(n);
            } else {
                Object object3 = object = n == 0 ? object2 : null;
            }
            if (object != null) {
                if (object instanceof Node) {
                    return (Node)object;
                }
                return new DefaultText(object.toString());
            }
        }
        return null;
    }

    public int indexOf(Node node) {
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            return list.indexOf(node);
        }
        if (object != null && object.equals(node)) {
            return 0;
        }
        return -1;
    }

    public int nodeCount() {
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            return list.size();
        }
        return object != null ? 1 : 0;
    }

    public Iterator nodeIterator() {
        Object object = this.content;
        if (object instanceof List) {
            List list = (List)object;
            return list.iterator();
        }
        if (object != null) {
            return this.createSingleIterator(object);
        }
        return EMPTY_ITERATOR;
    }

    public List attributes() {
        return new ContentListFacade(this, this.attributeList());
    }

    public void setAttributes(List list) {
        if (list instanceof ContentListFacade) {
            list = ((ContentListFacade)list).getBackingList();
        }
        this.attributes = list;
    }

    public Iterator attributeIterator() {
        Object object = this.attributes;
        if (object instanceof List) {
            List list = (List)object;
            return list.iterator();
        }
        if (object != null) {
            return this.createSingleIterator(object);
        }
        return EMPTY_ITERATOR;
    }

    public Attribute attribute(int n) {
        Object object = this.attributes;
        if (object instanceof List) {
            List list = (List)object;
            return (Attribute)list.get(n);
        }
        if (object != null && n == 0) {
            return (Attribute)object;
        }
        return null;
    }

    public int attributeCount() {
        Object object = this.attributes;
        if (object instanceof List) {
            List list = (List)object;
            return list.size();
        }
        return object != null ? 1 : 0;
    }

    public Attribute attribute(String string) {
        Attribute attribute;
        Object object = this.attributes;
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Attribute attribute2 = (Attribute)list.get(i);
                if (!string.equals(attribute2.getName())) continue;
                return attribute2;
            }
        } else if (object != null && string.equals((attribute = (Attribute)object).getName())) {
            return attribute;
        }
        return null;
    }

    public Attribute attribute(QName qName) {
        Attribute attribute;
        Object object = this.attributes;
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Attribute attribute2 = (Attribute)list.get(i);
                if (!qName.equals(attribute2.getQName())) continue;
                return attribute2;
            }
        } else if (object != null && qName.equals((attribute = (Attribute)object).getQName())) {
            return attribute;
        }
        return null;
    }

    public Attribute attribute(String string, Namespace namespace) {
        return this.attribute(this.getDocumentFactory().createQName(string, namespace));
    }

    public void add(Attribute attribute) {
        if (attribute.getParent() != null) {
            String string = "The Attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, (Node)attribute, string);
        }
        if (attribute.getValue() == null) {
            Attribute attribute2 = this.attribute(attribute.getQName());
            if (attribute2 != null) {
                this.remove(attribute2);
            }
        } else {
            if (this.attributes == null) {
                this.attributes = attribute;
            } else {
                this.attributeList().add(attribute);
            }
            this.childAdded(attribute);
        }
    }

    public boolean remove(Attribute attribute) {
        boolean bl = false;
        Object object = this.attributes;
        if (object instanceof List) {
            Attribute attribute2;
            List list = (List)object;
            bl = list.remove(attribute);
            if (!bl && (attribute2 = this.attribute(attribute.getQName())) != null) {
                list.remove(attribute2);
                bl = true;
            }
        } else if (object != null) {
            if (attribute.equals(object)) {
                this.attributes = null;
                bl = true;
            } else {
                Attribute attribute3 = (Attribute)object;
                if (attribute.getQName().equals(attribute3.getQName())) {
                    this.attributes = null;
                    bl = true;
                }
            }
        }
        if (bl) {
            this.childRemoved(attribute);
        }
        return bl;
    }

    protected void addNewNode(Node node) {
        Object object = this.content;
        if (object == null) {
            this.content = node;
        } else if (object instanceof List) {
            List list = (List)object;
            list.add(node);
        } else {
            List list = this.createContentList();
            list.add(object);
            list.add(node);
            this.content = list;
        }
        this.childAdded(node);
    }

    protected boolean removeNode(Node node) {
        boolean bl = false;
        Object object = this.content;
        if (object != null) {
            if (object == node) {
                this.content = null;
                bl = true;
            } else if (object instanceof List) {
                List list = (List)object;
                bl = list.remove(node);
            }
        }
        if (bl) {
            this.childRemoved(node);
        }
        return bl;
    }

    protected List contentList() {
        Object object = this.content;
        if (object instanceof List) {
            return (List)object;
        }
        List list = this.createContentList();
        if (object != null) {
            list.add(object);
        }
        this.content = list;
        return list;
    }

    protected List attributeList() {
        Object object = this.attributes;
        if (object instanceof List) {
            return (List)object;
        }
        if (object != null) {
            List list = this.createAttributeList();
            list.add(object);
            this.attributes = list;
            return list;
        }
        List list = this.createAttributeList();
        this.attributes = list;
        return list;
    }

    protected List attributeList(int n) {
        Object object = this.attributes;
        if (object instanceof List) {
            return (List)object;
        }
        if (object != null) {
            List list = this.createAttributeList(n);
            list.add(object);
            this.attributes = list;
            return list;
        }
        List list = this.createAttributeList(n);
        this.attributes = list;
        return list;
    }

    protected void setAttributeList(List list) {
        this.attributes = list;
    }

    protected DocumentFactory getDocumentFactory() {
        DocumentFactory documentFactory = this.qname.getDocumentFactory();
        return documentFactory != null ? documentFactory : DOCUMENT_FACTORY;
    }
}

