/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.util.XMLEventConsumer;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;

public class STAXEventWriter {
    private XMLEventConsumer consumer;
    private XMLEventFactory factory = XMLEventFactory.newInstance();
    private XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();

    public STAXEventWriter() {
    }

    public STAXEventWriter(File file) throws XMLStreamException, IOException {
        this.consumer = this.outputFactory.createXMLEventWriter(new FileWriter(file));
    }

    public STAXEventWriter(Writer writer) throws XMLStreamException {
        this.consumer = this.outputFactory.createXMLEventWriter(writer);
    }

    public STAXEventWriter(OutputStream outputStream) throws XMLStreamException {
        this.consumer = this.outputFactory.createXMLEventWriter(outputStream);
    }

    public STAXEventWriter(XMLEventConsumer xMLEventConsumer) {
        this.consumer = xMLEventConsumer;
    }

    public XMLEventConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(XMLEventConsumer xMLEventConsumer) {
        this.consumer = xMLEventConsumer;
    }

    public XMLEventFactory getEventFactory() {
        return this.factory;
    }

    public void setEventFactory(XMLEventFactory xMLEventFactory) {
        this.factory = xMLEventFactory;
    }

    public void writeNode(Node node) throws XMLStreamException {
        switch (node.getNodeType()) {
            case 1: {
                this.writeElement((Element)node);
                break;
            }
            case 3: {
                this.writeText((Text)node);
                break;
            }
            case 2: {
                this.writeAttribute((Attribute)node);
                break;
            }
            case 13: {
                this.writeNamespace((Namespace)node);
                break;
            }
            case 8: {
                this.writeComment((Comment)node);
                break;
            }
            case 4: {
                this.writeCDATA((CDATA)node);
                break;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 5: {
                this.writeEntity((Entity)node);
                break;
            }
            case 9: {
                this.writeDocument((Document)node);
                break;
            }
            case 10: {
                this.writeDocumentType((DocumentType)node);
                break;
            }
            default: {
                throw new XMLStreamException("Unsupported DOM4J Node: " + node);
            }
        }
    }

    public void writeChildNodes(Branch branch) throws XMLStreamException {
        int n = branch.nodeCount();
        for (int i = 0; i < n; ++i) {
            Node node = branch.node(i);
            this.writeNode(node);
        }
    }

    public void writeElement(Element element) throws XMLStreamException {
        this.consumer.add(this.createStartElement(element));
        this.writeChildNodes(element);
        this.consumer.add(this.createEndElement(element));
    }

    public StartElement createStartElement(Element element) {
        javax.xml.namespace.QName qName = this.createQName(element.getQName());
        AttributeIterator attributeIterator = new AttributeIterator(element.attributeIterator());
        NamespaceIterator namespaceIterator = new NamespaceIterator(element.declaredNamespaces().iterator());
        return this.factory.createStartElement(qName, attributeIterator, namespaceIterator);
    }

    public EndElement createEndElement(Element element) {
        javax.xml.namespace.QName qName = this.createQName(element.getQName());
        NamespaceIterator namespaceIterator = new NamespaceIterator(element.declaredNamespaces().iterator());
        return this.factory.createEndElement(qName, namespaceIterator);
    }

    public void writeAttribute(Attribute attribute) throws XMLStreamException {
        this.consumer.add(this.createAttribute(attribute));
    }

    public javax.xml.stream.events.Attribute createAttribute(Attribute attribute) {
        javax.xml.namespace.QName qName = this.createQName(attribute.getQName());
        String string = attribute.getValue();
        return this.factory.createAttribute(qName, string);
    }

    public void writeNamespace(Namespace namespace) throws XMLStreamException {
        this.consumer.add(this.createNamespace(namespace));
    }

    public javax.xml.stream.events.Namespace createNamespace(Namespace namespace) {
        String string = namespace.getPrefix();
        String string2 = namespace.getURI();
        return this.factory.createNamespace(string, string2);
    }

    public void writeText(Text text) throws XMLStreamException {
        this.consumer.add(this.createCharacters(text));
    }

    public Characters createCharacters(Text text) {
        return this.factory.createCharacters(text.getText());
    }

    public void writeCDATA(CDATA cDATA) throws XMLStreamException {
        this.consumer.add(this.createCharacters(cDATA));
    }

    public Characters createCharacters(CDATA cDATA) {
        return this.factory.createCData(cDATA.getText());
    }

    public void writeComment(Comment comment) throws XMLStreamException {
        this.consumer.add(this.createComment(comment));
    }

    public javax.xml.stream.events.Comment createComment(Comment comment) {
        return this.factory.createComment(comment.getText());
    }

    public void writeProcessingInstruction(ProcessingInstruction processingInstruction) throws XMLStreamException {
        this.consumer.add(this.createProcessingInstruction(processingInstruction));
    }

    public javax.xml.stream.events.ProcessingInstruction createProcessingInstruction(ProcessingInstruction processingInstruction) {
        String string = processingInstruction.getTarget();
        String string2 = processingInstruction.getText();
        return this.factory.createProcessingInstruction(string, string2);
    }

    public void writeEntity(Entity entity) throws XMLStreamException {
        this.consumer.add(this.createEntityReference(entity));
    }

    private EntityReference createEntityReference(Entity entity) {
        return this.factory.createEntityReference(entity.getName(), null);
    }

    public void writeDocumentType(DocumentType documentType) throws XMLStreamException {
        this.consumer.add(this.createDTD(documentType));
    }

    public DTD createDTD(DocumentType documentType) {
        StringWriter stringWriter = new StringWriter();
        try {
            documentType.write(stringWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing DTD", iOException);
        }
        return this.factory.createDTD(stringWriter.toString());
    }

    public void writeDocument(Document document) throws XMLStreamException {
        this.consumer.add(this.createStartDocument(document));
        this.writeChildNodes(document);
        this.consumer.add(this.createEndDocument(document));
    }

    public StartDocument createStartDocument(Document document) {
        String string = document.getXMLEncoding();
        if (string != null) {
            return this.factory.createStartDocument(string);
        }
        return this.factory.createStartDocument();
    }

    public EndDocument createEndDocument(Document document) {
        return this.factory.createEndDocument();
    }

    public javax.xml.namespace.QName createQName(QName qName) {
        return new javax.xml.namespace.QName(qName.getNamespaceURI(), qName.getName(), qName.getNamespacePrefix());
    }

    private class NamespaceIterator
    implements Iterator {
        private Iterator iter;

        public NamespaceIterator(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            Namespace namespace = (Namespace)this.iter.next();
            String string = namespace.getPrefix();
            String string2 = namespace.getURI();
            return STAXEventWriter.this.factory.createNamespace(string, string2);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class AttributeIterator
    implements Iterator {
        private Iterator iter;

        public AttributeIterator(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            Attribute attribute = (Attribute)this.iter.next();
            javax.xml.namespace.QName qName = STAXEventWriter.this.createQName(attribute.getQName());
            String string = attribute.getValue();
            return STAXEventWriter.this.factory.createAttribute(qName, string);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

