/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.IOException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.io.DispatchHandler;
import org.dom4j.io.ElementStack;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.io.SAXModifyElementHandler;
import org.dom4j.io.SAXModifyException;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class SAXModifyContentHandler
extends SAXContentHandler {
    private XMLWriter xmlWriter;

    public SAXModifyContentHandler() {
    }

    public SAXModifyContentHandler(DocumentFactory documentFactory) {
        super(documentFactory);
    }

    public SAXModifyContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler) {
        super(documentFactory, elementHandler);
    }

    public SAXModifyContentHandler(DocumentFactory documentFactory, ElementHandler elementHandler, ElementStack elementStack) {
        super(documentFactory, elementHandler, elementStack);
    }

    public void setXMLWriter(XMLWriter xMLWriter) {
        this.xmlWriter = xMLWriter;
    }

    public void startCDATA() throws SAXException {
        super.startCDATA();
        if (!this.activeHandlers() && this.xmlWriter != null) {
            this.xmlWriter.startCDATA();
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        super.startDTD(string, string2, string3);
        if (this.xmlWriter != null) {
            this.xmlWriter.startDTD(string, string2, string3);
        }
    }

    public void endDTD() throws SAXException {
        super.endDTD();
        if (this.xmlWriter != null) {
            this.xmlWriter.endDTD();
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        super.comment(cArray, n, n2);
        if (!this.activeHandlers() && this.xmlWriter != null) {
            this.xmlWriter.comment(cArray, n, n2);
        }
    }

    public void startEntity(String string) throws SAXException {
        super.startEntity(string);
        if (this.xmlWriter != null) {
            this.xmlWriter.startEntity(string);
        }
    }

    public void endCDATA() throws SAXException {
        super.endCDATA();
        if (!this.activeHandlers() && this.xmlWriter != null) {
            this.xmlWriter.endCDATA();
        }
    }

    public void endEntity(String string) throws SAXException {
        super.endEntity(string);
        if (this.xmlWriter != null) {
            this.xmlWriter.endEntity(string);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        super.unparsedEntityDecl(string, string2, string3, string4);
        if (!this.activeHandlers() && this.xmlWriter != null) {
            this.xmlWriter.unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        super.notationDecl(string, string2, string3);
        if (this.xmlWriter != null) {
            this.xmlWriter.notationDecl(string, string2, string3);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (!this.activeHandlers() && this.xmlWriter != null) {
            this.xmlWriter.startElement(string, string2, string3, attributes);
        }
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        if (this.xmlWriter != null) {
            this.xmlWriter.startDocument();
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        super.ignorableWhitespace(cArray, n, n2);
        if (!this.activeHandlers() && this.xmlWriter != null) {
            this.xmlWriter.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        super.processingInstruction(string, string2);
        if (!this.activeHandlers() && this.xmlWriter != null) {
            this.xmlWriter.processingInstruction(string, string2);
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        if (this.xmlWriter != null) {
            this.xmlWriter.setDocumentLocator(locator);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        super.skippedEntity(string);
        if (!this.activeHandlers() && this.xmlWriter != null) {
            this.xmlWriter.skippedEntity(string);
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.xmlWriter != null) {
            this.xmlWriter.endDocument();
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
        if (this.xmlWriter != null) {
            this.xmlWriter.startPrefixMapping(string, string2);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        ElementHandler elementHandler = this.getElementStack().getDispatchHandler().getHandler(this.getElementStack().getPath());
        super.endElement(string, string2, string3);
        if (!this.activeHandlers() && this.xmlWriter != null) {
            if (elementHandler == null) {
                this.xmlWriter.endElement(string, string2, string3);
            } else if (elementHandler instanceof SAXModifyElementHandler) {
                SAXModifyElementHandler sAXModifyElementHandler = (SAXModifyElementHandler)elementHandler;
                Element element = sAXModifyElementHandler.getModifiedElement();
                try {
                    this.xmlWriter.write(element);
                }
                catch (IOException iOException) {
                    throw new SAXModifyException(iOException);
                }
            }
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
        if (this.xmlWriter != null) {
            this.xmlWriter.endPrefixMapping(string);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        if (!this.activeHandlers() && this.xmlWriter != null) {
            this.xmlWriter.characters(cArray, n, n2);
        }
    }

    protected XMLWriter getXMLWriter() {
        return this.xmlWriter;
    }

    private boolean activeHandlers() {
        DispatchHandler dispatchHandler = this.getElementStack().getDispatchHandler();
        return dispatchHandler.getActiveHandlerCount() > 0;
    }
}

