/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SAXEventRecorder
extends DefaultHandler
implements LexicalHandler,
DeclHandler,
DTDHandler,
Externalizable {
    public static final long serialVersionUID = 1L;
    private static final byte STRING = 0;
    private static final byte OBJECT = 1;
    private static final byte NULL = 2;
    private List events = new ArrayList();
    private Map prefixMappings = new HashMap();
    private static final String XMLNS = "xmlns";
    private static final String EMPTY_STRING = "";

    public void replay(ContentHandler contentHandler) throws SAXException {
        Iterator iterator = this.events.iterator();
        block21: while (iterator.hasNext()) {
            SAXEvent sAXEvent = (SAXEvent)iterator.next();
            switch (sAXEvent.event) {
                case 1: {
                    contentHandler.processingInstruction((String)sAXEvent.getParm(0), (String)sAXEvent.getParm(1));
                    continue block21;
                }
                case 2: {
                    contentHandler.startPrefixMapping((String)sAXEvent.getParm(0), (String)sAXEvent.getParm(1));
                    continue block21;
                }
                case 3: {
                    contentHandler.endPrefixMapping((String)sAXEvent.getParm(0));
                    continue block21;
                }
                case 4: {
                    contentHandler.startDocument();
                    continue block21;
                }
                case 5: {
                    contentHandler.endDocument();
                    continue block21;
                }
                case 6: {
                    Object object;
                    AttributesImpl attributesImpl = new AttributesImpl();
                    List list = (List)sAXEvent.getParm(3);
                    if (list != null) {
                        object = list.iterator();
                        while (object.hasNext()) {
                            String[] stringArray = (String[])object.next();
                            attributesImpl.addAttribute(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
                        }
                    }
                    contentHandler.startElement((String)sAXEvent.getParm(0), (String)sAXEvent.getParm(1), (String)sAXEvent.getParm(2), attributesImpl);
                    continue block21;
                }
                case 7: {
                    contentHandler.endElement((String)sAXEvent.getParm(0), (String)sAXEvent.getParm(1), (String)sAXEvent.getParm(2));
                    continue block21;
                }
                case 8: {
                    Object object = (char[])sAXEvent.getParm(0);
                    int n = (Integer)sAXEvent.getParm(1);
                    int n2 = (Integer)sAXEvent.getParm(2);
                    contentHandler.characters((char[])object, n, n2);
                    continue block21;
                }
                case 9: {
                    ((LexicalHandler)((Object)contentHandler)).startDTD((String)sAXEvent.getParm(0), (String)sAXEvent.getParm(1), (String)sAXEvent.getParm(2));
                    continue block21;
                }
                case 10: {
                    ((LexicalHandler)((Object)contentHandler)).endDTD();
                    continue block21;
                }
                case 11: {
                    ((LexicalHandler)((Object)contentHandler)).startEntity((String)sAXEvent.getParm(0));
                    continue block21;
                }
                case 12: {
                    ((LexicalHandler)((Object)contentHandler)).endEntity((String)sAXEvent.getParm(0));
                    continue block21;
                }
                case 13: {
                    ((LexicalHandler)((Object)contentHandler)).startCDATA();
                    continue block21;
                }
                case 14: {
                    ((LexicalHandler)((Object)contentHandler)).endCDATA();
                    continue block21;
                }
                case 15: {
                    char[] cArray = (char[])sAXEvent.getParm(0);
                    int n = (Integer)sAXEvent.getParm(1);
                    int n3 = (Integer)sAXEvent.getParm(2);
                    ((LexicalHandler)((Object)contentHandler)).comment(cArray, n, n3);
                    continue block21;
                }
                case 16: {
                    ((DeclHandler)((Object)contentHandler)).elementDecl((String)sAXEvent.getParm(0), (String)sAXEvent.getParm(1));
                    continue block21;
                }
                case 17: {
                    ((DeclHandler)((Object)contentHandler)).attributeDecl((String)sAXEvent.getParm(0), (String)sAXEvent.getParm(1), (String)sAXEvent.getParm(2), (String)sAXEvent.getParm(3), (String)sAXEvent.getParm(4));
                    continue block21;
                }
                case 18: {
                    ((DeclHandler)((Object)contentHandler)).internalEntityDecl((String)sAXEvent.getParm(0), (String)sAXEvent.getParm(1));
                    continue block21;
                }
                case 19: {
                    ((DeclHandler)((Object)contentHandler)).externalEntityDecl((String)sAXEvent.getParm(0), (String)sAXEvent.getParm(1), (String)sAXEvent.getParm(2));
                    continue block21;
                }
            }
            throw new SAXException("Unrecognized event: " + sAXEvent.event);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(1);
        sAXEvent.addParm(string);
        sAXEvent.addParm(string2);
        this.events.add(sAXEvent);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(2);
        sAXEvent.addParm(string);
        sAXEvent.addParm(string2);
        this.events.add(sAXEvent);
    }

    public void endPrefixMapping(String string) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(3);
        sAXEvent.addParm(string);
        this.events.add(sAXEvent);
    }

    public void startDocument() throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(4);
        this.events.add(sAXEvent);
    }

    public void endDocument() throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(5);
        this.events.add(sAXEvent);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(6);
        sAXEvent.addParm(string);
        sAXEvent.addParm(string2);
        sAXEvent.addParm(string3);
        QName qName = null;
        qName = string != null ? new QName(string2, Namespace.get(string)) : new QName(string2);
        if (attributes != null && attributes.getLength() > 0) {
            ArrayList<String[]> arrayList = new ArrayList<String[]>(attributes.getLength());
            String[] stringArray = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getLocalName(i);
                if (string4.startsWith(XMLNS)) {
                    String string5 = null;
                    string5 = string4.length() > 5 ? string4.substring(6) : EMPTY_STRING;
                    SAXEvent sAXEvent2 = new SAXEvent(2);
                    sAXEvent2.addParm(string5);
                    sAXEvent2.addParm(attributes.getValue(i));
                    this.events.add(sAXEvent2);
                    ArrayList<String> arrayList2 = (ArrayList<String>)this.prefixMappings.get(qName);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>();
                        this.prefixMappings.put(qName, arrayList2);
                    }
                    arrayList2.add(string5);
                    continue;
                }
                stringArray = new String[]{attributes.getURI(i), string4, attributes.getQName(i), attributes.getType(i), attributes.getValue(i)};
                arrayList.add(stringArray);
            }
            sAXEvent.addParm(arrayList);
        }
        this.events.add(sAXEvent);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(7);
        sAXEvent.addParm(string);
        sAXEvent.addParm(string2);
        sAXEvent.addParm(string3);
        this.events.add(sAXEvent);
        QName qName = null;
        qName = string != null ? new QName(string2, Namespace.get(string)) : new QName(string2);
        List list = (List)this.prefixMappings.get(qName);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SAXEvent sAXEvent2 = new SAXEvent(3);
                sAXEvent2.addParm(iterator.next());
                this.events.add(sAXEvent2);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(8);
        sAXEvent.addParm(cArray);
        sAXEvent.addParm(new Integer(n));
        sAXEvent.addParm(new Integer(n2));
        this.events.add(sAXEvent);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(9);
        sAXEvent.addParm(string);
        sAXEvent.addParm(string2);
        sAXEvent.addParm(string3);
        this.events.add(sAXEvent);
    }

    public void endDTD() throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(10);
        this.events.add(sAXEvent);
    }

    public void startEntity(String string) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(11);
        sAXEvent.addParm(string);
        this.events.add(sAXEvent);
    }

    public void endEntity(String string) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(12);
        sAXEvent.addParm(string);
        this.events.add(sAXEvent);
    }

    public void startCDATA() throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(13);
        this.events.add(sAXEvent);
    }

    public void endCDATA() throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(14);
        this.events.add(sAXEvent);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(15);
        sAXEvent.addParm(cArray);
        sAXEvent.addParm(new Integer(n));
        sAXEvent.addParm(new Integer(n2));
        this.events.add(sAXEvent);
    }

    public void elementDecl(String string, String string2) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(16);
        sAXEvent.addParm(string);
        sAXEvent.addParm(string2);
        this.events.add(sAXEvent);
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(17);
        sAXEvent.addParm(string);
        sAXEvent.addParm(string2);
        sAXEvent.addParm(string3);
        sAXEvent.addParm(string4);
        sAXEvent.addParm(string5);
        this.events.add(sAXEvent);
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(18);
        sAXEvent.addParm(string);
        sAXEvent.addParm(string2);
        this.events.add(sAXEvent);
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        SAXEvent sAXEvent = new SAXEvent(19);
        sAXEvent.addParm(string);
        sAXEvent.addParm(string2);
        sAXEvent.addParm(string3);
        this.events.add(sAXEvent);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.events == null) {
            objectOutput.writeByte(2);
        } else {
            objectOutput.writeByte(1);
            objectOutput.writeObject(this.events);
        }
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        if (objectInput.readByte() != 2) {
            this.events = (List)objectInput.readObject();
        }
    }

    static class SAXEvent
    implements Externalizable {
        public static final long serialVersionUID = 1L;
        static final byte PROCESSING_INSTRUCTION = 1;
        static final byte START_PREFIX_MAPPING = 2;
        static final byte END_PREFIX_MAPPING = 3;
        static final byte START_DOCUMENT = 4;
        static final byte END_DOCUMENT = 5;
        static final byte START_ELEMENT = 6;
        static final byte END_ELEMENT = 7;
        static final byte CHARACTERS = 8;
        static final byte START_DTD = 9;
        static final byte END_DTD = 10;
        static final byte START_ENTITY = 11;
        static final byte END_ENTITY = 12;
        static final byte START_CDATA = 13;
        static final byte END_CDATA = 14;
        static final byte COMMENT = 15;
        static final byte ELEMENT_DECL = 16;
        static final byte ATTRIBUTE_DECL = 17;
        static final byte INTERNAL_ENTITY_DECL = 18;
        static final byte EXTERNAL_ENTITY_DECL = 19;
        protected byte event;
        protected List parms;

        public SAXEvent() {
        }

        SAXEvent(byte by) {
            this.event = by;
        }

        void addParm(Object object) {
            if (this.parms == null) {
                this.parms = new ArrayList(3);
            }
            this.parms.add(object);
        }

        Object getParm(int n) {
            if (this.parms != null && n < this.parms.size()) {
                return this.parms.get(n);
            }
            return null;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeByte(this.event);
            if (this.parms == null) {
                objectOutput.writeByte(2);
            } else {
                objectOutput.writeByte(1);
                objectOutput.writeObject(this.parms);
            }
        }

        public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
            this.event = objectInput.readByte();
            if (objectInput.readByte() != 2) {
                this.parms = (List)objectInput.readObject();
            }
        }
    }
}

