/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.siv;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.cryptomator.siv.org.bouncycastle.crypto.BlockCipher;
import org.cryptomator.siv.org.bouncycastle.crypto.CipherParameters;
import org.cryptomator.siv.org.bouncycastle.crypto.DataLengthException;
import org.cryptomator.siv.org.bouncycastle.crypto.params.KeyParameter;

final class JceAesBlockCipher
implements BlockCipher {
    private static final String ALG_NAME = "AES";
    private static final String KEY_DESIGNATION = "AES";
    private static final String SINGLE_BLOCK_PLAIN_AES_JCE_CIPHER_NAME = "AES/ECB/NoPadding";
    private final Cipher cipher;
    private Key key;
    private int opmode;

    public JceAesBlockCipher() {
        try {
            this.cipher = Cipher.getInstance(SINGLE_BLOCK_PLAIN_AES_JCE_CIPHER_NAME);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new IllegalStateException("Every implementation of the Java platform is required to support AES/ECB/NoPadding.");
        }
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid or missing parameter of type KeyParameter.");
        }
        this.init(bl, (KeyParameter)cipherParameters);
    }

    private void init(boolean bl, KeyParameter keyParameter) throws IllegalArgumentException {
        this.key = new SecretKeySpec(keyParameter.getKey(), "AES");
        this.opmode = bl ? 1 : 2;
        try {
            this.cipher.init(this.opmode, this.key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("Invalid key.", invalidKeyException);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "AES";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (byArray.length - n < this.getBlockSize()) {
            throw new DataLengthException("Insufficient data in 'in'.");
        }
        try {
            return this.cipher.update(byArray, n, this.getBlockSize(), byArray2, n2);
        }
        catch (ShortBufferException shortBufferException) {
            throw new DataLengthException("Insufficient space in 'out'.");
        }
    }

    @Override
    public void reset() {
        if (this.key == null) {
            return;
        }
        try {
            this.cipher.init(this.opmode, this.key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException("cipher.init(...) already invoked successfully earlier with same parameters.");
        }
    }
}

