/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration.v6;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.text.Normalizer;
import javax.inject.Inject;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptolib.api.CryptoLibVersion;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.api.UnsupportedVaultFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version6Migrator
implements Migrator {
    private static final Logger LOG = LoggerFactory.getLogger(Version6Migrator.class);
    private final CryptorProvider cryptorProvider;

    @Inject
    public Version6Migrator(@CryptoLibVersion(value=CryptoLibVersion.Version.ONE) CryptorProvider cryptorProvider) {
        this.cryptorProvider = cryptorProvider;
    }

    @Override
    public void migrate(Path path, String string, CharSequence charSequence) throws InvalidPassphraseException, UnsupportedVaultFormatException, IOException {
        LOG.info("Upgrading {} from version 5 to version 6.", (Object)path);
        Path path2 = path.resolve(string);
        byte[] byArray = Files.readAllBytes(path2);
        KeyFile keyFile = KeyFile.parse(byArray);
        try (Cryptor cryptor = this.cryptorProvider.createFromKeyFile(keyFile, charSequence, 5);){
            Path path3 = path.resolve(string + ".bkup");
            Files.copy(path2, path3, StandardCopyOption.REPLACE_EXISTING);
            LOG.info("Backed up masterkey from {} to {}.", (Object)path2.getFileName(), (Object)path3.getFileName());
            byte[] byArray2 = cryptor.writeKeysToMasterkeyFile(Normalizer.normalize(charSequence, Normalizer.Form.NFC), 6).serialize();
            Files.write(path2, byArray2, StandardOpenOption.TRUNCATE_EXISTING);
            LOG.info("Updated masterkey.");
        }
        LOG.info("Upgraded {} from version 5 to version 6.", (Object)path);
    }
}

