/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.cryptomator.cryptofs.migration.DaggerMigrationComponent;
import org.cryptomator.cryptofs.migration.Migration;
import org.cryptomator.cryptofs.migration.MigrationComponent;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptofs.migration.api.NoApplicableMigratorException;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.api.UnsupportedVaultFormatException;
import org.cryptomator.cryptolib.common.SecureRandomModule;

public class Migrators {
    private static final MigrationComponent COMPONENT = DaggerMigrationComponent.builder().secureRandomModule(new SecureRandomModule(Migrators.strongSecureRandom())).build();
    private final Map<Migration, Migrator> migrators;

    @Inject
    Migrators(Map<Migration, Migrator> map) {
        this.migrators = map;
    }

    private static SecureRandom strongSecureRandom() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("A strong algorithm must exist in every Java platform.", noSuchAlgorithmException);
        }
    }

    public static Migrators get() {
        return COMPONENT.migrators();
    }

    public boolean needsMigration(Path path, String string) throws IOException {
        Path path2 = path.resolve(string);
        byte[] byArray = Files.readAllBytes(path2);
        KeyFile keyFile = KeyFile.parse(byArray);
        return keyFile.getVersion() < 6;
    }

    public void migrate(Path path, String string, CharSequence charSequence) throws NoApplicableMigratorException, InvalidPassphraseException, IOException {
        Path path2 = path.resolve(string);
        byte[] byArray = Files.readAllBytes(path2);
        KeyFile keyFile = KeyFile.parse(byArray);
        try {
            Migrator migrator = this.findApplicableMigrator(keyFile.getVersion()).orElseThrow(NoApplicableMigratorException::new);
            migrator.migrate(path, string, charSequence);
        }
        catch (UnsupportedVaultFormatException unsupportedVaultFormatException) {
            throw new IllegalStateException("Vault version checked beforehand but not supported by migrator.");
        }
    }

    private Optional<Migrator> findApplicableMigrator(int n) {
        return this.migrators.entrySet().stream().filter(entry -> ((Migration)((Object)((Object)entry.getKey()))).isApplicable(n)).map(Map.Entry::getValue).findAny();
    }
}

