/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.Optional;
import javax.inject.Inject;
import org.cryptomator.cryptofs.ArrayUtils;
import org.cryptomator.cryptofs.CopyOperation;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.PerProvider;

@PerProvider
class MoveOperation {
    private final CopyOperation copyOperation;

    @Inject
    public MoveOperation(CopyOperation copyOperation) {
        this.copyOperation = copyOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(CryptoPath cryptoPath, CryptoPath cryptoPath2, CopyOption ... copyOptionArray) throws IOException {
        if (cryptoPath.equals(cryptoPath2)) {
            return;
        }
        if (this.pathsBelongToSameFileSystem(cryptoPath, cryptoPath2)) {
            cryptoPath.getFileSystem().move(cryptoPath, cryptoPath2, copyOptionArray);
        } else {
            if (ArrayUtils.contains(copyOptionArray, StandardCopyOption.ATOMIC_MOVE)) {
                throw new AtomicMoveNotSupportedException(cryptoPath.toUri().toString(), cryptoPath2.toUri().toString(), "Move of encrypted file to different FileSystem");
            }
            if (this.isNonEmptyDirectory(cryptoPath)) {
                throw new IOException("Can not move non empty directory to different FileSystem");
            }
            boolean bl = false;
            boolean bl2 = true;
            try {
                this.copyOperation.copy(cryptoPath, cryptoPath2, this.addCopyAttributesTo(copyOptionArray));
                bl = true;
                bl2 = false;
            }
            catch (FileAlreadyExistsException | NoSuchFileException fileSystemException) {
                bl2 = false;
            }
            finally {
                if (bl2) {
                    try {
                        this.provider(cryptoPath2).deleteIfExists(cryptoPath2);
                    }
                    catch (IOException iOException) {}
                }
            }
            if (bl) {
                this.provider(cryptoPath).deleteIfExists(cryptoPath);
            }
        }
    }

    private boolean pathsBelongToSameFileSystem(CryptoPath cryptoPath, CryptoPath cryptoPath2) {
        return cryptoPath.getFileSystem() == cryptoPath2.getFileSystem();
    }

    private FileSystemProvider provider(CryptoPath cryptoPath) {
        return cryptoPath.getFileSystem().provider();
    }

    private CopyOption[] addCopyAttributesTo(CopyOption[] copyOptionArray) {
        CopyOption[] copyOptionArray2 = new CopyOption[copyOptionArray.length + 1];
        for (int i = 0; i < copyOptionArray.length; ++i) {
            copyOptionArray2[i] = copyOptionArray[i];
        }
        copyOptionArray2[copyOptionArray.length] = StandardCopyOption.COPY_ATTRIBUTES;
        return copyOptionArray2;
    }

    private boolean isNonEmptyDirectory(CryptoPath cryptoPath) throws IOException {
        Optional<BasicFileAttributes> optional = this.attributes(cryptoPath);
        if (!optional.map(BasicFileAttributes::isDirectory).orElse(false).booleanValue()) {
            return false;
        }
        try (DirectoryStream<Path> directoryStream = this.provider(cryptoPath).newDirectoryStream(cryptoPath, path -> true);){
            boolean bl = directoryStream.iterator().hasNext();
            return bl;
        }
    }

    private Optional<BasicFileAttributes> attributes(CryptoPath cryptoPath) {
        try {
            return Optional.of(this.provider(cryptoPath).readAttributes((Path)cryptoPath, BasicFileAttributes.class, new LinkOption[0]));
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
    }
}

