/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.cryptomator.cryptofs.PathToVault;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptolib.common.MessageDigestSupplier;

@PerFileSystem
class LongFileNameProvider {
    private static final BaseEncoding BASE32 = BaseEncoding.base32();
    private static final int MAX_CACHE_SIZE = 5000;
    public static final String LONG_NAME_FILE_EXT = ".lng";
    private final Path metadataRoot;
    private final LoadingCache<String, String> ids;

    @Inject
    public LongFileNameProvider(@PathToVault Path path) {
        this.metadataRoot = path.resolve("m");
        this.ids = CacheBuilder.newBuilder().maximumSize(5000L).build(new Loader());
    }

    public static boolean isDeflated(String string) {
        return string.endsWith(LONG_NAME_FILE_EXT);
    }

    public String inflate(String string) throws IOException {
        try {
            return this.ids.get(string);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof IOException || executionException.getCause() instanceof UncheckedIOException) {
                throw new IOException(executionException);
            }
            throw new UncheckedExecutionException("Unexpected exception", executionException);
        }
    }

    public String deflate(String string) throws IOException {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = MessageDigestSupplier.SHA1.get().digest(byArray);
        String string2 = BASE32.encode(byArray2) + LONG_NAME_FILE_EXT;
        if (this.ids.getIfPresent(string2) == null) {
            this.ids.put(string2, string);
            Path path = this.resolveMetadataFile(string2);
            Path path2 = path.getParent();
            assert (path2 != null) : "resolveMetadataFile returned path to a file";
            Files.createDirectories(path2, new FileAttribute[0]);
            Files.write(path, byArray, new OpenOption[0]);
        }
        return string2;
    }

    private Path resolveMetadataFile(String string) {
        return this.metadataRoot.resolve(string.substring(0, 2)).resolve(string.substring(2, 4)).resolve(string);
    }

    private class Loader
    extends CacheLoader<String, String> {
        private Loader() {
        }

        @Override
        public String load(String string) throws IOException {
            Path path = LongFileNameProvider.this.resolveMetadataFile(string);
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
    }
}

