/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.cryptomator.cryptofs.ConflictResolver;
import org.cryptomator.cryptofs.CryptoDirectoryStream;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.FinallyUtil;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptolib.api.Cryptor;

@PerFileSystem
class DirectoryStreamFactory {
    private final Cryptor cryptor;
    private final LongFileNameProvider longFileNameProvider;
    private final ConflictResolver conflictResolver;
    private final CryptoPathMapper cryptoPathMapper;
    private final FinallyUtil finallyUtil;
    private final ConcurrentMap<CryptoDirectoryStream, CryptoDirectoryStream> streams = new ConcurrentHashMap<CryptoDirectoryStream, CryptoDirectoryStream>();
    private volatile boolean closed = false;

    @Inject
    public DirectoryStreamFactory(Cryptor cryptor, LongFileNameProvider longFileNameProvider, ConflictResolver conflictResolver, CryptoPathMapper cryptoPathMapper, FinallyUtil finallyUtil) {
        this.cryptor = cryptor;
        this.longFileNameProvider = longFileNameProvider;
        this.conflictResolver = conflictResolver;
        this.cryptoPathMapper = cryptoPathMapper;
        this.finallyUtil = finallyUtil;
    }

    public DirectoryStream<Path> newDirectoryStream(CryptoPath cryptoPath, DirectoryStream.Filter<? super Path> filter) throws IOException {
        CryptoPathMapper.Directory directory = this.cryptoPathMapper.getCiphertextDir(cryptoPath);
        CryptoDirectoryStream cryptoDirectoryStream2 = new CryptoDirectoryStream(directory, cryptoPath, this.cryptor.fileNameCryptor(), this.cryptoPathMapper, this.longFileNameProvider, this.conflictResolver, filter, cryptoDirectoryStream -> {
            CryptoDirectoryStream cfr_ignored_0 = (CryptoDirectoryStream)this.streams.remove(cryptoDirectoryStream);
        }, this.finallyUtil);
        this.streams.put(cryptoDirectoryStream2, cryptoDirectoryStream2);
        if (this.closed) {
            cryptoDirectoryStream2.close();
            throw new ClosedFileSystemException();
        }
        return cryptoDirectoryStream2;
    }

    public void close() throws IOException {
        this.closed = true;
        this.finallyUtil.guaranteeInvocationOf(this.streams.keySet().stream().map(cryptoDirectoryStream -> () -> cryptoDirectoryStream.close()).iterator());
    }
}

