/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import javax.inject.Inject;
import org.cryptomator.cryptofs.PerFileSystem;

@PerFileSystem
class DirectoryIdLoader
extends CacheLoader<Path, String> {
    private static final int MAX_DIR_ID_LENGTH = 1000;

    @Inject
    public DirectoryIdLoader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String load(Path path) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
            long l = fileChannel.size();
            if (l == 0L) {
                throw new IOException("Invalid, empty directory file: " + path);
            }
            if (l > 1000L) {
                throw new IOException("Unexpectedly large directory file: " + path);
            }
            assert (l <= 1000L);
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)l);
            int n = fileChannel.read(byteBuffer);
            assert ((long)n == l);
            byteBuffer.flip();
            String string = StandardCharsets.UTF_8.decode(byteBuffer).toString();
            return string;
        }
        catch (NoSuchFileException noSuchFileException) {
            return UUID.randomUUID().toString();
        }
    }
}

