/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.MembersInjectors;
import dagger.internal.Preconditions;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Provider;
import org.cryptomator.cryptofs.ChunkCache;
import org.cryptomator.cryptofs.ChunkCache_Factory;
import org.cryptomator.cryptofs.ChunkLoader;
import org.cryptomator.cryptofs.ChunkLoader_Factory;
import org.cryptomator.cryptofs.ChunkSaver;
import org.cryptomator.cryptofs.ChunkSaver_Factory;
import org.cryptomator.cryptofs.ConflictResolver;
import org.cryptomator.cryptofs.ConflictResolver_Factory;
import org.cryptomator.cryptofs.CopyOperation;
import org.cryptomator.cryptofs.CopyOperation_Factory;
import org.cryptomator.cryptofs.CryptoFileAttributeByNameProvider;
import org.cryptomator.cryptofs.CryptoFileAttributeByNameProvider_Factory;
import org.cryptomator.cryptofs.CryptoFileAttributeProvider;
import org.cryptomator.cryptofs.CryptoFileAttributeProvider_Factory;
import org.cryptomator.cryptofs.CryptoFileAttributeViewProvider;
import org.cryptomator.cryptofs.CryptoFileAttributeViewProvider_Factory;
import org.cryptomator.cryptofs.CryptoFileChannelFactory;
import org.cryptomator.cryptofs.CryptoFileChannelFactory_Factory;
import org.cryptomator.cryptofs.CryptoFileStore;
import org.cryptomator.cryptofs.CryptoFileStore_Factory;
import org.cryptomator.cryptofs.CryptoFileSystemComponent;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemImpl_Factory;
import org.cryptomator.cryptofs.CryptoFileSystemModule;
import org.cryptomator.cryptofs.CryptoFileSystemModule_ProvideCryptoFileSystemPropertiesFactory;
import org.cryptomator.cryptofs.CryptoFileSystemModule_ProvideCryptorFactory;
import org.cryptomator.cryptofs.CryptoFileSystemModule_ProvidePathToVaultFactory;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.CryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.CryptoFileSystemProviderModule;
import org.cryptomator.cryptofs.CryptoFileSystemProviderModule_ProvideCryptoFileSystemProviderFactory;
import org.cryptomator.cryptofs.CryptoFileSystemProviderModule_ProvideCryptorProviderFactory;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.CryptoFileSystemStats_Factory;
import org.cryptomator.cryptofs.CryptoFileSystems;
import org.cryptomator.cryptofs.CryptoFileSystems_Factory;
import org.cryptomator.cryptofs.CryptoPathFactory;
import org.cryptomator.cryptofs.CryptoPathFactory_Factory;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.CryptoPathMapper_Factory;
import org.cryptomator.cryptofs.DirectoryIdLoader;
import org.cryptomator.cryptofs.DirectoryIdLoader_Factory;
import org.cryptomator.cryptofs.DirectoryIdProvider;
import org.cryptomator.cryptofs.DirectoryIdProvider_Factory;
import org.cryptomator.cryptofs.DirectoryStreamFactory;
import org.cryptomator.cryptofs.DirectoryStreamFactory_Factory;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.ExceptionsDuringWrite;
import org.cryptomator.cryptofs.ExceptionsDuringWrite_Factory;
import org.cryptomator.cryptofs.FinallyUtil;
import org.cryptomator.cryptofs.FinallyUtil_Factory;
import org.cryptomator.cryptofs.GlobToRegexConverter;
import org.cryptomator.cryptofs.GlobToRegexConverter_Factory;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptofs.LongFileNameProvider_Factory;
import org.cryptomator.cryptofs.MoveOperation;
import org.cryptomator.cryptofs.MoveOperation_Factory;
import org.cryptomator.cryptofs.OpenCounter;
import org.cryptomator.cryptofs.OpenCounter_Factory;
import org.cryptomator.cryptofs.OpenCryptoFile;
import org.cryptomator.cryptofs.OpenCryptoFileComponent;
import org.cryptomator.cryptofs.OpenCryptoFileFactoryModule;
import org.cryptomator.cryptofs.OpenCryptoFileFactoryModule_ProvideFileChannelFactory;
import org.cryptomator.cryptofs.OpenCryptoFileFactoryModule_ProvideFileHaderFactory;
import org.cryptomator.cryptofs.OpenCryptoFileFactoryModule_ProvideFileSizeFactory;
import org.cryptomator.cryptofs.OpenCryptoFileModule;
import org.cryptomator.cryptofs.OpenCryptoFileModule_ProvideOnCloseFactory;
import org.cryptomator.cryptofs.OpenCryptoFileModule_ProvideOptionsFactory;
import org.cryptomator.cryptofs.OpenCryptoFileModule_ProvidePathFactory;
import org.cryptomator.cryptofs.OpenCryptoFile_Factory;
import org.cryptomator.cryptofs.OpenCryptoFiles;
import org.cryptomator.cryptofs.OpenCryptoFiles_Factory;
import org.cryptomator.cryptofs.PathMatcherFactory;
import org.cryptomator.cryptofs.PathMatcherFactory_Factory;
import org.cryptomator.cryptofs.RootDirectoryInitializer;
import org.cryptomator.cryptofs.RootDirectoryInitializer_Factory;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.FileHeader;

public final class DaggerCryptoFileSystemProviderComponent
implements CryptoFileSystemProviderComponent {
    private Provider<CryptoFileSystemProviderComponent> cryptoFileSystemProviderComponentProvider;
    private Provider<CryptoFileSystems> cryptoFileSystemsProvider;
    private Provider<CopyOperation> copyOperationProvider;
    private Provider<MoveOperation> moveOperationProvider;
    private Provider<CryptorProvider> provideCryptorProvider;
    private Provider<CryptoFileSystemProvider> provideCryptoFileSystemProvider;
    private Provider<FinallyUtil> finallyUtilProvider;
    private Provider<GlobToRegexConverter> globToRegexConverterProvider;
    private Provider<PathMatcherFactory> pathMatcherFactoryProvider;
    private Provider<CryptoPathFactory> cryptoPathFactoryProvider;

    private DaggerCryptoFileSystemProviderComponent(Builder builder) {
        assert (builder != null);
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.cryptoFileSystemProviderComponentProvider = InstanceFactory.create(this);
        this.cryptoFileSystemsProvider = DoubleCheck.provider(CryptoFileSystems_Factory.create(this.cryptoFileSystemProviderComponentProvider));
        this.copyOperationProvider = DoubleCheck.provider(CopyOperation_Factory.create());
        this.moveOperationProvider = DoubleCheck.provider(MoveOperation_Factory.create(this.copyOperationProvider));
        this.provideCryptorProvider = DoubleCheck.provider(CryptoFileSystemProviderModule_ProvideCryptorProviderFactory.create(builder.cryptoFileSystemProviderModule));
        this.provideCryptoFileSystemProvider = DoubleCheck.provider(CryptoFileSystemProviderModule_ProvideCryptoFileSystemProviderFactory.create(builder.cryptoFileSystemProviderModule));
        this.finallyUtilProvider = DoubleCheck.provider(FinallyUtil_Factory.create());
        this.globToRegexConverterProvider = DoubleCheck.provider(GlobToRegexConverter_Factory.create());
        this.pathMatcherFactoryProvider = DoubleCheck.provider(PathMatcherFactory_Factory.create(this.globToRegexConverterProvider));
        this.cryptoPathFactoryProvider = DoubleCheck.provider(CryptoPathFactory_Factory.create());
    }

    @Override
    public CryptoFileSystems fileSystems() {
        return this.cryptoFileSystemsProvider.get();
    }

    @Override
    public CopyOperation copyOperation() {
        return this.copyOperationProvider.get();
    }

    @Override
    public MoveOperation moveOperation() {
        return this.moveOperationProvider.get();
    }

    @Override
    public CryptoFileSystemComponent newCryptoFileSystemComponent(CryptoFileSystemModule cryptoFileSystemModule) {
        return new CryptoFileSystemComponentImpl(cryptoFileSystemModule);
    }

    private final class CryptoFileSystemComponentImpl
    implements CryptoFileSystemComponent {
        private final CryptoFileSystemModule cryptoFileSystemModule;
        private Provider<Path> providePathToVaultProvider;
        private Provider<CryptoFileSystemProperties> provideCryptoFileSystemPropertiesProvider;
        private Provider<Cryptor> provideCryptorProvider;
        private Provider<CryptoFileAttributeProvider> cryptoFileAttributeProvider;
        private Provider<CryptoFileAttributeViewProvider> cryptoFileAttributeViewProvider;
        private Provider<CryptoFileStore> cryptoFileStoreProvider;
        private Provider<CryptoFileSystemComponent> cryptoFileSystemComponentProvider;
        private Provider<OpenCryptoFiles> openCryptoFilesProvider;
        private Provider<DirectoryIdLoader> directoryIdLoaderProvider;
        private Provider<DirectoryIdProvider> directoryIdProvider;
        private Provider<LongFileNameProvider> longFileNameProvider;
        private Provider<CryptoPathMapper> cryptoPathMapperProvider;
        private Provider<CryptoFileSystemStats> cryptoFileSystemStatsProvider;
        private Provider<RootDirectoryInitializer> rootDirectoryInitializerProvider;
        private Provider<CryptoFileAttributeByNameProvider> cryptoFileAttributeByNameProvider;
        private Provider<ConflictResolver> conflictResolverProvider;
        private Provider<DirectoryStreamFactory> directoryStreamFactoryProvider;
        private Provider<CryptoFileSystemImpl> cryptoFileSystemImplProvider;

        private CryptoFileSystemComponentImpl(CryptoFileSystemModule cryptoFileSystemModule) {
            this.cryptoFileSystemModule = Preconditions.checkNotNull(cryptoFileSystemModule);
            this.initialize();
        }

        private void initialize() {
            this.providePathToVaultProvider = DoubleCheck.provider(CryptoFileSystemModule_ProvidePathToVaultFactory.create(this.cryptoFileSystemModule));
            this.provideCryptoFileSystemPropertiesProvider = DoubleCheck.provider(CryptoFileSystemModule_ProvideCryptoFileSystemPropertiesFactory.create(this.cryptoFileSystemModule));
            this.provideCryptorProvider = DoubleCheck.provider(CryptoFileSystemModule_ProvideCryptorFactory.create(this.cryptoFileSystemModule, DaggerCryptoFileSystemProviderComponent.this.provideCryptorProvider, this.providePathToVaultProvider, this.provideCryptoFileSystemPropertiesProvider));
            this.cryptoFileAttributeProvider = DoubleCheck.provider(CryptoFileAttributeProvider_Factory.create(this.provideCryptorProvider));
            this.cryptoFileAttributeViewProvider = DoubleCheck.provider(CryptoFileAttributeViewProvider_Factory.create(this.cryptoFileAttributeProvider));
            this.cryptoFileStoreProvider = DoubleCheck.provider(CryptoFileStore_Factory.create(MembersInjectors.noOp(), this.providePathToVaultProvider, this.cryptoFileAttributeViewProvider));
            this.cryptoFileSystemComponentProvider = InstanceFactory.create(this);
            this.openCryptoFilesProvider = DoubleCheck.provider(OpenCryptoFiles_Factory.create(this.cryptoFileSystemComponentProvider, DaggerCryptoFileSystemProviderComponent.this.finallyUtilProvider));
            this.directoryIdLoaderProvider = DoubleCheck.provider(DirectoryIdLoader_Factory.create(MembersInjectors.noOp()));
            this.directoryIdProvider = DoubleCheck.provider(DirectoryIdProvider_Factory.create(this.directoryIdLoaderProvider));
            this.longFileNameProvider = DoubleCheck.provider(LongFileNameProvider_Factory.create(this.providePathToVaultProvider));
            this.cryptoPathMapperProvider = DoubleCheck.provider(CryptoPathMapper_Factory.create(this.providePathToVaultProvider, this.provideCryptorProvider, this.directoryIdProvider, this.longFileNameProvider));
            this.cryptoFileSystemStatsProvider = DoubleCheck.provider(CryptoFileSystemStats_Factory.create());
            this.rootDirectoryInitializerProvider = DoubleCheck.provider(RootDirectoryInitializer_Factory.create(this.cryptoPathMapperProvider));
            this.cryptoFileAttributeByNameProvider = DoubleCheck.provider(CryptoFileAttributeByNameProvider_Factory.create(this.cryptoFileAttributeProvider, this.cryptoFileAttributeViewProvider));
            this.conflictResolverProvider = DoubleCheck.provider(ConflictResolver_Factory.create(this.longFileNameProvider, this.provideCryptorProvider));
            this.directoryStreamFactoryProvider = DoubleCheck.provider(DirectoryStreamFactory_Factory.create(this.provideCryptorProvider, this.longFileNameProvider, this.conflictResolverProvider, this.cryptoPathMapperProvider, DaggerCryptoFileSystemProviderComponent.this.finallyUtilProvider));
            this.cryptoFileSystemImplProvider = DoubleCheck.provider(CryptoFileSystemImpl_Factory.create(MembersInjectors.noOp(), this.providePathToVaultProvider, this.provideCryptoFileSystemPropertiesProvider, this.provideCryptorProvider, DaggerCryptoFileSystemProviderComponent.this.provideCryptoFileSystemProvider, DaggerCryptoFileSystemProviderComponent.this.cryptoFileSystemsProvider, this.cryptoFileStoreProvider, this.openCryptoFilesProvider, this.cryptoPathMapperProvider, this.directoryIdProvider, this.cryptoFileAttributeProvider, this.cryptoFileAttributeViewProvider, DaggerCryptoFileSystemProviderComponent.this.pathMatcherFactoryProvider, DaggerCryptoFileSystemProviderComponent.this.cryptoPathFactoryProvider, this.cryptoFileSystemStatsProvider, this.rootDirectoryInitializerProvider, this.cryptoFileAttributeByNameProvider, this.directoryStreamFactoryProvider, DaggerCryptoFileSystemProviderComponent.this.finallyUtilProvider));
        }

        @Override
        public CryptoFileSystemImpl cryptoFileSystem() {
            return this.cryptoFileSystemImplProvider.get();
        }

        @Override
        public OpenCryptoFileComponent newOpenCryptoFileComponent(OpenCryptoFileModule openCryptoFileModule) {
            return new OpenCryptoFileComponentImpl(openCryptoFileModule);
        }

        private final class OpenCryptoFileComponentImpl
        implements OpenCryptoFileComponent {
            private final OpenCryptoFileModule openCryptoFileModule;
            private final OpenCryptoFileFactoryModule openCryptoFileFactoryModule;
            private Provider<EffectiveOpenOptions> provideOptionsProvider;
            private Provider<Path> providePathProvider;
            private Provider<FileChannel> provideFileChannelProvider;
            private Provider<FileHeader> provideFileHaderProvider;
            private Provider<AtomicLong> provideFileSizeProvider;
            private Provider<OpenCounter> openCounterProvider;
            private Provider<CryptoFileChannelFactory> cryptoFileChannelFactoryProvider;
            private Provider<ChunkLoader> chunkLoaderProvider;
            private Provider<ExceptionsDuringWrite> exceptionsDuringWriteProvider;
            private Provider<ChunkSaver> chunkSaverProvider;
            private Provider<ChunkCache> chunkCacheProvider;
            private Provider<Runnable> provideOnCloseProvider;
            private Provider<OpenCryptoFile> openCryptoFileProvider;

            private OpenCryptoFileComponentImpl(OpenCryptoFileModule openCryptoFileModule) {
                this.openCryptoFileModule = Preconditions.checkNotNull(openCryptoFileModule);
                this.openCryptoFileFactoryModule = new OpenCryptoFileFactoryModule();
                this.initialize();
            }

            private void initialize() {
                this.provideOptionsProvider = DoubleCheck.provider(OpenCryptoFileModule_ProvideOptionsFactory.create(this.openCryptoFileModule));
                this.providePathProvider = DoubleCheck.provider(OpenCryptoFileModule_ProvidePathFactory.create(this.openCryptoFileModule));
                this.provideFileChannelProvider = DoubleCheck.provider(OpenCryptoFileFactoryModule_ProvideFileChannelFactory.create(this.openCryptoFileFactoryModule, this.providePathProvider, this.provideOptionsProvider));
                this.provideFileHaderProvider = DoubleCheck.provider(OpenCryptoFileFactoryModule_ProvideFileHaderFactory.create(this.openCryptoFileFactoryModule, this.provideFileChannelProvider, CryptoFileSystemComponentImpl.this.provideCryptorProvider, this.provideOptionsProvider));
                this.provideFileSizeProvider = DoubleCheck.provider(OpenCryptoFileFactoryModule_ProvideFileSizeFactory.create(this.openCryptoFileFactoryModule, this.provideFileChannelProvider, CryptoFileSystemComponentImpl.this.provideCryptorProvider));
                this.openCounterProvider = DoubleCheck.provider(OpenCounter_Factory.create());
                this.cryptoFileChannelFactoryProvider = DoubleCheck.provider(CryptoFileChannelFactory_Factory.create(DaggerCryptoFileSystemProviderComponent.this.finallyUtilProvider));
                this.chunkLoaderProvider = DoubleCheck.provider(ChunkLoader_Factory.create(CryptoFileSystemComponentImpl.this.provideCryptorProvider, this.provideFileChannelProvider, this.provideFileHaderProvider, CryptoFileSystemComponentImpl.this.cryptoFileSystemStatsProvider));
                this.exceptionsDuringWriteProvider = DoubleCheck.provider(ExceptionsDuringWrite_Factory.create());
                this.chunkSaverProvider = DoubleCheck.provider(ChunkSaver_Factory.create(CryptoFileSystemComponentImpl.this.provideCryptorProvider, this.provideFileChannelProvider, this.provideFileHaderProvider, this.exceptionsDuringWriteProvider, this.provideFileSizeProvider, CryptoFileSystemComponentImpl.this.cryptoFileSystemStatsProvider));
                this.chunkCacheProvider = DoubleCheck.provider(ChunkCache_Factory.create(this.chunkLoaderProvider, this.chunkSaverProvider, CryptoFileSystemComponentImpl.this.cryptoFileSystemStatsProvider));
                this.provideOnCloseProvider = DoubleCheck.provider(OpenCryptoFileModule_ProvideOnCloseFactory.create(this.openCryptoFileModule));
                this.openCryptoFileProvider = DoubleCheck.provider(OpenCryptoFile_Factory.create(this.provideOptionsProvider, CryptoFileSystemComponentImpl.this.provideCryptorProvider, this.provideFileChannelProvider, this.provideFileHaderProvider, this.provideFileSizeProvider, this.openCounterProvider, this.cryptoFileChannelFactoryProvider, this.chunkCacheProvider, this.provideOnCloseProvider, CryptoFileSystemComponentImpl.this.cryptoFileSystemStatsProvider));
            }

            @Override
            public OpenCryptoFile openCryptoFile() {
                return this.openCryptoFileProvider.get();
            }
        }
    }

    public static final class Builder {
        private CryptoFileSystemProviderModule cryptoFileSystemProviderModule;

        private Builder() {
        }

        public CryptoFileSystemProviderComponent build() {
            if (this.cryptoFileSystemProviderModule == null) {
                throw new IllegalStateException(CryptoFileSystemProviderModule.class.getCanonicalName() + " must be set");
            }
            return new DaggerCryptoFileSystemProviderComponent(this);
        }

        public Builder cryptoFileSystemProviderModule(CryptoFileSystemProviderModule cryptoFileSystemProviderModule) {
            this.cryptoFileSystemProviderModule = Preconditions.checkNotNull(cryptoFileSystemProviderModule);
            return this;
        }
    }
}

